/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.heap;

import com.xzchaoo.commons.basic.heap.NodeFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Heap<N> {
    private final List<N> nodes = new ArrayList<N>();
    private final NodeFunction<N> nf;

    public Heap(NodeFunction<N> nf) {
        this.nf = Objects.requireNonNull(nf);
    }

    public void init() {
        for (int i = this.size() / 2; i >= 0; --i) {
            this.siftDown(this.nodes.get(i));
        }
    }

    public void initPush(N n) {
        this.nf.setIndex(n, this.nodes.size());
        this.nodes.add(n);
    }

    public N peek() {
        return this.nodes.isEmpty() ? null : (N)this.nodes.get(0);
    }

    public N pop() {
        int size = this.nodes.size();
        if (size == 0) {
            throw new IllegalStateException("heap is empty");
        }
        N n = this.nodes.get(0);
        if (size == 1) {
            this.nodes.clear();
        } else {
            N last = this.nodes.remove(size - 1);
            this.nodes.set(0, last);
            this.nf.setIndex(last, 0);
            this.siftDown(last);
        }
        return n;
    }

    public void push(N n) {
        this.nf.setIndex(n, this.nodes.size());
        this.nodes.add(n);
        this.siftUp(n);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public void update(N n) {
        int oldIndex = this.nf.getIndex(n);
        this.siftUp(n);
        if (oldIndex == this.nf.getIndex(n)) {
            this.siftDown(n);
        }
    }

    private void siftDown(N node) {
        int index = this.nf.getIndex(node);
        int ns = this.nodes.size();
        int downIndex = (index << 1) + 1;
        while (downIndex < ns) {
            N downNode2;
            N downNode = this.nodes.get(downIndex);
            int downIndex2 = downIndex + 1;
            if (downIndex2 < ns && this.nf.compare(downNode2 = this.nodes.get(downIndex2), downNode) < 0) {
                downIndex = downIndex2;
                downNode = downNode2;
            }
            if (this.nf.compare(downNode, node) >= 0) break;
            this.nodes.set(index, downNode);
            this.nf.setIndex(downNode, index);
            index = downIndex;
            downIndex = (downIndex << 1) + 1;
        }
        this.nodes.set(index, node);
        this.nf.setIndex(node, index);
    }

    private void siftUp(N node) {
        int upIndex;
        N upNode;
        int index = this.nf.getIndex(node);
        while (index > 0 && this.nf.compare(node, upNode = this.nodes.get(upIndex = index - 1 >> 1)) < 0) {
            this.nodes.set(index, upNode);
            this.nf.setIndex(upNode, index);
            index = upIndex;
        }
        this.nodes.set(index, node);
        this.nf.setIndex(node, index);
    }
}

