/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;

public class JsonNodeUtils {
    private JsonNodeUtils() {
    }

    public static ObjectNode merge(ObjectNode a, ObjectNode b) {
        ObjectNode cp = a.deepCopy();
        JsonNodeUtils.mergeTo(cp, b);
        return cp;
    }

    public static void mergeTo(ObjectNode to, ObjectNode o) {
        if (o == null || o.isEmpty() || o.isMissingNode()) {
            return;
        }
        for (Map.Entry e : o.properties()) {
            JsonNode exist = to.get((String)e.getKey());
            if (exist == null) {
                to.set((String)e.getKey(), ((JsonNode)e.getValue()).deepCopy());
                continue;
            }
            JsonNode v = (JsonNode)e.getValue();
            if (exist.isObject() && !v.isObject()) {
                throw new IllegalArgumentException("incompatible types");
            }
            if (exist.isArray() && !v.isArray()) {
                throw new IllegalArgumentException("incompatible types");
            }
            if (exist.isObject()) {
                JsonNodeUtils.mergeTo((ObjectNode)exist, (ObjectNode)v);
                continue;
            }
            to.set((String)e.getKey(), ((JsonNode)e.getValue()).deepCopy());
        }
    }
}

