/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.objectconfig;

import com.xzchaoo.commons.basic.objectconfig.BizConfigHolder;
import com.xzchaoo.commons.basic.objectconfig.BizConfigHooks;
import com.xzchaoo.commons.basic.objectconfig.Config;
import com.xzchaoo.commons.basic.objectconfig.ConfigFactory;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BizConfigHolderImpl<T>
implements BizConfigHolder<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BizConfigHolderImpl.class);
    private final Config config;
    private final String jsonPointer;
    private final Class<T> clazz;
    private final Runnable unListen;
    private volatile T biz;
    private final CopyOnWriteArrayList<Runnable> listeners = new CopyOnWriteArrayList();

    BizConfigHolderImpl(Config config, String jsonPointer, Class<T> clazz) {
        this.config = Objects.requireNonNull(config);
        this.jsonPointer = jsonPointer;
        this.clazz = Objects.requireNonNull(clazz);
        this.update();
        this.unListen = config.listen(this::update);
    }

    @Override
    public T get() {
        return this.biz;
    }

    @Override
    public void unbind() {
        this.unListen.run();
    }

    @Override
    public Runnable listen(Runnable listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }

    private void update() {
        T newBiz = ConfigFactory.bindOnce(this.config.get(), this.jsonPointer, this.clazz);
        if (newBiz instanceof BizConfigHooks) {
            BizConfigHooks h = (BizConfigHooks)newBiz;
            h.validate();
        }
        this.biz = newBiz;
        this.fire();
    }

    private void fire() {
        for (Runnable listener : this.listeners) {
            try {
                listener.run();
            }
            catch (Exception e) {
                log.error("listener error", (Throwable)e);
            }
        }
    }
}

