/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.objectconfig;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xzchaoo.commons.basic.json.JsonNodeUtils;
import com.xzchaoo.commons.basic.objectconfig.AbstractConfig;
import com.xzchaoo.commons.basic.objectconfig.Config;
import com.xzchaoo.commons.basic.objectconfig.ConfigFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Composite
extends AbstractConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Composite.class);
    private final List<Config> configs;
    private volatile ObjectNode merged = ConfigFactory.JSON_OM.createObjectNode();
    private final Lock lock = new ReentrantLock();

    Composite(List<Config> configs) {
        this.configs = Objects.requireNonNull(configs);
        for (Config config : configs) {
            config.listen(this::update);
        }
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        this.lock.lock();
        try {
            ObjectNode merged = ConfigFactory.JSON_OM.createObjectNode();
            for (Config cfg : this.configs) {
                try {
                    JsonNodeUtils.mergeTo(merged, cfg.get());
                }
                catch (Exception e) {
                    log.error("merge config error", (Throwable)e);
                }
            }
            this.merged = merged;
            this.fire();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public ObjectNode get() {
        return this.merged;
    }
}

