/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.objectconfig;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.xzchaoo.commons.basic.objectconfig.BizConfigHolder;
import com.xzchaoo.commons.basic.objectconfig.BizConfigHolderImpl;
import com.xzchaoo.commons.basic.objectconfig.Composite;
import com.xzchaoo.commons.basic.objectconfig.Config;
import com.xzchaoo.commons.basic.objectconfig.ConstConfig;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ConfigFactory {
    public static final ObjectMapper JSON_OM = new ObjectMapper();
    public static final YAMLMapper YAML_M = new YAMLMapper();

    private ConfigFactory() {
    }

    public static Config fromNode(ObjectNode node) {
        return new ConstConfig(node.deepCopy());
    }

    public static Config fromJson(File file) {
        return ConfigFactory.fromNode(JSON_OM.readTree(file), false);
    }

    public static Config fromJson(String content) {
        return ConfigFactory.fromNode(JSON_OM.readTree(content), false);
    }

    public static Config fromYaml(File file) {
        return ConfigFactory.fromNode(YAML_M.readTree(file), false);
    }

    public static Config fromYaml(String content) {
        return ConfigFactory.fromNode(YAML_M.readTree(content), false);
    }

    public static Config fromYaml(InputStream is) {
        return ConfigFactory.fromNode(YAML_M.readTree(is), false);
    }

    public static Config fromNode(JsonNode node) {
        return ConfigFactory.fromNode(node, true);
    }

    private static Config fromNode(JsonNode node, boolean copy) {
        if (node.isEmpty()) {
            node = JSON_OM.createObjectNode();
        }
        if (!node.isObject()) {
            throw new IllegalStateException("node is not ObjectNode");
        }
        return new ConstConfig(copy ? (ObjectNode)node.deepCopy() : (ObjectNode)node);
    }

    public static Config composite(Config ... configs) {
        return new Composite(new ArrayList<Config>(Arrays.asList(configs)));
    }

    public static Config composite(List<Config> configs) {
        return new Composite(new ArrayList<Config>(configs));
    }

    public static <T> T bindOnce(ObjectNode node, String jsonPointer, Class<T> clazz) {
        ObjectNode at;
        Object object = at = jsonPointer != null ? node.at(jsonPointer) : node;
        if (at.isMissingNode()) {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (!at.isObject()) {
            throw new IllegalStateException("node is not ObjectNode");
        }
        return ConfigFactory.bindOnce(at, clazz);
    }

    public static <T> T bindOnce(ObjectNode node, Class<T> clazz) {
        return (T)JSON_OM.treeToValue((TreeNode)node, clazz);
    }

    public static <T> T bindOnce(Config cfg, Class<T> clazz) {
        return (T)JSON_OM.treeToValue((TreeNode)cfg.get(), clazz);
    }

    public static <T> BizConfigHolder<T> bind(Config config, String jsonPointer, Class<T> clazz) {
        return new BizConfigHolderImpl<T>(config, jsonPointer, clazz);
    }

    static {
        JSON_OM.findAndRegisterModules();
        JSON_OM.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        JSON_OM.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        YAML_M.findAndRegisterModules();
        YAML_M.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        YAML_M.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

