/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.topology;

import com.xzchaoo.commons.basic.Ack;
import com.xzchaoo.commons.basic.drainloop.DrainLoop;
import com.xzchaoo.commons.basic.topology.NodeFunction;
import com.xzchaoo.commons.basic.topology.TopologyExecutor3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jctools.queues.MpscArrayQueue;

public class DrainLoopTopologyExecutor3<N>
extends DrainLoop
implements TopologyExecutor3<N> {
    private final NodeFunction<N> nf;
    private final Map<String, GNode<N>> nodes = new HashMap<String, GNode<N>>();
    private final Map<String, List<String>> edges = new HashMap<String, List<String>>();
    private final MpscArrayQueue<GNode<N>> ackQ = new MpscArrayQueue(65536);
    private LinkedList<GNode<N>> q;
    private BiConsumer<N, Ack> consumer;
    private Runnable complete;
    private int ackCount;
    private int maxWip;
    private int wip;

    public DrainLoopTopologyExecutor3(NodeFunction<N> nf, int maxWip) {
        this.nf = nf;
        this.maxWip = maxWip;
    }

    @Override
    public void add(N from, N to) {
        String fromId = this.nf.id(from);
        String toId = this.nf.id(to);
        GNode fromNode = this.nodes.computeIfAbsent(fromId, ignored -> new GNode<Object>(fromId, from));
        GNode toNode = this.nodes.computeIfAbsent(toId, ignored -> new GNode<Object>(toId, to));
        ++fromNode.out;
        ++toNode.in;
        this.edges.computeIfAbsent(fromId, ignored -> new ArrayList()).add(toId);
    }

    @Override
    public List<N> check() {
        LinkedList<GNode<N>> q = new LinkedList<GNode<N>>();
        int visited = 0;
        for (GNode<N> gNode : this.nodes.values()) {
            gNode.inBackup = gNode.in;
            gNode.outBackup = gNode.out;
            if (gNode.in != 0) continue;
            q.addLast(gNode);
        }
        LinkedList result = new LinkedList();
        while (!q.isEmpty()) {
            GNode gNode = (GNode)q.removeFirst();
            ++visited;
            result.add(gNode.n);
            List<String> toIdList = this.edges.get(gNode.id);
            if (toIdList == null) continue;
            for (String toId : toIdList) {
                GNode<N> to = this.nodes.get(toId);
                if (--to.in != 0) continue;
                q.addLast(to);
            }
        }
        if (visited != this.nodes.size()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (GNode gNode : this.nodes.values()) {
                if (gNode.in == 0) continue;
                stringBuilder.append(gNode.id).append(',');
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            throw new IllegalStateException("not DAG, remain nodes = " + stringBuilder);
        }
        for (GNode<N> gn : this.nodes.values()) {
            gn.in = gn.inBackup;
            gn.out = gn.outBackup;
        }
        return result;
    }

    @Override
    public void execute(BiConsumer<N, Ack> consumer, Runnable complete) {
        this.consumer = consumer;
        this.complete = complete;
        this.q = new LinkedList();
        for (GNode<N> gn : this.nodes.values()) {
            if (gn.in != 0) continue;
            this.q.add(gn);
        }
        this.drainLoop();
    }

    private void ack(GNode<N> gn) {
        System.out.println("ack");
        if (!this.ackQ.offer(gn)) {
            throw new IllegalStateException("ack queue is full");
        }
        this.drainLoop();
    }

    private boolean consumeAcks() {
        GNode gn;
        while ((gn = (GNode)this.ackQ.relaxedPoll()) != null) {
            --this.wip;
            List<String> toList = this.edges.get(gn.id);
            if (toList != null) {
                for (String toId : toList) {
                    GNode<N> toNode = this.nodes.get(toId);
                    if (--toNode.in != 0) continue;
                    this.q.addLast(toNode);
                }
            }
            if (++this.ackCount != this.nodes.size()) continue;
            this.complete.run();
        }
        return true;
    }

    private boolean consumeRoots() {
        while (this.wip != this.maxWip) {
            GNode<N> gn = this.q.pollFirst();
            if (gn == null) {
                return true;
            }
            ++this.wip;
            this.internalExecute(gn);
        }
        return false;
    }

    @Override
    protected void drainLoop0() {
        boolean rootEmpty;
        boolean ackEmpty;
        do {
            ackEmpty = this.consumeAcks();
            rootEmpty = this.consumeRoots();
        } while (!ackEmpty || !rootEmpty);
    }

    private void internalExecute(GNode<N> gn) {
        this.consumer.accept(gn.n, Ack.once(() -> this.ack(gn)));
    }

    static class GNode<N> {
        final String id;
        final N n;
        int in;
        int out;
        int inBackup;
        int outBackup;

        GNode(String id, N n) {
            this.id = id;
            this.n = n;
        }
    }
}

