/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.basic.topology.sort;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TopologySort<N> {
    private final NodeFunction<N> nf;
    private final Map<Object, TNode> nodes = new HashMap<Object, TNode>();
    private final Map<Object, List<TNode>> edges = new HashMap<Object, List<TNode>>();

    public TopologySort(NodeFunction<N> nf) {
        this.nf = Objects.requireNonNull(nf);
    }

    public void addNode(N n) {
        Preconditions.checkArgument((n != null ? 1 : 0) != 0, (Object)"node is null");
        Object id = this.nf.id(n);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        TNode tn = this.nodes.get(id);
        if (tn == null) {
            this.nodes.put(id, new TNode(id, n));
        }
    }

    public void addEdge(N from, N to) {
        Preconditions.checkArgument((from != null ? 1 : 0) != 0, (Object)"from is null");
        Preconditions.checkArgument((to != null ? 1 : 0) != 0, (Object)"to is null");
        Object fromId = this.nf.id(from);
        Preconditions.checkArgument((fromId != null ? 1 : 0) != 0, (Object)"fromId is null");
        Object toId = this.nf.id(to);
        Preconditions.checkArgument((toId != null ? 1 : 0) != 0, (Object)"toId is null");
        TNode fromNode = this.nodes.computeIfAbsent(fromId, ignored -> new TNode(fromId, from));
        TNode toNode = this.nodes.computeIfAbsent(toId, ignored -> new TNode(toId, to));
        ++fromNode.out;
        ++toNode.in;
        this.edges.computeIfAbsent(fromId, ignored -> new ArrayList()).add(toNode);
    }

    public List<N> sort() {
        LinkedList<TNode> q = new LinkedList<TNode>();
        for (TNode tn : this.nodes.values()) {
            if (tn.in != 0) continue;
            q.add(tn);
        }
        if (q.isEmpty()) {
            throw new IllegalStateException("fail to find roots with in = 0");
        }
        int visited = 0;
        ArrayList result = new ArrayList(this.nodes.size());
        while (!q.isEmpty()) {
            ++visited;
            TNode tn = (TNode)q.removeFirst();
            result.add(tn.n);
            List<TNode> toNodes = this.edges.get(tn.id);
            if (toNodes == null) continue;
            for (TNode to : toNodes) {
                if (--to.in != 0) continue;
                q.addLast(to);
            }
        }
        if (visited != this.nodes.size()) {
            throw new IllegalStateException("not a DAG");
        }
        return result;
    }

    private class TNode {
        final Object id;
        final N n;
        int in;
        int out;

        TNode(Object id, N n) {
            this.id = id;
            this.n = n;
        }
    }

    public static interface NodeFunction<N> {
        public Object id(N var1);
    }
}

