/*
 * Decompiled with CFR 0.152.
 */
package com.xzchaoo.commons.concurrent;

import com.xzchaoo.commons.concurrent.KeyedExecutor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedExecutorImpl<Key>
implements KeyedExecutor<Key> {
    private static final Logger log = LoggerFactory.getLogger(KeyedExecutorImpl.class);
    private final Executor executor;
    private final Lock lock = new ReentrantLock();
    final Map<Key, Queue> queues = new HashMap<Key, Queue>();

    public KeyedExecutorImpl(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Key key, Runnable r) {
        this.lock.lock();
        try {
            Queue q = this.queues.get(key);
            if (q == null) {
                Queue q2 = new Queue(key);
                this.queues.put(key, q2);
                this.executor.execute(() -> q2.drain(r));
            } else {
                if (q.pending == null) {
                    q.pending = new LinkedBlockingQueue();
                }
                q.pending.add(r);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean remove(Queue q) {
        this.lock.lock();
        try {
            if (q.pending == null || q.pending.isEmpty()) {
                this.queues.remove(q.key);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    private class Queue {
        final Key key;
        LinkedBlockingQueue<Runnable> pending;

        Queue(Key key) {
            this.key = key;
        }

        void drain(Runnable first) {
            this.run(first);
            if (KeyedExecutorImpl.this.remove(this)) {
                return;
            }
            while (true) {
                Runnable r;
                if ((r = this.pending.poll()) != null) {
                    this.run(r);
                    continue;
                }
                if (KeyedExecutorImpl.this.remove(this)) break;
            }
        }

        void run(Runnable r) {
            try {
                r.run();
            }
            catch (Exception e) {
                log.error("run error", (Throwable)e);
            }
        }
    }
}

