/*
 * Decompiled with CFR 0.152.
 */
package com.oath.auth;

import com.oath.auth.KeyRefresherException;
import com.oath.auth.KeyStoreProvider;
import com.oath.auth.Utils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.function.Supplier;

class CaCertKeyStoreProvider
implements KeyStoreProvider {
    private final String caCertFilePath;
    private final Supplier<InputStream> caCertsInputStream;

    public CaCertKeyStoreProvider(String caCertFilePath) {
        this.caCertFilePath = caCertFilePath;
        this.caCertsInputStream = null;
    }

    public CaCertKeyStoreProvider(Supplier<InputStream> caCertsInputStream) {
        this.caCertsInputStream = caCertsInputStream;
        this.caCertFilePath = null;
    }

    @Override
    public KeyStore provide() throws KeyRefresherException, IOException {
        KeyStore keyStore;
        if (this.caCertFilePath != null) {
            try (FileInputStream inputStream = new FileInputStream(this.caCertFilePath);){
                keyStore = Utils.generateTrustStore(inputStream);
            }
        } else {
            keyStore = Utils.generateTrustStore(this.caCertsInputStream.get());
        }
        return keyStore;
    }
}

