/*
 * Decompiled with CFR 0.152.
 */
package com.oath.auth;

import com.oath.auth.KeyRefresherException;
import com.oath.auth.KeyStoreProvider;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class TrustStore {
    private final String filePath;
    private final KeyStoreProvider keyStoreProvider;

    public TrustStore(String filePath, KeyStoreProvider keyStoreProvider) {
        this.filePath = filePath;
        this.keyStoreProvider = keyStoreProvider;
    }

    public TrustManager[] getTrustManagers() throws KeyRefresherException, IOException {
        TrustManagerFactory trustManagerFactory;
        KeyStore keystore = this.keyStoreProvider.provide();
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyRefresherException("No Provider supports a TrustManagerFactorySpi implementation for the specified algorithm.", e);
        }
        catch (KeyStoreException e) {
            throw new KeyRefresherException("Unable to generate TrustManagerFactory.", e);
        }
        return trustManagerFactory.getTrustManagers();
    }

    public String getFilePath() {
        return this.filePath;
    }
}

