/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.common.utils;

import com.yahoo.athenz.zms.Assertion;
import com.yahoo.athenz.zms.DomainData;
import com.yahoo.athenz.zms.DomainPolicies;
import com.yahoo.athenz.zms.Group;
import com.yahoo.athenz.zms.GroupMember;
import com.yahoo.athenz.zms.Policy;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zms.Role;
import com.yahoo.athenz.zms.RoleMember;
import com.yahoo.athenz.zms.ServiceIdentity;
import com.yahoo.athenz.zms.SignedPolicies;
import com.yahoo.athenz.zts.PolicyData;
import com.yahoo.athenz.zts.SignedPolicyData;
import com.yahoo.rdl.Array;
import com.yahoo.rdl.Struct;
import java.util.List;

public class SignUtils {
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_MODIFIED = "modified";
    private static final String ATTR_POLICIES = "policies";
    private static final String ATTR_DOMAIN = "domain";
    private static final String ATTR_EXPIRES = "expires";
    private static final String ATTR_POLICY_DATA = "policyData";
    private static final String ATTR_ZMS_SIGNATURE = "zmsSignature";
    private static final String ATTR_ZMS_KEY_ID = "zmsKeyId";
    private static final String ATTR_MEMBERS = "members";
    private static final String ATTR_ROLE_MEMBERS = "roleMembers";
    private static final String ATTR_GROUP_MEMBERS = "groupMembers";
    private static final String ATTR_MEMBER_NAME = "memberName";
    private static final String ATTR_GROUP_NAME = "groupName";
    private static final String ATTR_SYSTEM_DISABLED = "systemDisabled";
    private static final String ATTR_EXPIRATION = "expiration";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ROLE = "role";
    private static final String ATTR_SERVICES = "services";
    private static final String ATTR_ID = "id";
    private static final String ATTR_PUBLIC_KEYS = "publicKeys";
    private static final String ATTR_ACCOUNT = "account";
    private static final String ATTR_YPMID = "ypmId";
    private static final String ATTR_EFFECT = "effect";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_RESOURCE = "resource";
    private static final String ATTR_ASSERTIONS = "assertions";
    private static final String ATTR_EXECUTABLE = "executable";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_TRUST = "trust";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_PROVIDER_ENDPOINT = "providerEndpoint";
    private static final String ATTR_USER = "user";
    private static final String ATTR_HOSTS = "hosts";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_ROLES = "roles";
    private static final String ATTR_GROUPS = "groups";
    private static final String ATTR_SIGNATURE = "signature";
    private static final String ATTR_KEYID = "keyId";
    private static final String ATTR_CONTENTS = "contents";
    private static final String ATTR_CERT_DNS_DOMAIN = "certDnsDomain";
    private static final String ATTR_AUDIT_ENABLED = "auditEnabled";
    private static final String ATTR_REVIEW_ENABLED = "reviewEnabled";
    private static final String ATTR_SELF_SERVE = "selfServe";
    private static final String ATTR_MEMBER_EXPIRY_DAYS = "memberExpiryDays";
    private static final String ATTR_TOKEN_EXPIRY_MINS = "tokenExpiryMins";
    private static final String ATTR_CERT_EXPIRY_MINS = "certExpiryMins";
    private static final String ATTR_ROLE_CERT_EXPIRY_MINS = "roleCertExpiryMins";
    private static final String ATTR_SERVICE_EXPIRY_DAYS = "serviceExpiryDays";
    private static final String ATTR_SERVICE_CERT_EXPIRY_MINS = "serviceCertExpiryMins";
    private static final String ATTR_MEMBER_REVIEW_DAYS = "memberReviewDays";
    private static final String ATTR_SERVICE_REVIEW_DAYS = "serviceReviewDays";
    private static final String ATTR_SIGN_ALGORITHM = "signAlgorithm";

    private static Struct asStruct(DomainPolicies domainPolicies) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_DOMAIN, domainPolicies.getDomain());
        Array policiesArray = new Array();
        for (Policy policy : domainPolicies.getPolicies()) {
            policiesArray.add((Object)SignUtils.asStruct(policy));
        }
        SignUtils.appendArray(struct, ATTR_POLICIES, policiesArray);
        return struct;
    }

    private static Struct asStruct(Policy policy) {
        Struct struct = new Struct();
        List assertions = policy.getAssertions();
        if (assertions != null && !assertions.isEmpty()) {
            Array assertionsArray = new Array();
            for (Assertion assertion : assertions) {
                Struct structAssertion = new Struct();
                SignUtils.appendObject(structAssertion, ATTR_ACTION, assertion.getAction());
                SignUtils.appendObject(structAssertion, ATTR_EFFECT, assertion.getEffect());
                SignUtils.appendObject(structAssertion, ATTR_RESOURCE, assertion.getResource());
                SignUtils.appendObject(structAssertion, ATTR_ROLE, assertion.getRole());
                assertionsArray.add((Object)structAssertion);
            }
            SignUtils.appendArray(struct, ATTR_ASSERTIONS, assertionsArray);
        }
        SignUtils.appendObject(struct, ATTR_MODIFIED, policy.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, policy.getName());
        return struct;
    }

    private static Struct asStruct(com.yahoo.athenz.zts.Policy policy) {
        Struct struct = new Struct();
        List assertions = policy.getAssertions();
        if (assertions != null && !assertions.isEmpty()) {
            Array assertionsArray = new Array();
            for (com.yahoo.athenz.zts.Assertion assertion : assertions) {
                Struct structAssertion = new Struct();
                SignUtils.appendObject(structAssertion, ATTR_ACTION, assertion.getAction());
                SignUtils.appendObject(structAssertion, ATTR_EFFECT, assertion.getEffect());
                SignUtils.appendObject(structAssertion, ATTR_RESOURCE, assertion.getResource());
                SignUtils.appendObject(structAssertion, ATTR_ROLE, assertion.getRole());
                assertionsArray.add((Object)structAssertion);
            }
            SignUtils.appendArray(struct, ATTR_ASSERTIONS, assertionsArray);
        }
        SignUtils.appendObject(struct, ATTR_MODIFIED, policy.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, policy.getName());
        return struct;
    }

    private static Struct asStruct(Role role) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_AUDIT_ENABLED, role.getAuditEnabled());
        SignUtils.appendObject(struct, ATTR_CERT_EXPIRY_MINS, role.getCertExpiryMins());
        SignUtils.appendObject(struct, ATTR_MEMBER_EXPIRY_DAYS, role.getMemberExpiryDays());
        SignUtils.appendObject(struct, ATTR_MEMBER_REVIEW_DAYS, role.getMemberReviewDays());
        SignUtils.appendList(struct, ATTR_MEMBERS, role.getMembers());
        SignUtils.appendObject(struct, ATTR_MODIFIED, role.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, role.getName());
        List roleMembers = role.getRoleMembers();
        if (roleMembers != null) {
            Array roleMembersArray = new Array();
            for (RoleMember roleMember : roleMembers) {
                Struct structRoleMember = new Struct();
                SignUtils.appendObject(structRoleMember, ATTR_EXPIRATION, roleMember.getExpiration());
                SignUtils.appendObject(structRoleMember, ATTR_MEMBER_NAME, roleMember.getMemberName());
                SignUtils.appendObject(structRoleMember, ATTR_SYSTEM_DISABLED, roleMember.getSystemDisabled());
                roleMembersArray.add((Object)structRoleMember);
            }
            SignUtils.appendArray(struct, ATTR_ROLE_MEMBERS, roleMembersArray);
        }
        SignUtils.appendObject(struct, ATTR_SELF_SERVE, role.getSelfServe());
        SignUtils.appendObject(struct, ATTR_SERVICE_EXPIRY_DAYS, role.getServiceExpiryDays());
        SignUtils.appendObject(struct, ATTR_SERVICE_REVIEW_DAYS, role.getServiceReviewDays());
        SignUtils.appendObject(struct, ATTR_SIGN_ALGORITHM, role.getSignAlgorithm());
        SignUtils.appendObject(struct, ATTR_TOKEN_EXPIRY_MINS, role.getTokenExpiryMins());
        SignUtils.appendObject(struct, ATTR_TRUST, role.getTrust());
        return struct;
    }

    private static Struct asStruct(Group group) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_AUDIT_ENABLED, group.getAuditEnabled());
        List groupMembers = group.getGroupMembers();
        if (groupMembers != null) {
            Array groupMembersArray = new Array();
            for (GroupMember groupMember : groupMembers) {
                Struct structRoleMember = new Struct();
                SignUtils.appendObject(structRoleMember, ATTR_EXPIRATION, groupMember.getExpiration());
                SignUtils.appendObject(structRoleMember, ATTR_GROUP_NAME, groupMember.getGroupName());
                SignUtils.appendObject(structRoleMember, ATTR_MEMBER_NAME, groupMember.getMemberName());
                SignUtils.appendObject(structRoleMember, ATTR_SYSTEM_DISABLED, groupMember.getSystemDisabled());
                groupMembersArray.add((Object)structRoleMember);
            }
            SignUtils.appendArray(struct, ATTR_GROUP_MEMBERS, groupMembersArray);
        }
        SignUtils.appendObject(struct, ATTR_MODIFIED, group.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, group.getName());
        SignUtils.appendObject(struct, ATTR_REVIEW_ENABLED, group.getReviewEnabled());
        SignUtils.appendObject(struct, ATTR_SELF_SERVE, group.getSelfServe());
        return struct;
    }

    private static Struct asStruct(ServiceIdentity service) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_DESCRIPTION, service.getDescription());
        SignUtils.appendObject(struct, ATTR_EXECUTABLE, service.getExecutable());
        SignUtils.appendObject(struct, ATTR_GROUP, service.getGroup());
        SignUtils.appendList(struct, ATTR_HOSTS, service.getHosts());
        SignUtils.appendObject(struct, ATTR_MODIFIED, service.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, service.getName());
        SignUtils.appendObject(struct, ATTR_PROVIDER_ENDPOINT, service.getProviderEndpoint());
        List publicKeys = service.getPublicKeys();
        Array publicKeysArray = new Array();
        if (publicKeys != null) {
            for (PublicKeyEntry publicKey : publicKeys) {
                Struct structPublicKey = new Struct();
                SignUtils.appendObject(structPublicKey, ATTR_ID, publicKey.getId());
                SignUtils.appendObject(structPublicKey, ATTR_KEY, publicKey.getKey());
                publicKeysArray.add((Object)structPublicKey);
            }
        }
        SignUtils.appendArray(struct, ATTR_PUBLIC_KEYS, publicKeysArray);
        SignUtils.appendObject(struct, ATTR_USER, service.getUser());
        return struct;
    }

    private static void appendList(Struct struct, String name, List<String> list) {
        if (list == null) {
            return;
        }
        Array items = new Array();
        items.addAll(list);
        SignUtils.appendArray(struct, name, items);
    }

    private static void appendObject(Struct struct, String name, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Struct) {
            struct.append(name, value);
        } else if (value instanceof String) {
            struct.append(name, value);
        } else if (value instanceof Integer) {
            struct.append(name, value);
        } else if (value instanceof Boolean) {
            struct.append(name, value);
        } else {
            struct.append(name, (Object)value.toString());
        }
    }

    private static void appendArray(Struct struct, String name, Array array) {
        struct.append(name, (Object)array);
    }

    private static Object asStruct(PolicyData policyData) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_DOMAIN, policyData.getDomain());
        List policies = policyData.getPolicies();
        Array policiesArray = new Array();
        if (policies != null) {
            for (com.yahoo.athenz.zts.Policy policy : policies) {
                policiesArray.add((Object)SignUtils.asStruct(policy));
            }
        }
        SignUtils.appendArray(struct, ATTR_POLICIES, policiesArray);
        return struct;
    }

    private static Object asStruct(SignedPolicyData signedPolicyData) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_EXPIRES, signedPolicyData.getExpires());
        SignUtils.appendObject(struct, ATTR_MODIFIED, signedPolicyData.getModified());
        SignUtils.appendObject(struct, ATTR_POLICY_DATA, SignUtils.asStruct(signedPolicyData.getPolicyData()));
        SignUtils.appendObject(struct, ATTR_ZMS_KEY_ID, signedPolicyData.getZmsKeyId());
        SignUtils.appendObject(struct, ATTR_ZMS_SIGNATURE, signedPolicyData.getZmsSignature());
        return struct;
    }

    private static Struct asStruct(DomainData domainData) {
        Struct struct = new Struct();
        SignUtils.appendObject(struct, ATTR_ACCOUNT, domainData.getAccount());
        SignUtils.appendObject(struct, ATTR_AUDIT_ENABLED, domainData.getAuditEnabled());
        SignUtils.appendObject(struct, ATTR_CERT_DNS_DOMAIN, domainData.getCertDnsDomain());
        SignUtils.appendObject(struct, ATTR_ENABLED, domainData.getEnabled());
        if (domainData.getGroups() != null && !domainData.getGroups().isEmpty()) {
            Array structGroups = new Array();
            for (Object group : domainData.getGroups()) {
                structGroups.add((Object)SignUtils.asStruct((Group)group));
            }
            SignUtils.appendArray(struct, ATTR_GROUPS, structGroups);
        }
        SignUtils.appendObject(struct, ATTR_MEMBER_EXPIRY_DAYS, domainData.getMemberExpiryDays());
        SignUtils.appendObject(struct, ATTR_MODIFIED, domainData.getModified());
        SignUtils.appendObject(struct, ATTR_NAME, domainData.getName());
        SignedPolicies signedPolicies = domainData.getPolicies();
        if (signedPolicies != null) {
            Struct structSignedPolicies = new Struct();
            SignUtils.appendObject(structSignedPolicies, ATTR_CONTENTS, SignUtils.asStruct(signedPolicies.getContents()));
            SignUtils.appendObject(structSignedPolicies, ATTR_KEYID, signedPolicies.getKeyId());
            SignUtils.appendObject(struct, ATTR_POLICIES, structSignedPolicies);
            SignUtils.appendObject(structSignedPolicies, ATTR_SIGNATURE, signedPolicies.getSignature());
        }
        SignUtils.appendObject(struct, ATTR_ROLE_CERT_EXPIRY_MINS, domainData.getRoleCertExpiryMins());
        Array structRoles = new Array();
        if (domainData.getRoles() != null) {
            for (Role role : domainData.getRoles()) {
                structRoles.add((Object)SignUtils.asStruct(role));
            }
        }
        SignUtils.appendArray(struct, ATTR_ROLES, structRoles);
        Array structServices = new Array();
        if (domainData.getServices() != null) {
            for (ServiceIdentity service : domainData.getServices()) {
                structServices.add((Object)SignUtils.asStruct(service));
            }
        }
        SignUtils.appendObject(struct, ATTR_SERVICE_CERT_EXPIRY_MINS, domainData.getServiceCertExpiryMins());
        SignUtils.appendObject(struct, ATTR_SERVICE_EXPIRY_DAYS, domainData.getServiceExpiryDays());
        SignUtils.appendArray(struct, ATTR_SERVICES, structServices);
        SignUtils.appendObject(struct, ATTR_SIGN_ALGORITHM, domainData.getSignAlgorithm());
        SignUtils.appendObject(struct, ATTR_TOKEN_EXPIRY_MINS, domainData.getTokenExpiryMins());
        SignUtils.appendObject(struct, ATTR_YPMID, domainData.getYpmId());
        return struct;
    }

    private static void appendSeparator(StringBuilder strBuffer) {
        if (strBuffer.length() != 1) {
            strBuffer.append(',');
        }
    }

    static String asCanonicalString(Object obj) {
        StringBuilder strBuffer = new StringBuilder();
        if (obj instanceof Struct) {
            Struct struct = (Struct)obj;
            strBuffer.append('{');
            for (String name : struct.sortedNames()) {
                SignUtils.appendSeparator(strBuffer);
                strBuffer.append('\"');
                strBuffer.append(name);
                strBuffer.append("\":");
                strBuffer.append(SignUtils.asCanonicalString(struct.get(name)));
            }
            strBuffer.append('}');
        } else if (obj instanceof Array) {
            strBuffer.append('[');
            for (Object item : (Array)obj) {
                SignUtils.appendSeparator(strBuffer);
                strBuffer.append(SignUtils.asCanonicalString(item));
            }
            strBuffer.append(']');
        } else if (obj instanceof String) {
            strBuffer.append('\"');
            strBuffer.append(obj);
            strBuffer.append('\"');
        } else if (obj instanceof Integer) {
            strBuffer.append(obj);
        } else if (obj instanceof Long) {
            strBuffer.append(obj);
        } else if (obj instanceof Boolean) {
            strBuffer.append(obj);
        } else {
            strBuffer.append(obj.toString());
        }
        return strBuffer.toString();
    }

    public static String asCanonicalString(PolicyData policyData) {
        return SignUtils.asCanonicalString(SignUtils.asStruct(policyData));
    }

    public static String asCanonicalString(DomainData domainData) {
        return SignUtils.asCanonicalString(SignUtils.asStruct(domainData));
    }

    public static String asCanonicalString(DomainPolicies domainPolicies) {
        return SignUtils.asCanonicalString(SignUtils.asStruct(domainPolicies));
    }

    public static String asCanonicalString(SignedPolicyData signedPolicyData) {
        return SignUtils.asCanonicalString(SignUtils.asStruct(signedPolicyData));
    }
}

