/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.common.utils;

import com.yahoo.athenz.auth.PrivateKeyStore;
import com.yahoo.athenz.auth.PrivateKeyStoreFactory;
import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLUtils.class);

    public static PrivateKeyStore loadServicePrivateKey(String pkeyFactoryClass) {
        PrivateKeyStoreFactory pkeyFactory;
        try {
            pkeyFactory = (PrivateKeyStoreFactory)Class.forName(pkeyFactoryClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            LOGGER.error("Invalid PrivateKeyStoreFactory class: {}", (Object)pkeyFactoryClass, (Object)ex);
            throw new IllegalArgumentException("Invalid private key store", ex);
        }
        return pkeyFactory.create();
    }

    static class ClientAliasedX509ExtendedKeyManager
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509ExtendedKeyManager delegate;

        public ClientAliasedX509ExtendedKeyManager(X509ExtendedKeyManager keyManager, String keyAlias) {
            this.alias = keyAlias;
            this.delegate = keyManager;
        }

        public X509ExtendedKeyManager getDelegate() {
            return this.delegate;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            if (this.alias == null) {
                return this.delegate.chooseClientAlias(keyType, issuers, socket);
            }
            return this.getClientAlias(keyType, issuers);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.delegate.getClientAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.delegate.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.delegate.getPrivateKey(alias);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            if (this.alias == null) {
                return this.delegate.chooseEngineClientAlias(keyType, issuers, engine);
            }
            return this.getClientAlias(keyType, issuers);
        }

        String getClientAlias(String[] keyType, Principal[] issuers) {
            for (String kt : keyType) {
                String[] aliases = this.delegate.getClientAliases(kt, issuers);
                if (aliases == null) continue;
                for (String a : aliases) {
                    if (!this.alias.equals(a)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ClientSSLContextBuilder {
        private final String sslProtocol;
        private PrivateKeyStore privateKeyStore;
        private char[] keyStorePassword;
        private char[] keyManagerPassword;
        private String keyStorePath;
        private String keyStoreType = "pkcs12";
        private String trustStorePath;
        private char[] trustStorePassword;
        private String trustStoreType = "pkcs12";
        private String keyStorePasswordAppName;
        private String keyManagerPasswordAppName;
        private String trustStorePasswordAppName;
        private String certAlias;
        private String keyStorePasswordKeygroupName;
        private String keyManagerPasswordKeygroupName;
        private String trustStorePasswordKeygroupName;

        public ClientSSLContextBuilder(String sslProtocol) {
            this.sslProtocol = sslProtocol;
        }

        public ClientSSLContextBuilder keyStorePassword(char[] keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public ClientSSLContextBuilder keyManagerPassword(char[] keyManagerPassword) {
            this.keyManagerPassword = keyManagerPassword;
            return this;
        }

        public ClientSSLContextBuilder keyStorePath(String keyStorePath) {
            this.keyStorePath = keyStorePath;
            return this;
        }

        public ClientSSLContextBuilder keyStoreType(String keyStoreType) {
            this.keyStoreType = keyStoreType;
            return this;
        }

        public ClientSSLContextBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public ClientSSLContextBuilder trustStorePassword(char[] trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public ClientSSLContextBuilder trustStoreType(String trustStoreType) {
            this.trustStoreType = trustStoreType;
            return this;
        }

        public ClientSSLContextBuilder keyStorePasswordAppName(String keyStorePasswordAppName) {
            this.keyStorePasswordAppName = keyStorePasswordAppName;
            return this;
        }

        public ClientSSLContextBuilder keyManagerPasswordAppName(String keyManagerPasswordAppName) {
            this.keyManagerPasswordAppName = keyManagerPasswordAppName;
            return this;
        }

        public ClientSSLContextBuilder trustStorePasswordAppName(String trustStorePasswordAppName) {
            this.trustStorePasswordAppName = trustStorePasswordAppName;
            return this;
        }

        public ClientSSLContextBuilder privateKeyStore(PrivateKeyStore privateKeyStore) {
            this.privateKeyStore = privateKeyStore;
            return this;
        }

        public ClientSSLContextBuilder certAlias(String certAlias) {
            this.certAlias = certAlias;
            return this;
        }

        public ClientSSLContextBuilder keyStorePasswordKeygroupName(String keyStorePasswordKeygroupName) {
            this.keyStorePasswordKeygroupName = keyStorePasswordKeygroupName;
            return this;
        }

        public ClientSSLContextBuilder keyManagerPasswordKeygroupName(String keyManagerPasswordKeygroupName) {
            this.keyManagerPasswordKeygroupName = keyManagerPasswordKeygroupName;
            return this;
        }

        public ClientSSLContextBuilder trustStorePasswordKeygroupName(String trustStorePasswordKeygroupName) {
            this.trustStorePasswordKeygroupName = trustStorePasswordKeygroupName;
            return this;
        }

        public SSLContext build() {
            SSLContext context;
            KeyManager[] keyManagers = null;
            TrustManager[] trustManagers = null;
            if (this.keyStorePath == null && this.trustStorePath == null) {
                return null;
            }
            try {
                if (this.keyStorePath != null) {
                    LOGGER.info("createSSLContextObject: using SSL KeyStore path: {}", (Object)this.keyStorePath);
                    KeyStore keyStore = ClientSSLContextBuilder.loadStore(this.keyStorePath, this.keyStoreType, ClientSSLContextBuilder.getPassword(this.keyStorePassword, this.privateKeyStore, this.keyStorePasswordAppName, this.keyStorePasswordKeygroupName));
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    this.keyManagerPassword = ClientSSLContextBuilder.getPassword(this.keyManagerPassword, this.privateKeyStore, this.keyManagerPasswordAppName, this.keyManagerPasswordKeygroupName);
                    kmf.init(keyStore, this.keyStorePassword);
                    keyManagers = ClientSSLContextBuilder.getAliasedKeyManagers(kmf.getKeyManagers(), this.certAlias);
                }
                if (this.trustStorePath != null) {
                    LOGGER.info("createSSLContextObject: using SSL TrustStore path: {}", (Object)this.trustStorePath);
                    KeyStore trustStore = ClientSSLContextBuilder.loadStore(this.trustStorePath, this.trustStoreType, ClientSSLContextBuilder.getPassword(this.trustStorePassword, this.privateKeyStore, this.trustStorePasswordAppName, this.trustStorePasswordKeygroupName));
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trustStore);
                    trustManagers = tmf.getTrustManagers();
                }
                context = SSLContext.getInstance(this.sslProtocol);
                context.init(keyManagers, trustManagers, null);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            return context;
        }

        private static char[] getPassword(char[] password, PrivateKeyStore privateKeyStore, String appName, String keygroupName) {
            if (password != null && null != privateKeyStore) {
                password = privateKeyStore.getSecret(appName, keygroupName, String.valueOf(password));
            }
            return password;
        }

        private static KeyStore loadStore(String store, String storeType, char[] storePassword) throws Exception {
            KeyStore keystore = null;
            if (!store.isEmpty()) {
                keystore = KeyStore.getInstance(storeType);
                try (FileInputStream inStream = new FileInputStream(store);){
                    keystore.load(inStream, storePassword);
                }
            }
            return keystore;
        }

        static KeyManager[] getAliasedKeyManagers(KeyManager[] managers, String alias) {
            if (managers != null && alias != null) {
                for (int idx = 0; idx < managers.length; ++idx) {
                    if (!(managers[idx] instanceof X509ExtendedKeyManager)) continue;
                    managers[idx] = new ClientAliasedX509ExtendedKeyManager((X509ExtendedKeyManager)managers[idx], alias);
                }
            }
            return managers;
        }
    }
}

