/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.common.utils;

import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.util.Crypto;
import java.nio.charset.StandardCharsets;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertUtils {
    static final String ZTS_CERT_INSTANCE_ID_DNS = ".instanceid.athenz.";
    static final String ZTS_CERT_INSTANCE_ID_URI = "athenz://instanceid/";
    static final String ZTS_CERT_HOSTNAME_URI = "athenz://hostname/";
    private static final Logger LOGGER = LoggerFactory.getLogger(X509CertUtils.class);
    private static final ThreadLocal<StringBuilder> TLS_BUILDER = ThreadLocal.withInitial(() -> new StringBuilder(256));

    public static String extractRequestInstanceIdFromURI(List<String> uriList) {
        for (String uri : uriList) {
            int idx;
            if (!uri.startsWith(ZTS_CERT_INSTANCE_ID_URI) || (idx = uri.indexOf(47, ZTS_CERT_INSTANCE_ID_URI.length())) == -1) continue;
            return uri.substring(idx + 1);
        }
        return null;
    }

    public static String extractProvider(X509Certificate cert) {
        if (cert == null) {
            return "";
        }
        for (String uri : Crypto.extractX509CertURIs((X509Certificate)cert)) {
            if (!uri.startsWith(ZTS_CERT_INSTANCE_ID_URI)) continue;
            int prefixLen = ZTS_CERT_INSTANCE_ID_URI.length();
            int idx = uri.indexOf(47, prefixLen);
            return idx == -1 ? "" : uri.substring(prefixLen, idx);
        }
        return "";
    }

    public static String extractItemFromURI(List<String> uriList, String item) {
        for (String uri : uriList) {
            if (!uri.startsWith(item)) continue;
            return uri.substring(item.length());
        }
        return null;
    }

    public static String extractRequestInstanceIdFromDnsNames(List<String> dnsNames) {
        for (String dnsName : dnsNames) {
            int idx = dnsName.indexOf(ZTS_CERT_INSTANCE_ID_DNS);
            if (idx == -1) continue;
            return dnsName.substring(0, idx);
        }
        return null;
    }

    public static String extractHostname(X509Certificate cert) {
        if (cert == null) {
            return "";
        }
        String hostname = X509CertUtils.extractItemFromURI(Crypto.extractX509CertURIs((X509Certificate)cert), ZTS_CERT_HOSTNAME_URI);
        return hostname == null ? "" : hostname;
    }

    public static String extractRequestInstanceId(X509Certificate cert) {
        if (cert == null) {
            return null;
        }
        List uriList = Crypto.extractX509CertURIs((X509Certificate)cert);
        String instanceId = X509CertUtils.extractRequestInstanceIdFromURI(uriList);
        if (instanceId != null) {
            return instanceId;
        }
        List dnsNames = Crypto.extractX509CertDnsNames((X509Certificate)cert);
        return X509CertUtils.extractRequestInstanceIdFromDnsNames(dnsNames);
    }

    public static String extractKeyModulus(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        return X509CertUtils.extractKeyModulus(certs[0]);
    }

    public static String extractKeyModulus(X509Certificate cert) {
        try {
            RSAPublicKey pub = (RSAPublicKey)cert.getPublicKey();
            return pub.getModulus().toString(16);
        }
        catch (ClassCastException e) {
            LOGGER.error("unable to convert the public key to RSA", (Throwable)e);
            return "";
        }
    }

    public static String extractSubjectDn(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        return X509CertUtils.extractSubjectDn(certs[0]);
    }

    public static String extractSubjectDn(X509Certificate cert) {
        return cert.getSubjectX500Principal().getName();
    }

    public static String extractCn(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        return X509CertUtils.extractCn(certs[0]);
    }

    public static String extractCn(X509Certificate cert) {
        return Crypto.extractX509CertCommonName((X509Certificate)cert);
    }

    public static String extractIssuerDn(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        return Crypto.extractIssuerDn((X509Certificate)certs[0]);
    }

    @Deprecated
    public static String extractIssuerDn(X509Certificate cert) {
        return Crypto.extractIssuerDn((X509Certificate)cert);
    }

    public static String extractIssuerCn(X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        return X509CertUtils.extractIssuerCn(certs[0]);
    }

    public static String extractIssuerCn(X509Certificate cert) {
        return Crypto.extractX509CertIssuerCommonName((X509Certificate)cert);
    }

    public static String hexKeyMod(X509Certificate[] certs, boolean toUpperCase) {
        if (certs == null || certs.length == 0) {
            return "";
        }
        String modulus = X509CertUtils.extractKeyModulus(certs);
        if (modulus.isEmpty()) {
            return "";
        }
        if (toUpperCase) {
            modulus = modulus.toUpperCase();
        }
        return Hex.encodeHexString((byte[])Crypto.sha256((byte[])modulus.getBytes(StandardCharsets.UTF_8)));
    }

    public static void logCert(Logger certLogger, Principal principal, String ip, String provider, String instanceId, X509Certificate x509Cert) {
        if (certLogger == null) {
            return;
        }
        try {
            certLogger.info(X509CertUtils.logRecord(principal, ip, provider, instanceId, x509Cert));
        }
        catch (Exception ex) {
            LOGGER.error("Unable to generate certificate log record: {}", (Object)ex.getMessage());
        }
    }

    public static void logSSH(Logger certLogger, Principal principal, String ip, String service, String instanceId) {
        if (certLogger == null) {
            return;
        }
        certLogger.info("{} {} {} {}", new Object[]{ip, principal, service, instanceId});
    }

    public static String logRecord(Principal principal, String ip, String provider, String instanceId, X509Certificate x509Cert) {
        StringBuilder buf = TLS_BUILDER.get();
        buf.setLength(0);
        buf.append(ip);
        buf.append(' ');
        if (principal != null) {
            buf.append(principal.getFullName());
        } else {
            buf.append('-');
        }
        buf.append(' ');
        buf.append(provider);
        buf.append(' ');
        if (instanceId != null) {
            buf.append('\"');
            buf.append(instanceId);
            buf.append('\"');
        } else {
            buf.append('-');
        }
        buf.append(' ');
        buf.append('\"');
        buf.append(x509Cert.getSubjectX500Principal().getName());
        buf.append('\"');
        buf.append(' ');
        buf.append('\"');
        buf.append(x509Cert.getIssuerX500Principal().getName());
        buf.append('\"');
        buf.append(' ');
        buf.append(x509Cert.getSerialNumber().toString());
        buf.append(' ');
        buf.append(x509Cert.getNotAfter().getTime());
        return buf.toString();
    }
}

