//
// This file generated by rdl 1.5.2. Do not modify!
//
package com.yahoo.athenz.zms;

import com.yahoo.rdl.*;
import javax.ws.rs.client.*;
import javax.ws.rs.*;
import javax.ws.rs.core.*;
import javax.net.ssl.HostnameVerifier;

public class ZMSRDLGeneratedClient {
    Client client;
    WebTarget base;
    String credsHeader;
    String credsToken;

    public ZMSRDLGeneratedClient(String url) {
        client = ClientBuilder.newClient();
        base = client.target(url);
    }

    public ZMSRDLGeneratedClient(String url, HostnameVerifier hostnameVerifier) {
        client = ClientBuilder.newBuilder()
            .hostnameVerifier(hostnameVerifier)
            .build();
        base = client.target(url);
    }

    public ZMSRDLGeneratedClient(String url, Client rsClient) {
        client = rsClient;
        base = client.target(url);
    }
    
    public void close() {
        client.close();
    }

    public ZMSRDLGeneratedClient setProperty(String name, Object value) {
        client = client.property(name, value);
        base = client.target(base.getUri().toString());
        return this;
    }

    public ZMSRDLGeneratedClient addCredentials(String header, String token) {
        credsHeader = header;
        credsToken = token;
        return this;
    }

    public Domain getDomain(String domain) {
        WebTarget target = base.path("/domain/{domain}")
            .resolveTemplate("domain", domain);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Domain.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String account, Integer productId, String roleMember, String roleName, String subscription, String tagKey, String tagValue, String businessService, String modifiedSince) {
        WebTarget target = base.path("/domain");
        if (limit != null) {
            target = target.queryParam("limit", limit);
        }
        if (skip != null) {
            target = target.queryParam("skip", skip);
        }
        if (prefix != null) {
            target = target.queryParam("prefix", prefix);
        }
        if (depth != null) {
            target = target.queryParam("depth", depth);
        }
        if (account != null) {
            target = target.queryParam("account", account);
        }
        if (productId != null) {
            target = target.queryParam("ypmid", productId);
        }
        if (roleMember != null) {
            target = target.queryParam("member", roleMember);
        }
        if (roleName != null) {
            target = target.queryParam("role", roleName);
        }
        if (subscription != null) {
            target = target.queryParam("azure", subscription);
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", tagKey);
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", tagValue);
        }
        if (businessService != null) {
            target = target.queryParam("businessService", businessService);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (modifiedSince != null) {
            invocationBuilder = invocationBuilder.header("If-Modified-Since", modifiedSince);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Domain postTopLevelDomain(String auditRef, TopLevelDomain detail) {
        WebTarget target = base.path("/domain");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Domain.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Domain postSubDomain(String parent, String auditRef, SubDomain detail) {
        WebTarget target = base.path("/subdomain/{parent}")
            .resolveTemplate("parent", parent);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Domain.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Domain postUserDomain(String name, String auditRef, UserDomain detail) {
        WebTarget target = base.path("/userdomain/{name}")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Domain.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public TopLevelDomain deleteTopLevelDomain(String name, String auditRef) {
        WebTarget target = base.path("/domain/{name}")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public SubDomain deleteSubDomain(String parent, String name, String auditRef) {
        WebTarget target = base.path("/subdomain/{parent}/{name}")
            .resolveTemplate("parent", parent)
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public UserDomain deleteUserDomain(String name, String auditRef) {
        WebTarget target = base.path("/userdomain/{name}")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Domain putDomainMeta(String name, String auditRef, DomainMeta detail) {
        WebTarget target = base.path("/domain/{name}/meta")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Domain putDomainSystemMeta(String name, String attribute, String auditRef, DomainMeta detail) {
        WebTarget target = base.path("/domain/{name}/meta/system/{attribute}")
            .resolveTemplate("name", name)
            .resolveTemplate("attribute", attribute);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplate putDomainTemplate(String name, String auditRef, DomainTemplate domainTemplate) {
        WebTarget target = base.path("/domain/{name}/template")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(domainTemplate, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplate putDomainTemplateExt(String name, String template, String auditRef, DomainTemplate domainTemplate) {
        WebTarget target = base.path("/domain/{name}/template/{template}")
            .resolveTemplate("name", name)
            .resolveTemplate("template", template);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(domainTemplate, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplateList getDomainTemplateList(String name) {
        WebTarget target = base.path("/domain/{name}/template")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainTemplateList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplate deleteDomainTemplate(String name, String template, String auditRef) {
        WebTarget target = base.path("/domain/{name}/template/{template}")
            .resolveTemplate("name", name)
            .resolveTemplate("template", template);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainMetaStoreValidValuesList getDomainMetaStoreValidValuesList(String attributeName, String userName) {
        WebTarget target = base.path("/domain/metastore");
        if (attributeName != null) {
            target = target.queryParam("attribute", attributeName);
        }
        if (userName != null) {
            target = target.queryParam("user", userName);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainMetaStoreValidValuesList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainDataCheck getDomainDataCheck(String domainName) {
        WebTarget target = base.path("/domain/{domainName}/check")
            .resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainDataCheck.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Entity putEntity(String domainName, String entityName, String auditRef, Entity entity) {
        WebTarget target = base.path("/domain/{domainName}/entity/{entityName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("entityName", entityName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(entity, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Entity getEntity(String domainName, String entityName) {
        WebTarget target = base.path("/domain/{domainName}/entity/{entityName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("entityName", entityName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Entity.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Entity deleteEntity(String domainName, String entityName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/entity/{entityName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("entityName", entityName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public EntityList getEntityList(String domainName) {
        WebTarget target = base.path("/domain/{domainName}/entity")
            .resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(EntityList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public RoleList getRoleList(String domainName, Integer limit, String skip) {
        WebTarget target = base.path("/domain/{domainName}/role")
            .resolveTemplate("domainName", domainName);
        if (limit != null) {
            target = target.queryParam("limit", limit);
        }
        if (skip != null) {
            target = target.queryParam("skip", skip);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(RoleList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Roles getRoles(String domainName, Boolean members, String tagKey, String tagValue) {
        WebTarget target = base.path("/domain/{domainName}/roles")
            .resolveTemplate("domainName", domainName);
        if (members != null) {
            target = target.queryParam("members", members);
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", tagKey);
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", tagValue);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Roles.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role getRole(String domainName, String roleName, Boolean auditLog, Boolean expand, Boolean pending) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName);
        if (auditLog != null) {
            target = target.queryParam("auditLog", auditLog);
        }
        if (expand != null) {
            target = target.queryParam("expand", expand);
        }
        if (pending != null) {
            target = target.queryParam("pending", pending);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Role.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role putRole(String domainName, String roleName, String auditRef, Role role) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(role, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role deleteRole(String domainName, String roleName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Membership getMembership(String domainName, String roleName, String memberName, String expiration) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("memberName", memberName);
        if (expiration != null) {
            target = target.queryParam("expiration", expiration);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Membership.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainRoleMembers getOverdueReview(String domainName) {
        WebTarget target = base.path("/domain/{domainName}/overdue")
            .resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainRoleMembers.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainRoleMembers getDomainRoleMembers(String domainName) {
        WebTarget target = base.path("/domain/{domainName}/member")
            .resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainRoleMembers.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainRoleMember getPrincipalRoles(String principal, String domainName) {
        WebTarget target = base.path("/role");
        if (principal != null) {
            target = target.queryParam("principal", principal);
        }
        if (domainName != null) {
            target = target.queryParam("domain", domainName);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainRoleMember.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Membership putMembership(String domainName, String roleName, String memberName, String auditRef, Membership membership) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(membership, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Membership deleteMembership(String domainName, String roleName, String memberName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Membership deletePendingMembership(String domainName, String roleName, String memberName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/pendingmember/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DefaultAdmins putDefaultAdmins(String domainName, String auditRef, DefaultAdmins defaultAdmins) {
        WebTarget target = base.path("/domain/{domainName}/admins")
            .resolveTemplate("domainName", domainName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(defaultAdmins, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role putRoleSystemMeta(String domainName, String roleName, String attribute, String auditRef, RoleSystemMeta detail) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/meta/system/{attribute}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("attribute", attribute);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role putRoleMeta(String domainName, String roleName, String auditRef, RoleMeta detail) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/meta")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Membership putMembershipDecision(String domainName, String roleName, String memberName, String auditRef, Membership membership) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/member/{memberName}/decision")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(membership, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Role putRoleReview(String domainName, String roleName, String auditRef, Role role) {
        WebTarget target = base.path("/domain/{domainName}/role/{roleName}/review")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("roleName", roleName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(role, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Groups getGroups(String domainName, Boolean members, String tagKey, String tagValue) {
        WebTarget target = base.path("/domain/{domainName}/groups")
            .resolveTemplate("domainName", domainName);
        if (members != null) {
            target = target.queryParam("members", members);
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", tagKey);
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", tagValue);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Groups.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group getGroup(String domainName, String groupName, Boolean auditLog, Boolean pending) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName);
        if (auditLog != null) {
            target = target.queryParam("auditLog", auditLog);
        }
        if (pending != null) {
            target = target.queryParam("pending", pending);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Group.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group putGroup(String domainName, String groupName, String auditRef, Group group) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(group, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group deleteGroup(String domainName, String groupName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public GroupMembership getGroupMembership(String domainName, String groupName, String memberName, String expiration) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("memberName", memberName);
        if (expiration != null) {
            target = target.queryParam("expiration", expiration);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(GroupMembership.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainGroupMember getPrincipalGroups(String principal, String domainName) {
        WebTarget target = base.path("/group");
        if (principal != null) {
            target = target.queryParam("principal", principal);
        }
        if (domainName != null) {
            target = target.queryParam("domain", domainName);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainGroupMember.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public GroupMembership putGroupMembership(String domainName, String groupName, String memberName, String auditRef, GroupMembership membership) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(membership, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public GroupMembership deleteGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public GroupMembership deletePendingGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/pendingmember/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group putGroupSystemMeta(String domainName, String groupName, String attribute, String auditRef, GroupSystemMeta detail) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/meta/system/{attribute}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("attribute", attribute);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group putGroupMeta(String domainName, String groupName, String auditRef, GroupMeta detail) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/meta")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public GroupMembership putGroupMembershipDecision(String domainName, String groupName, String memberName, String auditRef, GroupMembership membership) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/member/{memberName}/decision")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(membership, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Group putGroupReview(String domainName, String groupName, String auditRef, Group group) {
        WebTarget target = base.path("/domain/{domainName}/group/{groupName}/review")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("groupName", groupName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(group, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainGroupMembership getPendingDomainGroupMembersList(String principal) {
        WebTarget target = base.path("/pending_group_members");
        if (principal != null) {
            target = target.queryParam("principal", principal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainGroupMembership.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public PolicyList getPolicyList(String domainName, Integer limit, String skip) {
        WebTarget target = base.path("/domain/{domainName}/policy")
            .resolveTemplate("domainName", domainName);
        if (limit != null) {
            target = target.queryParam("limit", limit);
        }
        if (skip != null) {
            target = target.queryParam("skip", skip);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(PolicyList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policies getPolicies(String domainName, Boolean assertions, Boolean includeNonActive) {
        WebTarget target = base.path("/domain/{domainName}/policies")
            .resolveTemplate("domainName", domainName);
        if (assertions != null) {
            target = target.queryParam("assertions", assertions);
        }
        if (includeNonActive != null) {
            target = target.queryParam("includeNonActive", includeNonActive);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Policies.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy getPolicy(String domainName, String policyName) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Policy.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy putPolicy(String domainName, String policyName, String auditRef, Policy policy) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(policy, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy deletePolicy(String domainName, String policyName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Assertion getAssertion(String domainName, String policyName, Long assertionId) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Assertion.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Assertion putAssertion(String domainName, String policyName, String auditRef, Assertion assertion) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(assertion, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Assertion.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Assertion putAssertionPolicyVersion(String domainName, String policyName, String version, String auditRef, Assertion assertion) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/{version}/assertion")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("version", version);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(assertion, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Assertion.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Assertion deleteAssertion(String domainName, String policyName, Long assertionId, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Assertion deleteAssertionPolicyVersion(String domainName, String policyName, String version, Long assertionId, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/{version}/assertion/{assertionId}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("version", version)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public AssertionConditions putAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, AssertionConditions assertionConditions) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(assertionConditions, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(AssertionConditions.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public AssertionCondition putAssertionCondition(String domainName, String policyName, Long assertionId, String auditRef, AssertionCondition assertionCondition) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(assertionCondition, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(AssertionCondition.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public AssertionConditions deleteAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public AssertionCondition deleteAssertionCondition(String domainName, String policyName, Long assertionId, Integer conditionId, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition/{conditionId}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("assertionId", assertionId)
            .resolveTemplate("conditionId", conditionId);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public PolicyList getPolicyVersionList(String domainName, String policyName) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(PolicyList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy getPolicyVersion(String domainName, String policyName, String version) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/{version}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("version", version);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Policy.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy putPolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/create")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(policyOptions, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy setActivePolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/active")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(policyOptions, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Policy deletePolicyVersion(String domainName, String policyName, String version, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/policy/{policyName}/version/{version}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("policyName", policyName)
            .resolveTemplate("version", version);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentity putServiceIdentity(String domain, String service, String auditRef, ServiceIdentity detail) {
        WebTarget target = base.path("/domain/{domain}/service/{service}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentity getServiceIdentity(String domain, String service) {
        WebTarget target = base.path("/domain/{domain}/service/{service}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ServiceIdentity.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentity deleteServiceIdentity(String domain, String service, String auditRef) {
        WebTarget target = base.path("/domain/{domain}/service/{service}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentities getServiceIdentities(String domainName, Boolean publickeys, Boolean hosts) {
        WebTarget target = base.path("/domain/{domainName}/services")
            .resolveTemplate("domainName", domainName);
        if (publickeys != null) {
            target = target.queryParam("publickeys", publickeys);
        }
        if (hosts != null) {
            target = target.queryParam("hosts", hosts);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ServiceIdentities.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentityList getServiceIdentityList(String domainName, Integer limit, String skip) {
        WebTarget target = base.path("/domain/{domainName}/service")
            .resolveTemplate("domainName", domainName);
        if (limit != null) {
            target = target.queryParam("limit", limit);
        }
        if (skip != null) {
            target = target.queryParam("skip", skip);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ServiceIdentityList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public PublicKeyEntry getPublicKeyEntry(String domain, String service, String id) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/publickey/{id}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("id", id);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(PublicKeyEntry.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public PublicKeyEntry putPublicKeyEntry(String domain, String service, String id, String auditRef, PublicKeyEntry publicKeyEntry) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/publickey/{id}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("id", id);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(publicKeyEntry, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public PublicKeyEntry deletePublicKeyEntry(String domain, String service, String id, String auditRef) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/publickey/{id}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("id", id);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServiceIdentity putServiceIdentitySystemMeta(String domain, String service, String attribute, String auditRef, ServiceIdentitySystemMeta detail) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/meta/system/{attribute}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("attribute", attribute);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Tenancy putTenancy(String domain, String service, String auditRef, Tenancy detail) {
        WebTarget target = base.path("/domain/{domain}/tenancy/{service}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Tenancy deleteTenancy(String domain, String service, String auditRef) {
        WebTarget target = base.path("/domain/{domain}/tenancy/{service}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Tenancy putTenant(String domain, String service, String tenantDomain, String auditRef, Tenancy detail) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("tenantDomain", tenantDomain);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Tenancy deleteTenant(String domain, String service, String tenantDomain, String auditRef) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("tenantDomain", tenantDomain);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public TenantResourceGroupRoles putTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef, TenantResourceGroupRoles detail) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(TenantResourceGroupRoles.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public TenantResourceGroupRoles getTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(TenantResourceGroupRoles.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public TenantResourceGroupRoles deleteTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef) {
        WebTarget target = base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}")
            .resolveTemplate("domain", domain)
            .resolveTemplate("service", service)
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ProviderResourceGroupRoles putProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef, ProviderResourceGroupRoles detail) {
        WebTarget target = base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}")
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("provDomain", provDomain)
            .resolveTemplate("provService", provService)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(detail, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ProviderResourceGroupRoles.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ProviderResourceGroupRoles getProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup) {
        WebTarget target = base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}")
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("provDomain", provDomain)
            .resolveTemplate("provService", provService)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ProviderResourceGroupRoles.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ProviderResourceGroupRoles deleteProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef) {
        WebTarget target = base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}")
            .resolveTemplate("tenantDomain", tenantDomain)
            .resolveTemplate("provDomain", provDomain)
            .resolveTemplate("provService", provService)
            .resolveTemplate("resourceGroup", resourceGroup);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Access getAccess(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = base.path("/access/{action}/{resource}")
            .resolveTemplate("action", action)
            .resolveTemplate("resource", resource);
        if (domain != null) {
            target = target.queryParam("domain", domain);
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", checkPrincipal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Access.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Access getAccessExt(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = base.path("/access/{action}")
            .resolveTemplate("action", action);
        if (resource != null) {
            target = target.queryParam("resource", resource);
        }
        if (domain != null) {
            target = target.queryParam("domain", domain);
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", checkPrincipal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Access.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ResourceAccessList getResourceAccessList(String principal, String action) {
        WebTarget target = base.path("/resource");
        if (principal != null) {
            target = target.queryParam("principal", principal);
        }
        if (action != null) {
            target = target.queryParam("action", action);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ResourceAccessList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public SignedDomains getSignedDomains(String domain, String metaOnly, String metaAttr, Boolean master, Boolean conditions, String matchingTag, java.util.Map<String, java.util.List<String>> headers) {
        WebTarget target = base.path("/sys/modified_domains");
        if (domain != null) {
            target = target.queryParam("domain", domain);
        }
        if (metaOnly != null) {
            target = target.queryParam("metaonly", metaOnly);
        }
        if (metaAttr != null) {
            target = target.queryParam("metaattr", metaAttr);
        }
        if (master != null) {
            target = target.queryParam("master", master);
        }
        if (conditions != null) {
            target = target.queryParam("conditions", conditions);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
        case 304:
            if (headers != null) {
                headers.put("tag", java.util.Arrays.asList((String) response.getHeaders().getFirst("ETag")));
            }
            if (code == 304) {
                return null;
            }
            return response.readEntity(SignedDomains.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public JWSDomain getJWSDomain(String name, Boolean signatureP1363Format, String matchingTag, java.util.Map<String, java.util.List<String>> headers) {
        WebTarget target = base.path("/domain/{name}/signed")
            .resolveTemplate("name", name);
        if (signatureP1363Format != null) {
            target = target.queryParam("signaturep1363format", signatureP1363Format);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
        case 304:
            if (headers != null) {
                headers.put("tag", java.util.Arrays.asList((String) response.getHeaders().getFirst("ETag")));
            }
            if (code == 304) {
                return null;
            }
            return response.readEntity(JWSDomain.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public UserToken getUserToken(String userName, String serviceNames, Boolean header) {
        WebTarget target = base.path("/user/{userName}/token")
            .resolveTemplate("userName", userName);
        if (serviceNames != null) {
            target = target.queryParam("services", serviceNames);
        }
        if (header != null) {
            target = target.queryParam("header", header);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(UserToken.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public UserToken optionsUserToken(String userName, String serviceNames) {
        WebTarget target = base.path("/user/{userName}/token")
            .resolveTemplate("userName", userName);
        if (serviceNames != null) {
            target = target.queryParam("services", serviceNames);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        Response response = invocationBuilder.options();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(UserToken.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServicePrincipal getServicePrincipal() {
        WebTarget target = base.path("/principal");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ServicePrincipal.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public ServerTemplateList getServerTemplateList() {
        WebTarget target = base.path("/template");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(ServerTemplateList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Template getTemplate(String template) {
        WebTarget target = base.path("/template/{template}")
            .resolveTemplate("template", template);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Template.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplateDetailsList getDomainTemplateDetailsList(String name) {
        WebTarget target = base.path("/domain/{name}/templatedetails")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainTemplateDetailsList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainTemplateDetailsList getServerTemplateDetailsList() {
        WebTarget target = base.path("/templatedetails");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainTemplateDetailsList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public UserList getUserList(String domainName) {
        WebTarget target = base.path("/user");
        if (domainName != null) {
            target = target.queryParam("domain", domainName);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(UserList.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public User deleteUser(String name, String auditRef) {
        WebTarget target = base.path("/user/{name}")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainRoleMember deleteDomainRoleMember(String domainName, String memberName, String auditRef) {
        WebTarget target = base.path("/domain/{domainName}/member/{memberName}")
            .resolveTemplate("domainName", domainName)
            .resolveTemplate("memberName", memberName);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Quota getQuota(String name) {
        WebTarget target = base.path("/domain/{name}/quota")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Quota.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Quota putQuota(String name, String auditRef, Quota quota) {
        WebTarget target = base.path("/domain/{name}/quota")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity(quota, "application/json"));
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Quota deleteQuota(String name, String auditRef) {
        WebTarget target = base.path("/domain/{name}/quota")
            .resolveTemplate("name", name);
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
        case 204:
            return null;
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public Status getStatus() {
        WebTarget target = base.path("/status");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(Status.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public DomainRoleMembership getPendingDomainRoleMembersList(String principal) {
        WebTarget target = base.path("/pending_members");
        if (principal != null) {
            target = target.queryParam("principal", principal);
        }
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(DomainRoleMembership.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

    public UserAuthorityAttributeMap getUserAuthorityAttributeMap() {
        WebTarget target = base.path("/authority/user/attribute");
        Invocation.Builder invocationBuilder = target.request("application/json");
        if (credsHeader != null) {
            invocationBuilder = credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(credsHeader.substring(7),
                credsToken) : invocationBuilder.header(credsHeader, credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
        case 200:
            return response.readEntity(UserAuthorityAttributeMap.class);
        default:
            throw new ResourceException(code, response.readEntity(ResourceError.class));
        }

    }

}
