/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zms;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Authorizer;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.impl.PrincipalAuthority;
import com.yahoo.athenz.auth.impl.RoleAuthority;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.PrincipalToken;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.zms.ZMSClient;
import com.yahoo.athenz.zms.ZMSClientException;
import java.io.Closeable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZMSAuthorizer
implements Authorizer,
Closeable {
    String endpoint = null;
    String serviceDomain = null;
    protected ZMSClient client = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZMSAuthorizer.class);
    private static final PrincipalAuthority PRINCIPAL_AUTHORITY = new PrincipalAuthority();
    private static final RoleAuthority ROLE_AUTHORITY = new RoleAuthority();

    public ZMSAuthorizer(String serviceDomain) {
        this(null, serviceDomain);
    }

    public ZMSAuthorizer(String endpoint, String serviceDomain) {
        this.endpoint = endpoint;
        this.serviceDomain = serviceDomain;
        this.client = new ZMSClient(this.endpoint);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void setZMSClient(ZMSClient client) {
        this.close();
        this.client = client;
    }

    public boolean access(String action, String resource, String token, String trustDomain) {
        Principal principal;
        if (this.isRoleToken(token)) {
            RoleToken roleToken = new RoleToken(token);
            principal = SimplePrincipal.create((String)roleToken.getDomain(), (String)roleToken.getSignedToken(), (List)roleToken.getRoles(), (Authority)ROLE_AUTHORITY);
        } else {
            PrincipalToken principalToken = new PrincipalToken(token);
            principal = SimplePrincipal.create((String)principalToken.getDomain(), (String)principalToken.getName(), (String)principalToken.getSignedToken(), (long)0L, (Authority)PRINCIPAL_AUTHORITY);
        }
        return this.access(action, resource, principal, trustDomain);
    }

    public boolean access(String action, String resource, Principal principal, String trustDomain) {
        String rn;
        String string = rn = resource.contains(":") ? resource : this.serviceDomain + ":" + resource;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ZMSAuthorizer.access({}, {}, {}, {})", new Object[]{action, rn, principal != null ? principal.getFullName() : "null", trustDomain});
        }
        try {
            this.client.addCredentials(principal);
            return this.client.getAccess(action, rn, trustDomain).getGranted();
        }
        catch (ZMSClientException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("ZMSAuthorizer.access", (Throwable)e);
            }
            switch (e.getCode()) {
                case 404: {
                    throw new ZMSClientException(403, "Not found: " + rn);
                }
            }
            throw e;
        }
        catch (Throwable th) {
            throw new ZMSClientException(403, "Cannot contact ZMS");
        }
    }

    boolean isRoleToken(String token) {
        boolean roleToken = false;
        for (String item : token.split(";")) {
            if (!"v=Z1".equalsIgnoreCase(item)) continue;
            roleToken = true;
            break;
        }
        return roleToken;
    }
}

