/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zms;

import com.yahoo.athenz.zms.Access;
import com.yahoo.athenz.zms.Assertion;
import com.yahoo.athenz.zms.AssertionCondition;
import com.yahoo.athenz.zms.AssertionConditions;
import com.yahoo.athenz.zms.DefaultAdmins;
import com.yahoo.athenz.zms.Domain;
import com.yahoo.athenz.zms.DomainDataCheck;
import com.yahoo.athenz.zms.DomainGroupMember;
import com.yahoo.athenz.zms.DomainGroupMembership;
import com.yahoo.athenz.zms.DomainList;
import com.yahoo.athenz.zms.DomainMeta;
import com.yahoo.athenz.zms.DomainMetaStoreValidValuesList;
import com.yahoo.athenz.zms.DomainRoleMember;
import com.yahoo.athenz.zms.DomainRoleMembers;
import com.yahoo.athenz.zms.DomainRoleMembership;
import com.yahoo.athenz.zms.DomainTemplate;
import com.yahoo.athenz.zms.DomainTemplateDetailsList;
import com.yahoo.athenz.zms.DomainTemplateList;
import com.yahoo.athenz.zms.Entity;
import com.yahoo.athenz.zms.EntityList;
import com.yahoo.athenz.zms.Group;
import com.yahoo.athenz.zms.GroupMembership;
import com.yahoo.athenz.zms.GroupMeta;
import com.yahoo.athenz.zms.GroupSystemMeta;
import com.yahoo.athenz.zms.Groups;
import com.yahoo.athenz.zms.JWSDomain;
import com.yahoo.athenz.zms.Membership;
import com.yahoo.athenz.zms.Policies;
import com.yahoo.athenz.zms.Policy;
import com.yahoo.athenz.zms.PolicyList;
import com.yahoo.athenz.zms.PolicyOptions;
import com.yahoo.athenz.zms.ProviderResourceGroupRoles;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zms.Quota;
import com.yahoo.athenz.zms.ResourceAccessList;
import com.yahoo.athenz.zms.ResourceError;
import com.yahoo.athenz.zms.ResourceException;
import com.yahoo.athenz.zms.Role;
import com.yahoo.athenz.zms.RoleList;
import com.yahoo.athenz.zms.RoleMeta;
import com.yahoo.athenz.zms.RoleSystemMeta;
import com.yahoo.athenz.zms.Roles;
import com.yahoo.athenz.zms.ServerTemplateList;
import com.yahoo.athenz.zms.ServiceIdentities;
import com.yahoo.athenz.zms.ServiceIdentity;
import com.yahoo.athenz.zms.ServiceIdentityList;
import com.yahoo.athenz.zms.ServiceIdentitySystemMeta;
import com.yahoo.athenz.zms.ServicePrincipal;
import com.yahoo.athenz.zms.SignedDomains;
import com.yahoo.athenz.zms.Status;
import com.yahoo.athenz.zms.SubDomain;
import com.yahoo.athenz.zms.Template;
import com.yahoo.athenz.zms.Tenancy;
import com.yahoo.athenz.zms.TenantResourceGroupRoles;
import com.yahoo.athenz.zms.TopLevelDomain;
import com.yahoo.athenz.zms.User;
import com.yahoo.athenz.zms.UserAuthorityAttributeMap;
import com.yahoo.athenz.zms.UserDomain;
import com.yahoo.athenz.zms.UserList;
import com.yahoo.athenz.zms.UserToken;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;

public class ZMSRDLGeneratedClient {
    Client client;
    WebTarget base;
    String credsHeader;
    String credsToken;

    public ZMSRDLGeneratedClient(String url) {
        this.client = ClientBuilder.newClient();
        this.base = this.client.target(url);
    }

    public ZMSRDLGeneratedClient(String url, HostnameVerifier hostnameVerifier) {
        this.client = ClientBuilder.newBuilder().hostnameVerifier(hostnameVerifier).build();
        this.base = this.client.target(url);
    }

    public ZMSRDLGeneratedClient(String url, Client rsClient) {
        this.client = rsClient;
        this.base = this.client.target(url);
    }

    public void close() {
        this.client.close();
    }

    public ZMSRDLGeneratedClient setProperty(String name, Object value) {
        this.client = (Client)this.client.property(name, value);
        this.base = this.client.target(this.base.getUri().toString());
        return this;
    }

    public ZMSRDLGeneratedClient addCredentials(String header, String token) {
        this.credsHeader = header;
        this.credsToken = token;
        return this;
    }

    public Domain getDomain(String domain) {
        WebTarget target = this.base.path("/domain/{domain}").resolveTemplate("domain", (Object)domain);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Domain)response.readEntity(Domain.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String account, Integer productId, String roleMember, String roleName, String subscription, String tagKey, String tagValue, String businessService, String modifiedSince) {
        WebTarget target = this.base.path("/domain");
        if (limit != null) {
            target = target.queryParam("limit", new Object[]{limit});
        }
        if (skip != null) {
            target = target.queryParam("skip", new Object[]{skip});
        }
        if (prefix != null) {
            target = target.queryParam("prefix", new Object[]{prefix});
        }
        if (depth != null) {
            target = target.queryParam("depth", new Object[]{depth});
        }
        if (account != null) {
            target = target.queryParam("account", new Object[]{account});
        }
        if (productId != null) {
            target = target.queryParam("ypmid", new Object[]{productId});
        }
        if (roleMember != null) {
            target = target.queryParam("member", new Object[]{roleMember});
        }
        if (roleName != null) {
            target = target.queryParam("role", new Object[]{roleName});
        }
        if (subscription != null) {
            target = target.queryParam("azure", new Object[]{subscription});
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", new Object[]{tagKey});
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", new Object[]{tagValue});
        }
        if (businessService != null) {
            target = target.queryParam("businessService", new Object[]{businessService});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (modifiedSince != null) {
            invocationBuilder = invocationBuilder.header("If-Modified-Since", (Object)modifiedSince);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainList)response.readEntity(DomainList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Domain postTopLevelDomain(String auditRef, TopLevelDomain detail) {
        WebTarget target = this.base.path("/domain");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Domain)response.readEntity(Domain.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Domain postSubDomain(String parent, String auditRef, SubDomain detail) {
        WebTarget target = this.base.path("/subdomain/{parent}").resolveTemplate("parent", (Object)parent);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Domain)response.readEntity(Domain.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Domain postUserDomain(String name, String auditRef, UserDomain detail) {
        WebTarget target = this.base.path("/userdomain/{name}").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.post(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Domain)response.readEntity(Domain.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TopLevelDomain deleteTopLevelDomain(String name, String auditRef) {
        WebTarget target = this.base.path("/domain/{name}").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public SubDomain deleteSubDomain(String parent, String name, String auditRef) {
        WebTarget target = this.base.path("/subdomain/{parent}/{name}").resolveTemplate("parent", (Object)parent).resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public UserDomain deleteUserDomain(String name, String auditRef) {
        WebTarget target = this.base.path("/userdomain/{name}").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Domain putDomainMeta(String name, String auditRef, DomainMeta detail) {
        WebTarget target = this.base.path("/domain/{name}/meta").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Domain putDomainSystemMeta(String name, String attribute, String auditRef, DomainMeta detail) {
        WebTarget target = this.base.path("/domain/{name}/meta/system/{attribute}").resolveTemplate("name", (Object)name).resolveTemplate("attribute", (Object)attribute);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplate putDomainTemplate(String name, String auditRef, DomainTemplate domainTemplate) {
        WebTarget target = this.base.path("/domain/{name}/template").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)domainTemplate, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplate putDomainTemplateExt(String name, String template, String auditRef, DomainTemplate domainTemplate) {
        WebTarget target = this.base.path("/domain/{name}/template/{template}").resolveTemplate("name", (Object)name).resolveTemplate("template", (Object)template);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)domainTemplate, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplateList getDomainTemplateList(String name) {
        WebTarget target = this.base.path("/domain/{name}/template").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainTemplateList)response.readEntity(DomainTemplateList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplate deleteDomainTemplate(String name, String template, String auditRef) {
        WebTarget target = this.base.path("/domain/{name}/template/{template}").resolveTemplate("name", (Object)name).resolveTemplate("template", (Object)template);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainMetaStoreValidValuesList getDomainMetaStoreValidValuesList(String attributeName, String userName) {
        WebTarget target = this.base.path("/domain/metastore");
        if (attributeName != null) {
            target = target.queryParam("attribute", new Object[]{attributeName});
        }
        if (userName != null) {
            target = target.queryParam("user", new Object[]{userName});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainMetaStoreValidValuesList)response.readEntity(DomainMetaStoreValidValuesList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainDataCheck getDomainDataCheck(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/check").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainDataCheck)response.readEntity(DomainDataCheck.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Entity putEntity(String domainName, String entityName, String auditRef, Entity entity) {
        WebTarget target = this.base.path("/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("entityName", (Object)entityName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)entity, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Entity getEntity(String domainName, String entityName) {
        WebTarget target = this.base.path("/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("entityName", (Object)entityName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Entity)response.readEntity(Entity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Entity deleteEntity(String domainName, String entityName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("entityName", (Object)entityName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public EntityList getEntityList(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/entity").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (EntityList)response.readEntity(EntityList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public RoleList getRoleList(String domainName, Integer limit, String skip) {
        WebTarget target = this.base.path("/domain/{domainName}/role").resolveTemplate("domainName", (Object)domainName);
        if (limit != null) {
            target = target.queryParam("limit", new Object[]{limit});
        }
        if (skip != null) {
            target = target.queryParam("skip", new Object[]{skip});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (RoleList)response.readEntity(RoleList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Roles getRoles(String domainName, Boolean members, String tagKey, String tagValue) {
        WebTarget target = this.base.path("/domain/{domainName}/roles").resolveTemplate("domainName", (Object)domainName);
        if (members != null) {
            target = target.queryParam("members", new Object[]{members});
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", new Object[]{tagKey});
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", new Object[]{tagValue});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Roles)response.readEntity(Roles.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role getRole(String domainName, String roleName, Boolean auditLog, Boolean expand, Boolean pending) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        if (auditLog != null) {
            target = target.queryParam("auditLog", new Object[]{auditLog});
        }
        if (expand != null) {
            target = target.queryParam("expand", new Object[]{expand});
        }
        if (pending != null) {
            target = target.queryParam("pending", new Object[]{pending});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Role)response.readEntity(Role.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role putRole(String domainName, String roleName, String auditRef, Role role) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)role, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role deleteRole(String domainName, String roleName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Membership getMembership(String domainName, String roleName, String memberName, String expiration) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("memberName", (Object)memberName);
        if (expiration != null) {
            target = target.queryParam("expiration", new Object[]{expiration});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Membership)response.readEntity(Membership.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainRoleMembers getOverdueReview(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/overdue").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainRoleMembers)response.readEntity(DomainRoleMembers.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainRoleMembers getDomainRoleMembers(String domainName) {
        WebTarget target = this.base.path("/domain/{domainName}/member").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainRoleMembers)response.readEntity(DomainRoleMembers.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainRoleMember getPrincipalRoles(String principal, String domainName) {
        WebTarget target = this.base.path("/role");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        if (domainName != null) {
            target = target.queryParam("domain", new Object[]{domainName});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainRoleMember)response.readEntity(DomainRoleMember.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Membership putMembership(String domainName, String roleName, String memberName, String auditRef, Membership membership) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)membership, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Membership deleteMembership(String domainName, String roleName, String memberName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Membership deletePendingMembership(String domainName, String roleName, String memberName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/pendingmember/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DefaultAdmins putDefaultAdmins(String domainName, String auditRef, DefaultAdmins defaultAdmins) {
        WebTarget target = this.base.path("/domain/{domainName}/admins").resolveTemplate("domainName", (Object)domainName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)defaultAdmins, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role putRoleSystemMeta(String domainName, String roleName, String attribute, String auditRef, RoleSystemMeta detail) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/meta/system/{attribute}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("attribute", (Object)attribute);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role putRoleMeta(String domainName, String roleName, String auditRef, RoleMeta detail) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/meta").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Membership putMembershipDecision(String domainName, String roleName, String memberName, String auditRef, Membership membership) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/member/{memberName}/decision").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)membership, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Role putRoleReview(String domainName, String roleName, String auditRef, Role role) {
        WebTarget target = this.base.path("/domain/{domainName}/role/{roleName}/review").resolveTemplate("domainName", (Object)domainName).resolveTemplate("roleName", (Object)roleName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)role, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Groups getGroups(String domainName, Boolean members, String tagKey, String tagValue) {
        WebTarget target = this.base.path("/domain/{domainName}/groups").resolveTemplate("domainName", (Object)domainName);
        if (members != null) {
            target = target.queryParam("members", new Object[]{members});
        }
        if (tagKey != null) {
            target = target.queryParam("tagKey", new Object[]{tagKey});
        }
        if (tagValue != null) {
            target = target.queryParam("tagValue", new Object[]{tagValue});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Groups)response.readEntity(Groups.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group getGroup(String domainName, String groupName, Boolean auditLog, Boolean pending) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName);
        if (auditLog != null) {
            target = target.queryParam("auditLog", new Object[]{auditLog});
        }
        if (pending != null) {
            target = target.queryParam("pending", new Object[]{pending});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Group)response.readEntity(Group.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group putGroup(String domainName, String groupName, String auditRef, Group group) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)group, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group deleteGroup(String domainName, String groupName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public GroupMembership getGroupMembership(String domainName, String groupName, String memberName, String expiration) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("memberName", (Object)memberName);
        if (expiration != null) {
            target = target.queryParam("expiration", new Object[]{expiration});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (GroupMembership)response.readEntity(GroupMembership.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainGroupMember getPrincipalGroups(String principal, String domainName) {
        WebTarget target = this.base.path("/group");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        if (domainName != null) {
            target = target.queryParam("domain", new Object[]{domainName});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainGroupMember)response.readEntity(DomainGroupMember.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public GroupMembership putGroupMembership(String domainName, String groupName, String memberName, String auditRef, GroupMembership membership) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)membership, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public GroupMembership deleteGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public GroupMembership deletePendingGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/pendingmember/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group putGroupSystemMeta(String domainName, String groupName, String attribute, String auditRef, GroupSystemMeta detail) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/meta/system/{attribute}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("attribute", (Object)attribute);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group putGroupMeta(String domainName, String groupName, String auditRef, GroupMeta detail) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/meta").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public GroupMembership putGroupMembershipDecision(String domainName, String groupName, String memberName, String auditRef, GroupMembership membership) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/member/{memberName}/decision").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)membership, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Group putGroupReview(String domainName, String groupName, String auditRef, Group group) {
        WebTarget target = this.base.path("/domain/{domainName}/group/{groupName}/review").resolveTemplate("domainName", (Object)domainName).resolveTemplate("groupName", (Object)groupName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)group, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainGroupMembership getPendingDomainGroupMembersList(String principal) {
        WebTarget target = this.base.path("/pending_group_members");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainGroupMembership)response.readEntity(DomainGroupMembership.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PolicyList getPolicyList(String domainName, Integer limit, String skip) {
        WebTarget target = this.base.path("/domain/{domainName}/policy").resolveTemplate("domainName", (Object)domainName);
        if (limit != null) {
            target = target.queryParam("limit", new Object[]{limit});
        }
        if (skip != null) {
            target = target.queryParam("skip", new Object[]{skip});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (PolicyList)response.readEntity(PolicyList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policies getPolicies(String domainName, Boolean assertions, Boolean includeNonActive) {
        WebTarget target = this.base.path("/domain/{domainName}/policies").resolveTemplate("domainName", (Object)domainName);
        if (assertions != null) {
            target = target.queryParam("assertions", new Object[]{assertions});
        }
        if (includeNonActive != null) {
            target = target.queryParam("includeNonActive", new Object[]{includeNonActive});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Policies)response.readEntity(Policies.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy getPolicy(String domainName, String policyName) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Policy)response.readEntity(Policy.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy putPolicy(String domainName, String policyName, String auditRef, Policy policy) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)policy, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy deletePolicy(String domainName, String policyName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Assertion getAssertion(String domainName, String policyName, Long assertionId) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Assertion)response.readEntity(Assertion.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Assertion putAssertion(String domainName, String policyName, String auditRef, Assertion assertion) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)assertion, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Assertion)response.readEntity(Assertion.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Assertion putAssertionPolicyVersion(String domainName, String policyName, String version, String auditRef, Assertion assertion) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/{version}/assertion").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("version", (Object)version);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)assertion, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Assertion)response.readEntity(Assertion.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Assertion deleteAssertion(String domainName, String policyName, Long assertionId, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Assertion deleteAssertionPolicyVersion(String domainName, String policyName, String version, Long assertionId, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/{version}/assertion/{assertionId}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("version", (Object)version).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AssertionConditions putAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, AssertionConditions assertionConditions) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)assertionConditions, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (AssertionConditions)response.readEntity(AssertionConditions.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AssertionCondition putAssertionCondition(String domainName, String policyName, Long assertionId, String auditRef, AssertionCondition assertionCondition) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)assertionCondition, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (AssertionCondition)response.readEntity(AssertionCondition.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AssertionConditions deleteAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public AssertionCondition deleteAssertionCondition(String domainName, String policyName, Long assertionId, Integer conditionId, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition/{conditionId}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("assertionId", (Object)assertionId).resolveTemplate("conditionId", (Object)conditionId);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PolicyList getPolicyVersionList(String domainName, String policyName) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (PolicyList)response.readEntity(PolicyList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy getPolicyVersion(String domainName, String policyName, String version) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/{version}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("version", (Object)version);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Policy)response.readEntity(Policy.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy putPolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/create").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)policyOptions, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy setActivePolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/active").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)policyOptions, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Policy deletePolicyVersion(String domainName, String policyName, String version, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/policy/{policyName}/version/{version}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("policyName", (Object)policyName).resolveTemplate("version", (Object)version);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity putServiceIdentity(String domain, String service, String auditRef, ServiceIdentity detail) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity getServiceIdentity(String domain, String service) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServiceIdentity)response.readEntity(ServiceIdentity.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity deleteServiceIdentity(String domain, String service, String auditRef) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentities getServiceIdentities(String domainName, Boolean publickeys, Boolean hosts) {
        WebTarget target = this.base.path("/domain/{domainName}/services").resolveTemplate("domainName", (Object)domainName);
        if (publickeys != null) {
            target = target.queryParam("publickeys", new Object[]{publickeys});
        }
        if (hosts != null) {
            target = target.queryParam("hosts", new Object[]{hosts});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServiceIdentities)response.readEntity(ServiceIdentities.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentityList getServiceIdentityList(String domainName, Integer limit, String skip) {
        WebTarget target = this.base.path("/domain/{domainName}/service").resolveTemplate("domainName", (Object)domainName);
        if (limit != null) {
            target = target.queryParam("limit", new Object[]{limit});
        }
        if (skip != null) {
            target = target.queryParam("skip", new Object[]{skip});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServiceIdentityList)response.readEntity(ServiceIdentityList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PublicKeyEntry getPublicKeyEntry(String domain, String service, String id) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("id", (Object)id);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (PublicKeyEntry)response.readEntity(PublicKeyEntry.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PublicKeyEntry putPublicKeyEntry(String domain, String service, String id, String auditRef, PublicKeyEntry publicKeyEntry) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("id", (Object)id);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)publicKeyEntry, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public PublicKeyEntry deletePublicKeyEntry(String domain, String service, String id, String auditRef) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("id", (Object)id);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServiceIdentity putServiceIdentitySystemMeta(String domain, String service, String attribute, String auditRef, ServiceIdentitySystemMeta detail) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/meta/system/{attribute}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("attribute", (Object)attribute);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Tenancy putTenancy(String domain, String service, String auditRef, Tenancy detail) {
        WebTarget target = this.base.path("/domain/{domain}/tenancy/{service}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Tenancy deleteTenancy(String domain, String service, String auditRef) {
        WebTarget target = this.base.path("/domain/{domain}/tenancy/{service}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Tenancy putTenant(String domain, String service, String tenantDomain, String auditRef, Tenancy detail) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("tenantDomain", (Object)tenantDomain);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Tenancy deleteTenant(String domain, String service, String tenantDomain, String auditRef) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("tenantDomain", (Object)tenantDomain);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TenantResourceGroupRoles putTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef, TenantResourceGroupRoles detail) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (TenantResourceGroupRoles)response.readEntity(TenantResourceGroupRoles.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TenantResourceGroupRoles getTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (TenantResourceGroupRoles)response.readEntity(TenantResourceGroupRoles.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public TenantResourceGroupRoles deleteTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef) {
        WebTarget target = this.base.path("/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", (Object)domain).resolveTemplate("service", (Object)service).resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ProviderResourceGroupRoles putProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef, ProviderResourceGroupRoles detail) {
        WebTarget target = this.base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("provDomain", (Object)provDomain).resolveTemplate("provService", (Object)provService).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)detail, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ProviderResourceGroupRoles)response.readEntity(ProviderResourceGroupRoles.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ProviderResourceGroupRoles getProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup) {
        WebTarget target = this.base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("provDomain", (Object)provDomain).resolveTemplate("provService", (Object)provService).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ProviderResourceGroupRoles)response.readEntity(ProviderResourceGroupRoles.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ProviderResourceGroupRoles deleteProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef) {
        WebTarget target = this.base.path("/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", (Object)tenantDomain).resolveTemplate("provDomain", (Object)provDomain).resolveTemplate("provService", (Object)provService).resolveTemplate("resourceGroup", (Object)resourceGroup);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Access getAccess(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}/{resource}").resolveTemplate("action", (Object)action).resolveTemplate("resource", (Object)resource);
        if (domain != null) {
            target = target.queryParam("domain", new Object[]{domain});
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", new Object[]{checkPrincipal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Access)response.readEntity(Access.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Access getAccessExt(String action, String resource, String domain, String checkPrincipal) {
        WebTarget target = this.base.path("/access/{action}").resolveTemplate("action", (Object)action);
        if (resource != null) {
            target = target.queryParam("resource", new Object[]{resource});
        }
        if (domain != null) {
            target = target.queryParam("domain", new Object[]{domain});
        }
        if (checkPrincipal != null) {
            target = target.queryParam("principal", new Object[]{checkPrincipal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Access)response.readEntity(Access.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ResourceAccessList getResourceAccessList(String principal, String action) {
        WebTarget target = this.base.path("/resource");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        if (action != null) {
            target = target.queryParam("action", new Object[]{action});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ResourceAccessList)response.readEntity(ResourceAccessList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public SignedDomains getSignedDomains(String domain, String metaOnly, String metaAttr, Boolean master, Boolean conditions, String matchingTag, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/sys/modified_domains");
        if (domain != null) {
            target = target.queryParam("domain", new Object[]{domain});
        }
        if (metaOnly != null) {
            target = target.queryParam("metaonly", new Object[]{metaOnly});
        }
        if (metaAttr != null) {
            target = target.queryParam("metaattr", new Object[]{metaAttr});
        }
        if (master != null) {
            target = target.queryParam("master", new Object[]{master});
        }
        if (conditions != null) {
            target = target.queryParam("conditions", new Object[]{conditions});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", (Object)matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 304: {
                if (headers != null) {
                    headers.put("tag", Arrays.asList((String)response.getHeaders().getFirst((Object)"ETag")));
                }
                if (code == 304) {
                    return null;
                }
                return (SignedDomains)response.readEntity(SignedDomains.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public JWSDomain getJWSDomain(String name, Boolean signatureP1363Format, String matchingTag, Map<String, List<String>> headers) {
        WebTarget target = this.base.path("/domain/{name}/signed").resolveTemplate("name", (Object)name);
        if (signatureP1363Format != null) {
            target = target.queryParam("signaturep1363format", new Object[]{signatureP1363Format});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (matchingTag != null) {
            invocationBuilder = invocationBuilder.header("If-None-Match", (Object)matchingTag);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: 
            case 304: {
                if (headers != null) {
                    headers.put("tag", Arrays.asList((String)response.getHeaders().getFirst((Object)"ETag")));
                }
                if (code == 304) {
                    return null;
                }
                return (JWSDomain)response.readEntity(JWSDomain.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public UserToken getUserToken(String userName, String serviceNames, Boolean header) {
        WebTarget target = this.base.path("/user/{userName}/token").resolveTemplate("userName", (Object)userName);
        if (serviceNames != null) {
            target = target.queryParam("services", new Object[]{serviceNames});
        }
        if (header != null) {
            target = target.queryParam("header", new Object[]{header});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (UserToken)response.readEntity(UserToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public UserToken optionsUserToken(String userName, String serviceNames) {
        WebTarget target = this.base.path("/user/{userName}/token").resolveTemplate("userName", (Object)userName);
        if (serviceNames != null) {
            target = target.queryParam("services", new Object[]{serviceNames});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        Response response = invocationBuilder.options();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (UserToken)response.readEntity(UserToken.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServicePrincipal getServicePrincipal() {
        WebTarget target = this.base.path("/principal");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServicePrincipal)response.readEntity(ServicePrincipal.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public ServerTemplateList getServerTemplateList() {
        WebTarget target = this.base.path("/template");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (ServerTemplateList)response.readEntity(ServerTemplateList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Template getTemplate(String template) {
        WebTarget target = this.base.path("/template/{template}").resolveTemplate("template", (Object)template);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Template)response.readEntity(Template.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplateDetailsList getDomainTemplateDetailsList(String name) {
        WebTarget target = this.base.path("/domain/{name}/templatedetails").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainTemplateDetailsList)response.readEntity(DomainTemplateDetailsList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainTemplateDetailsList getServerTemplateDetailsList() {
        WebTarget target = this.base.path("/templatedetails");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainTemplateDetailsList)response.readEntity(DomainTemplateDetailsList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public UserList getUserList(String domainName) {
        WebTarget target = this.base.path("/user");
        if (domainName != null) {
            target = target.queryParam("domain", new Object[]{domainName});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (UserList)response.readEntity(UserList.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public User deleteUser(String name, String auditRef) {
        WebTarget target = this.base.path("/user/{name}").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainRoleMember deleteDomainRoleMember(String domainName, String memberName, String auditRef) {
        WebTarget target = this.base.path("/domain/{domainName}/member/{memberName}").resolveTemplate("domainName", (Object)domainName).resolveTemplate("memberName", (Object)memberName);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Quota getQuota(String name) {
        WebTarget target = this.base.path("/domain/{name}/quota").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Quota)response.readEntity(Quota.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Quota putQuota(String name, String auditRef, Quota quota) {
        WebTarget target = this.base.path("/domain/{name}/quota").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.put(javax.ws.rs.client.Entity.entity((Object)quota, (String)"application/json"));
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Quota deleteQuota(String name, String auditRef) {
        WebTarget target = this.base.path("/domain/{name}/quota").resolveTemplate("name", (Object)name);
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            Invocation.Builder builder = invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        if (auditRef != null) {
            invocationBuilder = invocationBuilder.header("Y-Audit-Ref", (Object)auditRef);
        }
        Response response = invocationBuilder.delete();
        int code = response.getStatus();
        switch (code) {
            case 204: {
                return null;
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public Status getStatus() {
        WebTarget target = this.base.path("/status");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (Status)response.readEntity(Status.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public DomainRoleMembership getPendingDomainRoleMembersList(String principal) {
        WebTarget target = this.base.path("/pending_members");
        if (principal != null) {
            target = target.queryParam("principal", new Object[]{principal});
        }
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (DomainRoleMembership)response.readEntity(DomainRoleMembership.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }

    public UserAuthorityAttributeMap getUserAuthorityAttributeMap() {
        WebTarget target = this.base.path("/authority/user/attribute");
        Invocation.Builder invocationBuilder = target.request(new String[]{"application/json"});
        if (this.credsHeader != null) {
            invocationBuilder = this.credsHeader.startsWith("Cookie.") ? invocationBuilder.cookie(this.credsHeader.substring(7), this.credsToken) : invocationBuilder.header(this.credsHeader, (Object)this.credsToken);
        }
        Response response = invocationBuilder.get();
        int code = response.getStatus();
        switch (code) {
            case 200: {
                return (UserAuthorityAttributeMap)response.readEntity(UserAuthorityAttributeMap.class);
            }
        }
        throw new ResourceException(code, response.readEntity(ResourceError.class));
    }
}

