/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zms;

import com.yahoo.athenz.auth.Authority;
import com.yahoo.athenz.auth.Principal;
import com.yahoo.athenz.auth.PrivateKeyStore;
import com.yahoo.athenz.auth.impl.PrincipalAuthority;
import com.yahoo.athenz.auth.impl.SimplePrincipal;
import com.yahoo.athenz.auth.token.PrincipalToken;
import com.yahoo.athenz.common.config.AthenzConfig;
import com.yahoo.athenz.common.utils.SSLUtils;
import com.yahoo.athenz.zms.Access;
import com.yahoo.athenz.zms.Assertion;
import com.yahoo.athenz.zms.AssertionCondition;
import com.yahoo.athenz.zms.AssertionConditions;
import com.yahoo.athenz.zms.AuthHistoryDependencies;
import com.yahoo.athenz.zms.ClientResourceException;
import com.yahoo.athenz.zms.DefaultAdmins;
import com.yahoo.athenz.zms.DependentService;
import com.yahoo.athenz.zms.Domain;
import com.yahoo.athenz.zms.DomainDataCheck;
import com.yahoo.athenz.zms.DomainGroupMember;
import com.yahoo.athenz.zms.DomainGroupMembers;
import com.yahoo.athenz.zms.DomainGroupMembership;
import com.yahoo.athenz.zms.DomainList;
import com.yahoo.athenz.zms.DomainMeta;
import com.yahoo.athenz.zms.DomainMetaStoreValidValuesList;
import com.yahoo.athenz.zms.DomainRoleMember;
import com.yahoo.athenz.zms.DomainRoleMembers;
import com.yahoo.athenz.zms.DomainRoleMembership;
import com.yahoo.athenz.zms.DomainTemplate;
import com.yahoo.athenz.zms.DomainTemplateList;
import com.yahoo.athenz.zms.Entity;
import com.yahoo.athenz.zms.EntityList;
import com.yahoo.athenz.zms.ExpiredMembers;
import com.yahoo.athenz.zms.Group;
import com.yahoo.athenz.zms.GroupMembership;
import com.yahoo.athenz.zms.GroupMeta;
import com.yahoo.athenz.zms.GroupSystemMeta;
import com.yahoo.athenz.zms.Groups;
import com.yahoo.athenz.zms.Info;
import com.yahoo.athenz.zms.JWSDomain;
import com.yahoo.athenz.zms.Membership;
import com.yahoo.athenz.zms.Policies;
import com.yahoo.athenz.zms.Policy;
import com.yahoo.athenz.zms.PolicyList;
import com.yahoo.athenz.zms.PolicyOptions;
import com.yahoo.athenz.zms.PrincipalState;
import com.yahoo.athenz.zms.ProviderResourceGroupRoles;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zms.Quota;
import com.yahoo.athenz.zms.ResourceAccessList;
import com.yahoo.athenz.zms.ResourceDomainOwnership;
import com.yahoo.athenz.zms.ResourcePolicyOwnership;
import com.yahoo.athenz.zms.ResourceRoleOwnership;
import com.yahoo.athenz.zms.ResourceServiceIdentityOwnership;
import com.yahoo.athenz.zms.Role;
import com.yahoo.athenz.zms.RoleList;
import com.yahoo.athenz.zms.RoleMeta;
import com.yahoo.athenz.zms.RoleSystemMeta;
import com.yahoo.athenz.zms.Roles;
import com.yahoo.athenz.zms.ServerTemplateList;
import com.yahoo.athenz.zms.ServiceIdentities;
import com.yahoo.athenz.zms.ServiceIdentity;
import com.yahoo.athenz.zms.ServiceIdentityList;
import com.yahoo.athenz.zms.ServiceIdentitySystemMeta;
import com.yahoo.athenz.zms.ServicePrincipal;
import com.yahoo.athenz.zms.SignedDomains;
import com.yahoo.athenz.zms.Stats;
import com.yahoo.athenz.zms.SubDomain;
import com.yahoo.athenz.zms.Template;
import com.yahoo.athenz.zms.Tenancy;
import com.yahoo.athenz.zms.TenantResourceGroupRoles;
import com.yahoo.athenz.zms.TopLevelDomain;
import com.yahoo.athenz.zms.UserDomain;
import com.yahoo.athenz.zms.UserList;
import com.yahoo.athenz.zms.UserToken;
import com.yahoo.athenz.zms.ZMSClientException;
import com.yahoo.athenz.zms.ZMSRDLGeneratedClient;
import com.yahoo.rdl.JSON;
import com.yahoo.rdl.Timestamp;
import java.io.Closeable;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZMSClient
implements Closeable {
    private String zmsUrl = null;
    private Principal principal = null;
    private boolean principalCheckDone = false;
    protected ZMSRDLGeneratedClient client = null;
    private static DnsResolver dnsResolver = null;
    private static final String STR_ENV_ROOT = "ROOT";
    private static final String STR_DEF_ROOT = "/home/athenz";
    private static final String HTTP_RFC1123_DATE_FORMAT = "EEE, d MMM yyyy HH:mm:ss zzz";
    public static final String ZMS_CLIENT_PROP_ATHENZ_CONF = "athenz.athenz_conf";
    public static final String ZMS_CLIENT_PROP_READ_TIMEOUT = "athenz.zms.client.read_timeout";
    public static final String ZMS_CLIENT_PROP_CONNECT_TIMEOUT = "athenz.zms.client.connect_timeout";
    public static final String ZMS_CLIENT_PROP_HANDSHAKE_TIMEOUT = "athenz.zms.client.handshake_timeout";
    public static final String ZMS_CLIENT_PROP_POOL_MAX_PER_ROUTE = "athenz.zms.client.http_pool_max_per_route";
    public static final String ZMS_CLIENT_PROP_POOL_MAX_TOTAL = "athenz.zms.client.http_pool_max_total";
    public static final String ZMS_CLIENT_PROP_TIME_TO_LIVE = "athenz.zms.client.http_pool_time_to_live";
    public static final String ZMS_CLIENT_PROP_MAX_RETRIES = "athenz.zms.client.http_pool_max_retries";
    public static final String ZMS_CLIENT_PROP_RETRY_TIMEOUT = "athenz.zms.client.http_pool_retry_timeout";
    public static final String ZMS_CLIENT_PROP_VALIDATE_AFTER_INACTIVITY = "athenz.zms.client.http_pool_validate_after_inactivity";
    public static final String ZMS_CLIENT_PROP_CERT_ALIAS = "athenz.zms.client.cert_alias";
    public static final String ZMS_CLIENT_PROP_KEYSTORE_PATH = "athenz.zms.client.keystore_path";
    public static final String ZMS_CLIENT_PROP_KEYSTORE_TYPE = "athenz.zms.client.keystore_type";
    public static final String ZMS_CLIENT_PROP_KEYSTORE_PASSWORD = "athenz.zms.client.keystore_password";
    public static final String ZMS_CLIENT_PROP_KEYSTORE_PWD_APP_NAME = "athenz.zms.client.keystore_pwd_app_name";
    public static final String ZMS_CLIENT_PROP_KEYSTORE_PWD_KEYGROUP_NAME = "athenz.zms.client.keystore_pwd_keygroup_name";
    public static final String ZMS_CLIENT_PROP_KEY_MANAGER_PASSWORD = "athenz.zms.client.keymanager_password";
    public static final String ZMS_CLIENT_PROP_KEY_MANAGER_PWD_APP_NAME = "athenz.zms.client.keymanager_pwd_app_name";
    public static final String ZMS_CLIENT_PROP_KEY_MANAGER_PWD_KEYGROUP_NAME = "athenz.zms.client.keymanager_pwd_keygroup_name";
    public static final String ZMS_CLIENT_PROP_TRUSTSTORE_PATH = "athenz.zms.client.truststore_path";
    public static final String ZMS_CLIENT_PROP_TRUSTSTORE_TYPE = "athenz.zms.client.truststore_type";
    public static final String ZMS_CLIENT_PROP_TRUSTSTORE_PASSWORD = "athenz.zms.client.truststore_password";
    public static final String ZMS_CLIENT_PROP_TRUSTSTORE_PWD_APP_NAME = "athenz.zms.client.truststore_pwd_app_name";
    public static final String ZMS_CLIENT_PROP_TRUSTSTORE_PWD_KEYGROUP_NAME = "athenz.zms.client.truststore_pwd_keygroup_name";
    public static final String ZMS_CLIENT_PROP_PRIVATE_KEY_STORE_FACTORY_CLASS = "athenz.zms.client.private_keystore_factory_class";
    public static final String ZMS_CLIENT_PROP_CLIENT_PROTOCOL = "athenz.zms.client.client_ssl_protocol";
    public static final String ZMS_CLIENT_PKEY_STORE_FACTORY_CLASS = "com.yahoo.athenz.auth.impl.FilePrivateKeyStoreFactory";
    public static final String ZMS_CLIENT_DEFAULT_CLIENT_SSL_PROTOCOL = "TLSv1.2";
    private static final Logger LOGGER = LoggerFactory.getLogger(ZMSClient.class);
    private static final Authority PRINCIPAL_AUTHORITY = new PrincipalAuthority();
    private static final PrivateKeyStore PRIVATE_KEY_STORE = ZMSClient.loadServicePrivateKey();

    static PrivateKeyStore loadServicePrivateKey() {
        String pkeyFactoryClass = System.getProperty(ZMS_CLIENT_PROP_PRIVATE_KEY_STORE_FACTORY_CLASS, ZMS_CLIENT_PKEY_STORE_FACTORY_CLASS);
        return SSLUtils.loadServicePrivateKey((String)pkeyFactoryClass);
    }

    public ZMSClient() {
        this.initClient(null, null);
    }

    public ZMSClient(String url) {
        this.initClient(url, null);
    }

    public ZMSClient(String url, Principal identity) {
        this.initClient(url, null);
        this.addCredentials(identity);
    }

    public ZMSClient(Principal identity) {
        this.initClient(null, null);
        this.addCredentials(identity);
    }

    public ZMSClient(String url, SSLContext sslContext) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSLContext object must be specified");
        }
        this.initClient(url, sslContext);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public void setDnsResolver(DnsResolver resolver) {
        dnsResolver = resolver;
    }

    public void setZMSRDLGeneratedClient(ZMSRDLGeneratedClient client) {
        this.client = client;
    }

    public void addCredentials(String credHeader, String credToken) {
        this.client.addCredentials(credHeader, credToken);
    }

    public ZMSClient addCredentials(Principal identity) {
        if (identity == null || identity.getAuthority() == null) {
            throw new IllegalArgumentException("Principal must be valid object with authority field");
        }
        if (this.principal != null) {
            this.client.addCredentials(this.principal.getAuthority().getHeader(), null);
        }
        this.principal = identity;
        this.principalCheckDone = false;
        Authority authority = this.principal.getAuthority();
        this.client.addCredentials(authority.getHeader(), this.principal.getCredentials());
        this.principalCheckDone = authority.allowAuthorization();
        return this;
    }

    public ZMSClient clearCredentials() {
        if (this.principal != null) {
            this.client.addCredentials(this.principal.getAuthority().getHeader(), null);
            this.principal = null;
            this.principalCheckDone = true;
        }
        return this;
    }

    private void updatePrincipal() {
        if (this.principalCheckDone) {
            return;
        }
        if (this.principal == null) {
            this.principalCheckDone = true;
            return;
        }
        String userName = this.principal.getName();
        UserToken userToken = this.getUserToken(userName, null, true);
        this.clearCredentials();
        this.client.addCredentials(userToken.getHeader(), userToken.getToken());
        this.principalCheckDone = true;
    }

    String lookupZMSUrl() {
        String rootDir = System.getenv(STR_ENV_ROOT);
        if (rootDir == null) {
            rootDir = STR_DEF_ROOT;
        }
        String confFileName = System.getProperty(ZMS_CLIENT_PROP_ATHENZ_CONF, rootDir + "/conf/athenz/athenz.conf");
        String url = null;
        try {
            Path path = Paths.get(confFileName, new String[0]);
            AthenzConfig conf = (AthenzConfig)JSON.fromBytes((byte[])Files.readAllBytes(path), AthenzConfig.class);
            url = conf.getZmsUrl();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to extract ZMS Url from {} exc: {}", (Object)confFileName, (Object)ex.getMessage());
        }
        return url;
    }

    protected PoolingHttpClientConnectionManager createConnectionPooling(SSLContext sslContext) {
        if (sslContext == null) {
            return null;
        }
        int maxPerRoute = Integer.parseInt(System.getProperty(ZMS_CLIENT_PROP_POOL_MAX_PER_ROUTE, "2"));
        int maxTotal = Integer.parseInt(System.getProperty(ZMS_CLIENT_PROP_POOL_MAX_TOTAL, "20"));
        long readTimeout = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_READ_TIMEOUT, "30000"));
        long connectTimeout = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_CONNECT_TIMEOUT, "30000"));
        long handshakeTimeout = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_HANDSHAKE_TIMEOUT, "30000"));
        long timeToLive = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_TIME_TO_LIVE, "10"));
        long validateAfterInactivity = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_VALIDATE_AFTER_INACTIVITY, "0"));
        DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext);
        return PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy).setDefaultTlsConfig(TlsConfig.custom().setHandshakeTimeout(Timeout.ofMilliseconds((long)handshakeTimeout)).setSupportedProtocols(new TLS[]{TLS.V_1_2, TLS.V_1_3}).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMilliseconds((long)readTimeout)).setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout)).setTimeToLive(TimeValue.ofMinutes((long)timeToLive)).setValidateAfterInactivity(TimeValue.ofMilliseconds((long)validateAfterInactivity)).build()).setDnsResolver(dnsResolver).setMaxConnPerRoute(maxPerRoute).setMaxConnTotal(maxTotal).build();
    }

    protected CloseableHttpClient createHttpClient(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager) {
        int maxRetries = Integer.parseInt(System.getProperty(ZMS_CLIENT_PROP_MAX_RETRIES, "0"));
        long retryTimeout = Long.parseLong(System.getProperty(ZMS_CLIENT_PROP_RETRY_TIMEOUT, "2000"));
        CustomRequestRetryStrategy retryStrategy = null;
        if (maxRetries > 0) {
            retryStrategy = new CustomRequestRetryStrategy(maxRetries, TimeValue.ofMilliseconds((long)retryTimeout));
        }
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(config).setRetryStrategy((HttpRequestRetryStrategy)retryStrategy).build();
    }

    private void initClient(String url, SSLContext sslContext) {
        String string = this.zmsUrl = url == null ? this.lookupZMSUrl() : url;
        if (this.zmsUrl == null || this.zmsUrl.isEmpty()) {
            throw new IllegalArgumentException("ZMS url must be specified");
        }
        if (!this.zmsUrl.endsWith("/zms/v1")) {
            if (this.zmsUrl.charAt(this.zmsUrl.length() - 1) != '/') {
                this.zmsUrl = this.zmsUrl + "/";
            }
            this.zmsUrl = this.zmsUrl + "zms/v1";
        }
        if (sslContext == null) {
            sslContext = this.createSSLContext();
        }
        PoolingHttpClientConnectionManager connManager = this.createConnectionPooling(sslContext);
        CloseableHttpClient httpClient = this.createHttpClient(connManager);
        this.client = new ZMSRDLGeneratedClient(this.zmsUrl, httpClient);
    }

    SSLContext createSSLContext() {
        String keyStorePath = System.getProperty(ZMS_CLIENT_PROP_KEYSTORE_PATH);
        if (keyStorePath == null || keyStorePath.isEmpty()) {
            return null;
        }
        String keyStoreType = System.getProperty(ZMS_CLIENT_PROP_KEYSTORE_TYPE);
        String keyStorePwd = System.getProperty(ZMS_CLIENT_PROP_KEYSTORE_PASSWORD);
        char[] keyStorePassword = null;
        if (null != keyStorePwd && !keyStorePwd.isEmpty()) {
            keyStorePassword = keyStorePwd.toCharArray();
        }
        String keyStorePasswordAppName = System.getProperty(ZMS_CLIENT_PROP_KEYSTORE_PWD_APP_NAME);
        String keyStorePasswordKeygroupName = System.getProperty(ZMS_CLIENT_PROP_KEYSTORE_PWD_KEYGROUP_NAME);
        char[] keyManagerPassword = null;
        String keyManagerPwd = System.getProperty(ZMS_CLIENT_PROP_KEY_MANAGER_PASSWORD);
        if (null != keyManagerPwd && !keyManagerPwd.isEmpty()) {
            keyManagerPassword = keyManagerPwd.toCharArray();
        }
        String keyManagerPasswordAppName = System.getProperty(ZMS_CLIENT_PROP_KEY_MANAGER_PWD_APP_NAME);
        String keyManagerPasswordKeygroupName = System.getProperty(ZMS_CLIENT_PROP_KEY_MANAGER_PWD_KEYGROUP_NAME);
        String trustStorePath = System.getProperty(ZMS_CLIENT_PROP_TRUSTSTORE_PATH);
        String trustStoreType = System.getProperty(ZMS_CLIENT_PROP_TRUSTSTORE_TYPE);
        String trustStorePwd = System.getProperty(ZMS_CLIENT_PROP_TRUSTSTORE_PASSWORD);
        char[] trustStorePassword = null;
        if (null != trustStorePwd && !trustStorePwd.isEmpty()) {
            trustStorePassword = trustStorePwd.toCharArray();
        }
        String trustStorePasswordAppName = System.getProperty(ZMS_CLIENT_PROP_TRUSTSTORE_PWD_APP_NAME);
        String trustStorePasswordKeygroupName = System.getProperty(ZMS_CLIENT_PROP_TRUSTSTORE_PWD_KEYGROUP_NAME);
        String certAlias = System.getProperty(ZMS_CLIENT_PROP_CERT_ALIAS);
        String clientProtocol = System.getProperty(ZMS_CLIENT_PROP_CLIENT_PROTOCOL, ZMS_CLIENT_DEFAULT_CLIENT_SSL_PROTOCOL);
        SSLUtils.ClientSSLContextBuilder builder = new SSLUtils.ClientSSLContextBuilder(clientProtocol).privateKeyStore(PRIVATE_KEY_STORE).keyStorePath(keyStorePath);
        builder.certAlias(certAlias);
        if (null != keyStoreType && !keyStoreType.isEmpty()) {
            builder.keyStoreType(keyStoreType);
        }
        builder.keyStorePassword(keyStorePassword);
        builder.keyStorePasswordAppName(keyStorePasswordAppName);
        builder.keyStorePasswordKeygroupName(keyStorePasswordKeygroupName);
        builder.keyManagerPassword(keyManagerPassword);
        builder.keyManagerPasswordAppName(keyManagerPasswordAppName);
        builder.keyManagerPasswordKeygroupName(keyManagerPasswordKeygroupName);
        builder.trustStorePath(trustStorePath);
        if (null != trustStoreType && !trustStoreType.isEmpty()) {
            builder.trustStoreType(trustStoreType);
        }
        builder.trustStorePassword(trustStorePassword);
        builder.trustStorePasswordAppName(trustStorePasswordAppName);
        builder.trustStorePasswordKeygroupName(trustStorePasswordKeygroupName);
        return builder.build();
    }

    public String getZmsUrl() {
        return this.zmsUrl;
    }

    public String generateRoleName(String domain, String role) {
        return domain + ":role." + role;
    }

    public String generatePolicyName(String domain, String policy) {
        return domain + ":policy." + policy;
    }

    public String generateServiceIdentityName(String domain, String service) {
        return domain + "." + service;
    }

    public String generateEntityName(String domain, String entity) {
        return domain + ":entity." + entity;
    }

    public Domain getDomain(String domain) {
        this.updatePrincipal();
        try {
            return this.client.getDomain(domain);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public JWSDomain getJWSDomain(String domain) {
        return this.getJWSDomain(domain, false, null, null);
    }

    public JWSDomain getJWSDomain(String domain, String matchingTag, Map<String, List<String>> responseHeaders) {
        return this.getJWSDomain(domain, false, matchingTag, responseHeaders);
    }

    public JWSDomain getJWSDomain(String domain, Boolean signatureP1363Format, String matchingTag, Map<String, List<String>> responseHeaders) {
        this.updatePrincipal();
        try {
            return this.client.getJWSDomain(domain, signatureP1363Format, matchingTag, responseHeaders);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainList getDomainList() {
        return this.getDomainList(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, Date modifiedSince) {
        return this.getDomainList(limit, skip, prefix, depth, null, null, null, null, null, null, null, null, null, null, modifiedSince);
    }

    @Deprecated
    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String awsAccount, Integer productNumber, Date modifiedSince) {
        return this.getDomainList(limit, skip, prefix, depth, awsAccount, productNumber, null, null, null, null, null, null, null, null, modifiedSince);
    }

    @Deprecated
    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String awsAccount, Integer productNumber, String azureSubscription, Date modifiedSince) {
        return this.getDomainList(limit, skip, prefix, depth, awsAccount, productNumber, null, null, azureSubscription, null, null, null, null, null, modifiedSince);
    }

    @Deprecated
    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String awsAccount, Integer productNumber, String azureSubscription, Date modifiedSince, String tagKey, String tagValue) {
        return this.getDomainList(limit, skip, prefix, depth, awsAccount, productNumber, null, null, azureSubscription, null, tagKey, tagValue, null, null, modifiedSince);
    }

    @Deprecated
    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String awsAccount, Integer productNumber, String azureSubscription, Date modifiedSince, String tagKey, String tagValue, String businessService) {
        return this.getDomainList(limit, skip, prefix, depth, awsAccount, productNumber, null, null, azureSubscription, null, tagKey, tagValue, businessService, null, modifiedSince);
    }

    public DomainList getDomainListByProductId(Integer productNumber) {
        return this.getDomainList(null, null, null, null, null, productNumber, null, null, null, null, null, null, null, null, null);
    }

    public DomainList getDomainListByProductId(String productId) {
        return this.getDomainList(null, null, null, null, null, null, null, null, null, null, null, null, null, productId, null);
    }

    public DomainList getDomainListByTags(String tagKey, String tagValue) {
        return this.getDomainList(null, null, null, null, null, null, null, null, null, null, tagKey, tagValue, null, null, null);
    }

    public DomainList getDomainListByBusinessService(String businessService) {
        return this.getDomainList(null, null, null, null, null, null, null, null, null, null, null, null, businessService, null, null);
    }

    public DomainList getDomainListByAwsAccount(String awsAccount) {
        return this.getDomainList(null, null, null, null, awsAccount, null, null, null, null, null, null, null, null, null, null);
    }

    public DomainList getDomainListByAzureSubscription(String azureSubscription) {
        return this.getDomainList(null, null, null, null, null, null, null, null, azureSubscription, null, null, null, null, null, null);
    }

    public DomainList getDomainListByGcpProject(String gcpProject) {
        return this.getDomainList(null, null, null, null, null, null, null, null, null, gcpProject, null, null, null, null, null);
    }

    public DomainList getDomainListByRole(String roleMember, String roleName) {
        return this.getDomainList(null, null, null, null, null, null, roleMember, roleName, null, null, null, null, null, null, null);
    }

    @Deprecated
    public DomainList getDomainList(String roleMember, String roleName) {
        return this.getDomainList(null, null, null, null, null, null, roleMember, roleName, null, null, null, null, null, null, null);
    }

    private DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String awsAccount, Integer productNumber, String roleMember, String roleName, String azureSubscription, String gcpProject, String tagKey, String tagValue, String businessService, String productId, Date modifiedSince) {
        this.updatePrincipal();
        String modSinceStr = null;
        if (modifiedSince != null) {
            SimpleDateFormat df = new SimpleDateFormat(HTTP_RFC1123_DATE_FORMAT);
            modSinceStr = df.format(modifiedSince);
        }
        try {
            return this.client.getDomainList(limit, skip, prefix, depth, awsAccount, productNumber, roleMember, roleName, azureSubscription, gcpProject, tagKey, tagValue, businessService, productId, modSinceStr);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Domain postTopLevelDomain(String auditRef, String resourceOwner, TopLevelDomain detail) {
        this.updatePrincipal();
        try {
            return this.client.postTopLevelDomain(auditRef, resourceOwner, detail);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Domain postTopLevelDomain(String auditRef, TopLevelDomain detail) {
        return this.postTopLevelDomain(auditRef, null, detail);
    }

    public Domain postSubDomain(String parent, String auditRef, String resourceOwner, SubDomain detail) {
        this.updatePrincipal();
        try {
            return this.client.postSubDomain(parent, auditRef, resourceOwner, detail);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Domain postSubDomain(String parent, String auditRef, SubDomain detail) {
        return this.postSubDomain(parent, auditRef, null, detail);
    }

    public Domain postUserDomain(String name, String auditRef, String resourceOwner, UserDomain detail) {
        this.updatePrincipal();
        try {
            return this.client.postUserDomain(name, auditRef, resourceOwner, detail);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Domain postUserDomain(String name, String auditRef, UserDomain detail) {
        return this.postUserDomain(name, auditRef, null, detail);
    }

    public void deleteTopLevelDomain(String name, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteTopLevelDomain(name, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteTopLevelDomain(String name, String auditRef) {
        this.deleteTopLevelDomain(name, auditRef, null);
    }

    public void deleteSubDomain(String parent, String name, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteSubDomain(parent, name, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteSubDomain(String parent, String name, String auditRef) {
        this.deleteSubDomain(parent, name, auditRef, null);
    }

    public void deleteUserDomain(String name, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteUserDomain(name, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteUserDomain(String name, String auditRef) {
        this.deleteUserDomain(name, auditRef, null);
    }

    public void putDomainMeta(String name, String auditRef, String resourceOwner, DomainMeta detail) {
        this.updatePrincipal();
        try {
            this.client.putDomainMeta(name, auditRef, resourceOwner, detail);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putDomainMeta(String name, String auditRef, DomainMeta detail) {
        this.putDomainMeta(name, auditRef, null, detail);
    }

    public void putDomainSystemMeta(String name, String attribute, String auditRef, DomainMeta detail) {
        this.updatePrincipal();
        try {
            this.client.putDomainSystemMeta(name, attribute, auditRef, detail);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public RoleList getRoleList(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getRoleList(domainName, null, null);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public RoleList getRoleList(String domainName, Integer limit, String skip) {
        this.updatePrincipal();
        try {
            return this.client.getRoleList(domainName, limit, skip);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Roles getRoles(String domainName, Boolean members, String tagKey, String tagValue) {
        this.updatePrincipal();
        try {
            return this.client.getRoles(domainName, members, tagKey, tagValue);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Roles getRoles(String domainName, Boolean members) {
        return this.getRoles(domainName, members, null, null);
    }

    public Role getRole(String domainName, String roleName) {
        return this.getRole(domainName, roleName, false, false, false);
    }

    public Role getRole(String domainName, String roleName, boolean auditLog) {
        return this.getRole(domainName, roleName, auditLog, false, false);
    }

    public Role getRole(String domainName, String roleName, boolean auditLog, boolean expand) {
        return this.getRole(domainName, roleName, auditLog, expand, false);
    }

    public Role getRole(String domainName, String roleName, boolean auditLog, boolean expand, boolean pending) {
        this.updatePrincipal();
        try {
            return this.client.getRole(domainName, roleName, auditLog, expand, pending);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Role putRole(String domainName, String roleName, String auditRef, Boolean returnObj, String resourceOwner, Role role) {
        this.updatePrincipal();
        try {
            return this.client.putRole(domainName, roleName, auditRef, returnObj, resourceOwner, role);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Role putRole(String domainName, String roleName, String auditRef, Boolean returnObj, Role role) {
        return this.putRole(domainName, roleName, auditRef, returnObj, null, role);
    }

    public void putRole(String domainName, String roleName, String auditRef, Role role) {
        this.putRole(domainName, roleName, auditRef, false, role);
    }

    public void deleteRole(String domainName, String roleName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteRole(domainName, roleName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteRole(String domainName, String roleName, String auditRef) {
        this.deleteRole(domainName, roleName, auditRef, null);
    }

    public Membership getMembership(String domainName, String roleName, String memberName) {
        return this.getMembership(domainName, roleName, memberName, null);
    }

    public Membership getMembership(String domainName, String roleName, String memberName, String expiration) {
        this.updatePrincipal();
        try {
            return this.client.getMembership(domainName, roleName, memberName, expiration);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainRoleMembers getOverdueReview(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getOverdueReview(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putMembership(String domainName, String roleName, String memberName, String auditRef) {
        this.putMembershipWithReview(domainName, roleName, memberName, null, null, auditRef);
    }

    public Membership putMembership(String domainName, String roleName, String memberName, String auditRef, Boolean returnObj) {
        return this.putMembershipWithReview(domainName, roleName, memberName, null, null, auditRef, returnObj);
    }

    public void putMembership(String domainName, String roleName, String memberName, Timestamp expiration, String auditRef) {
        this.putMembershipWithReview(domainName, roleName, memberName, expiration, null, auditRef);
    }

    public Membership putMembership(String domainName, String roleName, String memberName, Timestamp expiration, String auditRef, Boolean returnObj) {
        return this.putMembershipWithReview(domainName, roleName, memberName, expiration, null, auditRef, returnObj);
    }

    public Membership putMembershipWithReview(String domainName, String roleName, String memberName, Timestamp expiration, Timestamp review, String auditRef, Boolean returnObj, String resourceOwner) {
        Membership mbr = new Membership().setRoleName(roleName).setMemberName(memberName).setExpiration(expiration).setReviewReminder(review).setIsMember(Boolean.valueOf(true));
        this.updatePrincipal();
        try {
            return this.client.putMembership(domainName, roleName, memberName, auditRef, returnObj, resourceOwner, mbr);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Membership putMembershipWithReview(String domainName, String roleName, String memberName, Timestamp expiration, Timestamp review, String auditRef, Boolean returnObj) {
        return this.putMembershipWithReview(domainName, roleName, memberName, expiration, review, auditRef, returnObj, null);
    }

    public void putMembershipWithReview(String domainName, String roleName, String memberName, Timestamp expiration, Timestamp review, String auditRef) {
        this.putMembershipWithReview(domainName, roleName, memberName, expiration, review, auditRef, false);
    }

    public void deleteMembership(String domainName, String roleName, String memberName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteMembership(domainName, roleName, memberName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteMembership(String domainName, String roleName, String memberName, String auditRef) {
        this.deleteMembership(domainName, roleName, memberName, auditRef, null);
    }

    public void deletePendingMembership(String domainName, String roleName, String memberName, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deletePendingMembership(domainName, roleName, memberName, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public UserList getUserList(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getUserList(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public UserList getUserList() {
        return this.getUserList(null);
    }

    public void deleteUser(String name, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteUser(name, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Policies getPolicies(String domainName, Boolean assertions) {
        return this.getPoliciesImpl(domainName, assertions, false);
    }

    public Policies getPolicies(String domainName, Boolean assertions, Boolean includeNonActive) {
        return this.getPoliciesImpl(domainName, assertions, includeNonActive);
    }

    private Policies getPoliciesImpl(String domainName, Boolean assertions, Boolean includeNonActive) {
        this.updatePrincipal();
        try {
            return this.client.getPolicies(domainName, assertions, includeNonActive, null, null);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public PolicyList getPolicyList(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getPolicyList(domainName, null, null);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public PolicyList getPolicyList(String domainName, Integer limit, String skip) {
        this.updatePrincipal();
        try {
            return this.client.getPolicyList(domainName, limit, skip);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public PolicyList getPolicyVersionList(String domainName, String policyName) {
        this.updatePrincipal();
        try {
            return this.client.getPolicyVersionList(domainName, policyName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Assertion getAssertion(String domainName, String policyName, Long assertionId) {
        this.updatePrincipal();
        try {
            return this.client.getAssertion(domainName, policyName, assertionId);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Assertion putAssertion(String domainName, String policyName, String auditRef, String resourceOwner, Assertion assertion) {
        this.updatePrincipal();
        try {
            return this.client.putAssertion(domainName, policyName, auditRef, resourceOwner, assertion);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Assertion putAssertion(String domainName, String policyName, String auditRef, Assertion assertion) {
        return this.putAssertion(domainName, policyName, auditRef, null, assertion);
    }

    public Assertion putAssertionPolicyVersion(String domainName, String policyName, String version, String auditRef, String resourceOwner, Assertion assertion) {
        this.updatePrincipal();
        try {
            return this.client.putAssertionPolicyVersion(domainName, policyName, version, auditRef, resourceOwner, assertion);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Assertion putAssertionPolicyVersion(String domainName, String policyName, String version, String auditRef, Assertion assertion) {
        return this.putAssertionPolicyVersion(domainName, policyName, version, auditRef, null, assertion);
    }

    public void deleteAssertion(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteAssertion(domainName, policyName, assertionId, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteAssertion(String domainName, String policyName, Long assertionId, String auditRef) {
        this.deleteAssertion(domainName, policyName, assertionId, auditRef, null);
    }

    public void deleteAssertion(String domainName, String policyName, String version, Long assertionId, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteAssertionPolicyVersion(domainName, policyName, version, assertionId, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteAssertion(String domainName, String policyName, String version, Long assertionId, String auditRef) {
        this.deleteAssertion(domainName, policyName, version, assertionId, auditRef, null);
    }

    public Policy getPolicy(String domainName, String policyName) {
        this.updatePrincipal();
        try {
            return this.client.getPolicy(domainName, policyName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Policy getPolicyVersion(String domainName, String policyName, String version) {
        this.updatePrincipal();
        try {
            return this.client.getPolicyVersion(domainName, policyName, version);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Policy putPolicy(String domainName, String policyName, String auditRef, Boolean returnObj, String resourceOwner, Policy policy) {
        this.updatePrincipal();
        try {
            return this.client.putPolicy(domainName, policyName, auditRef, returnObj, resourceOwner, policy);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Policy putPolicy(String domainName, String policyName, String auditRef, Boolean returnObj, Policy policy) {
        return this.putPolicy(domainName, policyName, auditRef, returnObj, null, policy);
    }

    public void putPolicy(String domainName, String policyName, String auditRef, Policy policy) {
        this.putPolicy(domainName, policyName, auditRef, false, policy);
    }

    public void putPolicyVersion(String domainName, String policyName, String version, String auditRef) {
        this.putPolicyVersionImpl(domainName, policyName, version, null, auditRef, false, null);
    }

    public Policy putPolicyVersion(String domainName, String policyName, String version, String fromVersion, String auditRef, Boolean returnObj) {
        return this.putPolicyVersionImpl(domainName, policyName, version, fromVersion, auditRef, returnObj, null);
    }

    public void putPolicyVersion(String domainName, String policyName, String version, String fromVersion, String auditRef) {
        this.putPolicyVersionImpl(domainName, policyName, version, fromVersion, auditRef, false, null);
    }

    public void putPolicyVersion(String domainName, String policyName, String version, String fromVersion, String auditRef, String resourceOwner) {
        this.putPolicyVersionImpl(domainName, policyName, version, fromVersion, auditRef, false, resourceOwner);
    }

    private Policy putPolicyVersionImpl(String domainName, String policyName, String version, String fromVersion, String auditRef, Boolean returnObj, String resourceOwner) {
        this.updatePrincipal();
        try {
            PolicyOptions policyOptions = new PolicyOptions();
            policyOptions.setVersion(version);
            if (fromVersion != null) {
                policyOptions.setFromVersion(fromVersion);
            }
            return this.client.putPolicyVersion(domainName, policyName, policyOptions, auditRef, returnObj, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deletePolicy(String domainName, String policyName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deletePolicy(domainName, policyName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deletePolicy(String domainName, String policyName, String auditRef) {
        this.deletePolicy(domainName, policyName, auditRef, null);
    }

    public void deletePolicyVersion(String domainName, String policyName, String version, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deletePolicyVersion(domainName, policyName, version, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deletePolicyVersion(String domainName, String policyName, String version, String auditRef) {
        this.deletePolicyVersion(domainName, policyName, version, auditRef, null);
    }

    public void setActivePolicyVersion(String domainName, String policyName, String version, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            PolicyOptions policyOptions = new PolicyOptions();
            policyOptions.setVersion(version);
            this.client.setActivePolicyVersion(domainName, policyName, policyOptions, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void setActivePolicyVersion(String domainName, String policyName, String version, String auditRef) {
        this.setActivePolicyVersion(domainName, policyName, version, auditRef, null);
    }

    public ServiceIdentity putServiceIdentity(String domainName, String serviceName, String auditRef, Boolean returnObj, String resourceOwner, ServiceIdentity service) {
        this.updatePrincipal();
        try {
            return this.client.putServiceIdentity(domainName, serviceName, auditRef, returnObj, resourceOwner, service);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentity putServiceIdentity(String domainName, String serviceName, String auditRef, Boolean returnObj, ServiceIdentity service) {
        return this.putServiceIdentity(domainName, serviceName, auditRef, returnObj, null, service);
    }

    public void putServiceIdentity(String domainName, String serviceName, String auditRef, ServiceIdentity service) {
        this.putServiceIdentity(domainName, serviceName, auditRef, false, service);
    }

    public void putServiceIdentitySystemMeta(String domainName, String serviceName, String attribute, String auditRef, ServiceIdentitySystemMeta meta) {
        this.updatePrincipal();
        try {
            this.client.putServiceIdentitySystemMeta(domainName, serviceName, attribute, auditRef, meta);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentity getServiceIdentity(String domainName, String serviceName) {
        this.updatePrincipal();
        try {
            return this.client.getServiceIdentity(domainName, serviceName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteServiceIdentity(String domainName, String serviceName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteServiceIdentity(domainName, serviceName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteServiceIdentity(String domainName, String serviceName, String auditRef) {
        this.deleteServiceIdentity(domainName, serviceName, auditRef, null);
    }

    public ServiceIdentities getServiceIdentities(String domainName, Boolean publicKeys, Boolean hosts) {
        return this.getServiceIdentities(domainName, publicKeys, hosts, null, null);
    }

    public ServiceIdentities getServiceIdentities(String domainName, Boolean publicKeys, Boolean hosts, String tagKey, String tagValue) {
        this.updatePrincipal();
        try {
            return this.client.getServiceIdentities(domainName, publicKeys, hosts, tagKey, tagValue);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentityList getServiceIdentityList(String domainName) {
        return this.getServiceIdentityList(domainName, null, null);
    }

    public ServiceIdentityList getServiceIdentityList(String domainName, Integer limit, String skip) {
        this.updatePrincipal();
        try {
            return this.client.getServiceIdentityList(domainName, limit, skip);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public PublicKeyEntry getPublicKeyEntry(String domainName, String serviceName, String keyId) {
        this.updatePrincipal();
        try {
            return this.client.getPublicKeyEntry(domainName, serviceName, keyId);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putPublicKeyEntry(String domainName, String serviceName, String keyId, String auditRef, String resourceOwner, PublicKeyEntry publicKeyEntry) {
        this.updatePrincipal();
        try {
            this.client.putPublicKeyEntry(domainName, serviceName, keyId, auditRef, resourceOwner, publicKeyEntry);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putPublicKeyEntry(String domainName, String serviceName, String keyId, String auditRef, PublicKeyEntry publicKeyEntry) {
        this.putPublicKeyEntry(domainName, serviceName, keyId, auditRef, null, publicKeyEntry);
    }

    public void deletePublicKeyEntry(String domainName, String serviceName, String keyId, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deletePublicKeyEntry(domainName, serviceName, keyId, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deletePublicKeyEntry(String domainName, String serviceName, String keyId, String auditRef) {
        this.deletePublicKeyEntry(domainName, serviceName, keyId, auditRef, null);
    }

    public void putEntity(String domainName, String entityName, String auditRef, Entity entity) {
        this.updatePrincipal();
        try {
            this.client.putEntity(domainName, entityName, auditRef, entity);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Entity getEntity(String domainName, String entityName) {
        this.updatePrincipal();
        try {
            return this.client.getEntity(domainName, entityName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteEntity(String domainName, String entityName, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteEntity(domainName, entityName, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public EntityList getEntityList(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getEntityList(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putTenancy(String tenantDomain, String providerService, String auditRef, Tenancy tenant) {
        this.updatePrincipal();
        try {
            this.client.putTenancy(tenantDomain, providerService, auditRef, tenant);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteTenancy(String tenantDomain, String providerService, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteTenancy(tenantDomain, providerService, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putTenant(String providerDomain, String providerService, String tenantDomain, String auditRef, Tenancy tenant) {
        this.updatePrincipal();
        try {
            this.client.putTenant(providerDomain, providerService, tenantDomain, auditRef, tenant);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteTenant(String providerDomain, String providerService, String tenantDomain, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteTenant(providerDomain, providerService, tenantDomain, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putTenantResourceGroupRoles(String providerDomain, String providerServiceName, String tenantDomain, String resourceGroup, String auditRef, TenantResourceGroupRoles tenantRoles) {
        this.updatePrincipal();
        try {
            this.client.putTenantResourceGroupRoles(providerDomain, providerServiceName, tenantDomain, resourceGroup, auditRef, tenantRoles);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public TenantResourceGroupRoles getTenantResourceGroupRoles(String providerDomain, String providerServiceName, String tenantDomain, String resourceGroup) {
        this.updatePrincipal();
        try {
            return this.client.getTenantResourceGroupRoles(providerDomain, providerServiceName, tenantDomain, resourceGroup);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteTenantResourceGroupRoles(String providerDomain, String providerServiceName, String tenantDomain, String resourceGroup, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteTenantResourceGroupRoles(providerDomain, providerServiceName, tenantDomain, resourceGroup, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Access getAccess(String action, String resource, String trustDomain) {
        return this.getAccess(action, resource, trustDomain, null);
    }

    public Access getAccess(String action, String resource, String trustDomain, String principal) {
        try {
            return this.client.getAccess(action, resource, trustDomain, principal);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Access getAccessExt(String action, String resource, String trustDomain, String principal) {
        try {
            return this.client.getAccessExt(action, resource, trustDomain, principal);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public SignedDomains getSignedDomains(String domainName, String metaOnly, String matchingTag, Map<String, List<String>> responseHeaders) {
        return this.getSignedDomains(domainName, metaOnly, null, true, matchingTag, responseHeaders);
    }

    public SignedDomains getSignedDomains(String domainName, String metaOnly, String metaAttr, String matchingTag, Map<String, List<String>> responseHeaders) {
        return this.getSignedDomains(domainName, metaOnly, metaAttr, true, matchingTag, responseHeaders);
    }

    public SignedDomains getSignedDomains(String domainName, String metaOnly, String metaAttr, boolean masterCopy, String matchingTag, Map<String, List<String>> responseHeaders) {
        return this.getSignedDomains(domainName, metaOnly, metaAttr, masterCopy, false, matchingTag, responseHeaders);
    }

    public SignedDomains getSignedDomains(String domainName, String metaOnly, String metaAttr, boolean masterCopy, boolean conditions, String matchingTag, Map<String, List<String>> responseHeaders) {
        this.updatePrincipal();
        try {
            return this.client.getSignedDomains(domainName, metaOnly, metaAttr, masterCopy, conditions, matchingTag, responseHeaders);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainMetaStoreValidValuesList getDomainMetaStoreValidValuesList(String attributeName, String userName) {
        this.updatePrincipal();
        try {
            return this.client.getDomainMetaStoreValidValuesList(attributeName, userName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public AuthHistoryDependencies getAuthHistoryDependencies(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getAuthHistoryDependencies(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public UserToken getUserToken(String userName) {
        return this.getUserToken(userName, null, null);
    }

    public UserToken getUserToken(String userName, String serviceNames, Boolean header) {
        try {
            return this.client.getUserToken(userName, serviceNames, header);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public UserToken getUserToken(String userName, String serviceNames) {
        return this.getUserToken(userName, serviceNames, null);
    }

    public void putDefaultAdmins(String domainName, String auditRef, DefaultAdmins defaultAdmins) {
        this.updatePrincipal();
        try {
            this.client.putDefaultAdmins(domainName, auditRef, defaultAdmins);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Principal getPrincipal(String serviceToken) {
        return this.getPrincipal(serviceToken, PRINCIPAL_AUTHORITY.getHeader());
    }

    public Principal getPrincipal(String serviceToken, String tokenHeader) {
        ServicePrincipal validatedPrincipal;
        PrincipalToken token;
        if (serviceToken == null) {
            throw new ZMSClientException(401, "Null service token provided");
        }
        if (tokenHeader == null) {
            tokenHeader = PRINCIPAL_AUTHORITY.getHeader();
        }
        try {
            token = new PrincipalToken(serviceToken);
        }
        catch (IllegalArgumentException ex) {
            throw new ZMSClientException(401, "Invalid service token provided: " + ex.getMessage());
        }
        Principal servicePrincipal = SimplePrincipal.create((String)token.getDomain(), (String)token.getName(), (String)serviceToken, (long)0L, (Authority)PRINCIPAL_AUTHORITY);
        this.client.addCredentials(tokenHeader, serviceToken);
        this.principalCheckDone = true;
        try {
            validatedPrincipal = this.client.getServicePrincipal();
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
        if (validatedPrincipal == null) {
            throw new ZMSClientException(401, "Invalid service token provided");
        }
        if (!servicePrincipal.getDomain().equalsIgnoreCase(validatedPrincipal.getDomain())) {
            throw new ZMSClientException(401, "Validated principal domain name mismatch");
        }
        if (!servicePrincipal.getName().equalsIgnoreCase(validatedPrincipal.getService())) {
            throw new ZMSClientException(401, "Validated principal service name mismatch");
        }
        return servicePrincipal;
    }

    public void putProviderResourceGroupRoles(String tenantDomain, String providerDomain, String providerServiceName, String resourceGroup, String auditRef, ProviderResourceGroupRoles providerRoles) {
        this.updatePrincipal();
        try {
            this.client.putProviderResourceGroupRoles(tenantDomain, providerDomain, providerServiceName, resourceGroup, auditRef, providerRoles);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteProviderResourceGroupRoles(String tenantDomain, String providerDomain, String providerServiceName, String resourceGroup, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteProviderResourceGroupRoles(tenantDomain, providerDomain, providerServiceName, resourceGroup, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ProviderResourceGroupRoles getProviderResourceGroupRoles(String tenantDomain, String providerDomain, String providerServiceName, String resourceGroup) {
        this.updatePrincipal();
        try {
            return this.client.getProviderResourceGroupRoles(tenantDomain, providerDomain, providerServiceName, resourceGroup);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainDataCheck getDomainDataCheck(String domain) {
        this.updatePrincipal();
        try {
            return this.client.getDomainDataCheck(domain);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Template getTemplate(String template) {
        this.updatePrincipal();
        try {
            return this.client.getTemplate(template);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ServerTemplateList getServerTemplateList() {
        this.updatePrincipal();
        try {
            return this.client.getServerTemplateList();
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putDomainTemplate(String domain, String auditRef, DomainTemplate templates) {
        this.updatePrincipal();
        try {
            this.client.putDomainTemplate(domain, auditRef, templates);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putDomainTemplateExt(String domain, String template, String auditRef, DomainTemplate templates) {
        this.updatePrincipal();
        try {
            this.client.putDomainTemplateExt(domain, template, auditRef, templates);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteDomainTemplate(String domain, String template, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteDomainTemplate(domain, template, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainTemplateList getDomainTemplateList(String domain) {
        this.updatePrincipal();
        try {
            return this.client.getDomainTemplateList(domain);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ResourceAccessList getResourceAccessList(String principal, String action) {
        this.updatePrincipal();
        try {
            return this.client.getResourceAccessList(principal, action);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Quota getQuota(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getQuota(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Stats getStats(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getStats(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Info getInfo() {
        this.updatePrincipal();
        try {
            return this.client.getInfo();
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putQuota(String domainName, String auditRef, Quota quota) {
        this.updatePrincipal();
        try {
            this.client.putQuota(domainName, auditRef, quota);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteQuota(String domainName, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteQuota(domainName, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteDomainRoleMember(String domainName, String memberName, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deleteDomainRoleMember(domainName, memberName, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainRoleMembers getDomainRoleMembers(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getDomainRoleMembers(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainRoleMember getPrincipalRoles(String principal, String domainName) {
        return this.getPrincipalRoles(principal, domainName, null);
    }

    public DomainRoleMember getPrincipalRoles(String principal, String domainName, Boolean expand) {
        this.updatePrincipal();
        try {
            return this.client.getPrincipalRoles(principal, domainName, expand);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putRoleSystemMeta(String domainName, String roleName, String attribute, String auditRef, RoleSystemMeta meta) {
        this.updatePrincipal();
        try {
            this.client.putRoleSystemMeta(domainName, roleName, attribute, auditRef, meta);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putRoleMeta(String domainName, String roleName, String auditRef, String resourceOwner, RoleMeta meta) {
        this.updatePrincipal();
        try {
            this.client.putRoleMeta(domainName, roleName, auditRef, resourceOwner, meta);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putRoleMeta(String domainName, String roleName, String auditRef, RoleMeta meta) {
        this.putRoleMeta(domainName, roleName, auditRef, null, meta);
    }

    public void putMembershipDecision(String domainName, String roleName, String memberName, Timestamp expiration, boolean approval, String auditRef) {
        Membership mbr = new Membership().setRoleName(roleName).setMemberName(memberName).setExpiration(expiration).setApproved(Boolean.valueOf(approval));
        this.updatePrincipal();
        try {
            this.client.putMembershipDecision(domainName, roleName, memberName, auditRef, mbr);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainRoleMembership getPendingDomainRoleMembersList(String principal) {
        this.updatePrincipal();
        try {
            return this.client.getPendingDomainRoleMembersList(principal, null);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainRoleMembership getPendingDomainRoleMembersList(String principal, String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getPendingDomainRoleMembersList(principal, domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Role putRoleReview(String domainName, String roleName, String auditRef, Boolean returnObj, String resourceOwner, Role role) {
        this.updatePrincipal();
        try {
            return this.client.putRoleReview(domainName, roleName, auditRef, returnObj, resourceOwner, role);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Role putRoleReview(String domainName, String roleName, String auditRef, Boolean returnObj, Role role) {
        return this.putRoleReview(domainName, roleName, auditRef, returnObj, null, role);
    }

    public void putRoleReview(String domainName, String roleName, String auditRef, Role role) {
        this.putRoleReview(domainName, roleName, auditRef, false, role);
    }

    public void deleteGroup(String domainName, String groupName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteGroup(domainName, groupName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteGroup(String domainName, String groupName, String auditRef) {
        this.deleteGroup(domainName, groupName, auditRef, null);
    }

    public void deleteGroupMembership(String domainName, String groupName, String memberName, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteGroupMembership(domainName, groupName, memberName, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        this.deleteGroupMembership(domainName, groupName, memberName, auditRef, null);
    }

    public void deletePendingGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        this.updatePrincipal();
        try {
            this.client.deletePendingGroupMembership(domainName, groupName, memberName, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public String generateGroupName(String domain, String group) {
        return domain + ":group." + group;
    }

    public GroupMembership getGroupMembership(String domainName, String groupName, String memberName, String expiration) {
        this.updatePrincipal();
        try {
            return this.client.getGroupMembership(domainName, groupName, memberName, expiration);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainGroupMembers getDomainGroupMembers(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getDomainGroupMembers(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainGroupMember getPrincipalGroups(String principal, String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getPrincipalGroups(principal, domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putGroupSystemMeta(String domainName, String groupName, String attribute, String auditRef, GroupSystemMeta meta) {
        this.updatePrincipal();
        try {
            this.client.putGroupSystemMeta(domainName, groupName, attribute, auditRef, meta);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putGroupMeta(String domainName, String groupName, String auditRef, String resourceOwner, GroupMeta meta) {
        this.updatePrincipal();
        try {
            this.client.putGroupMeta(domainName, groupName, auditRef, resourceOwner, meta);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void putGroupMeta(String domainName, String groupName, String auditRef, GroupMeta meta) {
        this.putGroupMeta(domainName, groupName, auditRef, null, meta);
    }

    public void putGroupMembershipDecision(String domainName, String groupName, String memberName, boolean approval, String auditRef) {
        GroupMembership mbr = new GroupMembership().setGroupName(groupName).setMemberName(memberName).setApproved(Boolean.valueOf(approval));
        this.updatePrincipal();
        try {
            this.client.putGroupMembershipDecision(domainName, groupName, memberName, auditRef, mbr);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainGroupMembership getPendingDomainGroupMembersList(String principal) {
        this.updatePrincipal();
        try {
            return this.client.getPendingDomainGroupMembersList(principal, null);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainGroupMembership getPendingDomainGroupMembersList(String principal, String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getPendingDomainGroupMembersList(principal, domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Group putGroupReview(String domainName, String groupName, String auditRef, Boolean returnObj, String resourceOwner, Group group) {
        this.updatePrincipal();
        try {
            return this.client.putGroupReview(domainName, groupName, auditRef, returnObj, resourceOwner, group);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Group putGroupReview(String domainName, String groupName, String auditRef, Boolean returnObj, Group group) {
        return this.putGroupReview(domainName, groupName, auditRef, returnObj, null, group);
    }

    public void putGroupReview(String domainName, String groupName, String auditRef, Group group) {
        this.putGroupReview(domainName, groupName, auditRef, false, group);
    }

    public Group getGroup(String domainName, String groupName, boolean auditLog, boolean pending) {
        this.updatePrincipal();
        try {
            return this.client.getGroup(domainName, groupName, auditLog, pending);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Group putGroup(String domainName, String groupName, String auditRef, Boolean returnObj, String resourceOwner, Group group) {
        this.updatePrincipal();
        try {
            return this.client.putGroup(domainName, groupName, auditRef, returnObj, resourceOwner, group);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Group putGroup(String domainName, String groupName, String auditRef, Boolean returnObj, Group group) {
        return this.putGroup(domainName, groupName, auditRef, returnObj, null, group);
    }

    public void putGroup(String domainName, String groupName, String auditRef, Group group) {
        this.putGroup(domainName, groupName, auditRef, false, group);
    }

    public Groups getGroups(String domainName, Boolean members, String tagKey, String tagValue) {
        this.updatePrincipal();
        try {
            return this.client.getGroups(domainName, members, tagKey, tagValue);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public Groups getGroups(String domainName, Boolean members) {
        return this.getGroups(domainName, members, null, null);
    }

    public GroupMembership putGroupMembership(String domainName, String groupName, String memberName, String auditRef, Boolean returnObj, String resourceOwner) {
        GroupMembership mbr = new GroupMembership().setGroupName(groupName).setMemberName(memberName).setIsMember(Boolean.valueOf(true));
        this.updatePrincipal();
        try {
            return this.client.putGroupMembership(domainName, groupName, memberName, auditRef, returnObj, resourceOwner, mbr);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public GroupMembership putGroupMembership(String domainName, String groupName, String memberName, String auditRef, Boolean returnObj) {
        return this.putGroupMembership(domainName, groupName, memberName, auditRef, returnObj, null);
    }

    public void putGroupMembership(String domainName, String groupName, String memberName, String auditRef) {
        this.putGroupMembership(domainName, groupName, memberName, auditRef, false);
    }

    public AssertionConditions putAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner, AssertionConditions assertionConditions) {
        this.updatePrincipal();
        try {
            return this.client.putAssertionConditions(domainName, policyName, assertionId, auditRef, resourceOwner, assertionConditions);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public AssertionConditions putAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, AssertionConditions assertionConditions) {
        return this.putAssertionConditions(domainName, policyName, assertionId, auditRef, null, assertionConditions);
    }

    public AssertionCondition putAssertionCondition(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner, AssertionCondition assertionCondition) {
        this.updatePrincipal();
        try {
            return this.client.putAssertionCondition(domainName, policyName, assertionId, auditRef, resourceOwner, assertionCondition);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public AssertionCondition putAssertionCondition(String domainName, String policyName, Long assertionId, String auditRef, AssertionCondition assertionCondition) {
        return this.putAssertionCondition(domainName, policyName, assertionId, auditRef, null, assertionCondition);
    }

    public void deleteAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteAssertionConditions(domainName, policyName, assertionId, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef) {
        this.deleteAssertionConditions(domainName, policyName, assertionId, auditRef, null);
    }

    public void deleteAssertionCondition(String domainName, String policyName, Long assertionId, int conditionId, String auditRef, String resourceOwner) {
        this.updatePrincipal();
        try {
            this.client.deleteAssertionCondition(domainName, policyName, assertionId, conditionId, auditRef, resourceOwner);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public void deleteAssertionCondition(String domainName, String policyName, Long assertionId, int conditionId, String auditRef) {
        this.deleteAssertionCondition(domainName, policyName, assertionId, conditionId, auditRef, null);
    }

    public DependentService putDomainDependency(String domainName, String auditRef, DependentService dependentService) {
        this.updatePrincipal();
        try {
            return this.client.putDomainDependency(domainName, auditRef, dependentService);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public String deleteDomainDependency(String domainName, String service, String auditRef) {
        this.updatePrincipal();
        try {
            return this.client.deleteDomainDependency(domainName, service, auditRef);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ServiceIdentityList getDependentServiceList(String domainName) {
        this.updatePrincipal();
        try {
            return this.client.getDependentServiceList(domainName);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public DomainList getDependentDomainList(String service) {
        this.updatePrincipal();
        try {
            return this.client.getDependentDomainList(service);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ExpiredMembers deleteExpiredMembers(Integer purgeResources, String auditRef, Boolean returnObj) {
        this.updatePrincipal();
        try {
            return this.client.deleteExpiredMembers(purgeResources, auditRef, returnObj);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ResourceRoleOwnership putResourceRoleOwnership(String domainName, String roleName, String auditRef, ResourceRoleOwnership resourceOwnership) {
        this.updatePrincipal();
        try {
            return this.client.putResourceRoleOwnership(domainName, roleName, auditRef, resourceOwnership);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ResourceDomainOwnership putResourceDomainOwnership(String domainName, String auditRef, ResourceDomainOwnership resourceOwnership) {
        this.updatePrincipal();
        try {
            return this.client.putResourceDomainOwnership(domainName, auditRef, resourceOwnership);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ResourcePolicyOwnership putResourcePolicyOwnership(String domainName, String policyName, String auditRef, ResourcePolicyOwnership resourceOwnership) {
        this.updatePrincipal();
        try {
            return this.client.putResourcePolicyOwnership(domainName, policyName, auditRef, resourceOwnership);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public ResourceServiceIdentityOwnership putResourceServiceIdentityOwnership(String domainName, String serviceName, String auditRef, ResourceServiceIdentityOwnership resourceOwnership) {
        this.updatePrincipal();
        try {
            return this.client.putResourceServiceIdentityOwnership(domainName, serviceName, auditRef, resourceOwnership);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    public PrincipalState putPrincipalState(String principalName, String auditRef, PrincipalState principalState) {
        this.updatePrincipal();
        try {
            return this.client.putPrincipalState(principalName, auditRef, principalState);
        }
        catch (ClientResourceException ex) {
            throw new ZMSClientException(ex.getCode(), ex.getData());
        }
        catch (Exception ex) {
            throw new ZMSClientException(400, ex.getMessage());
        }
    }

    static class CustomRequestRetryStrategy
    extends DefaultHttpRequestRetryStrategy {
        public CustomRequestRetryStrategy(int maxRetries, TimeValue defaultRetryInterval) {
            super(maxRetries, defaultRetryInterval, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, NoRouteToHostException.class), Arrays.asList(429, 503));
        }
    }
}

