/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zms;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.athenz.zms.Access;
import com.yahoo.athenz.zms.Assertion;
import com.yahoo.athenz.zms.AssertionCondition;
import com.yahoo.athenz.zms.AssertionConditions;
import com.yahoo.athenz.zms.AuthHistoryDependencies;
import com.yahoo.athenz.zms.ClientResourceError;
import com.yahoo.athenz.zms.ClientResourceException;
import com.yahoo.athenz.zms.DefaultAdmins;
import com.yahoo.athenz.zms.DependentService;
import com.yahoo.athenz.zms.DependentServiceResourceGroupList;
import com.yahoo.athenz.zms.Domain;
import com.yahoo.athenz.zms.DomainDataCheck;
import com.yahoo.athenz.zms.DomainGroupMember;
import com.yahoo.athenz.zms.DomainGroupMembers;
import com.yahoo.athenz.zms.DomainGroupMembership;
import com.yahoo.athenz.zms.DomainList;
import com.yahoo.athenz.zms.DomainMeta;
import com.yahoo.athenz.zms.DomainMetaStoreValidValuesList;
import com.yahoo.athenz.zms.DomainRoleMember;
import com.yahoo.athenz.zms.DomainRoleMembers;
import com.yahoo.athenz.zms.DomainRoleMembership;
import com.yahoo.athenz.zms.DomainTemplate;
import com.yahoo.athenz.zms.DomainTemplateDetailsList;
import com.yahoo.athenz.zms.DomainTemplateList;
import com.yahoo.athenz.zms.Entity;
import com.yahoo.athenz.zms.EntityList;
import com.yahoo.athenz.zms.ExpiredMembers;
import com.yahoo.athenz.zms.Group;
import com.yahoo.athenz.zms.GroupMembership;
import com.yahoo.athenz.zms.GroupMeta;
import com.yahoo.athenz.zms.GroupSystemMeta;
import com.yahoo.athenz.zms.Groups;
import com.yahoo.athenz.zms.Info;
import com.yahoo.athenz.zms.JWSDomain;
import com.yahoo.athenz.zms.Membership;
import com.yahoo.athenz.zms.Policies;
import com.yahoo.athenz.zms.Policy;
import com.yahoo.athenz.zms.PolicyList;
import com.yahoo.athenz.zms.PolicyOptions;
import com.yahoo.athenz.zms.PrincipalState;
import com.yahoo.athenz.zms.ProviderResourceGroupRoles;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zms.Quota;
import com.yahoo.athenz.zms.ResourceAccessList;
import com.yahoo.athenz.zms.ResourceDomainOwnership;
import com.yahoo.athenz.zms.ResourceGroupOwnership;
import com.yahoo.athenz.zms.ResourcePolicyOwnership;
import com.yahoo.athenz.zms.ResourceRoleOwnership;
import com.yahoo.athenz.zms.ResourceServiceIdentityOwnership;
import com.yahoo.athenz.zms.ReviewObjects;
import com.yahoo.athenz.zms.Role;
import com.yahoo.athenz.zms.RoleList;
import com.yahoo.athenz.zms.RoleMeta;
import com.yahoo.athenz.zms.RoleSystemMeta;
import com.yahoo.athenz.zms.Roles;
import com.yahoo.athenz.zms.ServerTemplateList;
import com.yahoo.athenz.zms.ServiceIdentities;
import com.yahoo.athenz.zms.ServiceIdentity;
import com.yahoo.athenz.zms.ServiceIdentityList;
import com.yahoo.athenz.zms.ServiceIdentitySystemMeta;
import com.yahoo.athenz.zms.ServicePrincipal;
import com.yahoo.athenz.zms.SignedDomains;
import com.yahoo.athenz.zms.Stats;
import com.yahoo.athenz.zms.Status;
import com.yahoo.athenz.zms.SubDomain;
import com.yahoo.athenz.zms.Template;
import com.yahoo.athenz.zms.Tenancy;
import com.yahoo.athenz.zms.TenantResourceGroupRoles;
import com.yahoo.athenz.zms.TopLevelDomain;
import com.yahoo.athenz.zms.User;
import com.yahoo.athenz.zms.UserAuthorityAttributeMap;
import com.yahoo.athenz.zms.UserDomain;
import com.yahoo.athenz.zms.UserList;
import com.yahoo.athenz.zms.UserToken;
import com.yahoo.rdl.Schema;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;

public class ZMSRDLGeneratedClient {
    private static final int DEFAULT_CLIENT_CONNECT_TIMEOUT_MS = 5000;
    private static final int DEFAULT_CLIENT_READ_TIMEOUT_MS = 30000;
    private String baseUrl;
    private String credsHeader;
    private String credsToken;
    private CloseableHttpClient client;
    private HttpContext httpContext;
    private ObjectMapper jsonMapper;

    protected CloseableHttpClient createHttpClient(HostnameVerifier hostnameVerifier) {
        DefaultClientTlsStrategy tlsStrategy = hostnameVerifier == null ? new DefaultClientTlsStrategy(SSLContexts.createSystemDefault()) : new DefaultClientTlsStrategy(SSLContexts.createSystemDefault(), hostnameVerifier);
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy).setDefaultTlsConfig(TlsConfig.custom().setSupportedProtocols(new TLS[]{TLS.V_1_2, TLS.V_1_3}).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.FIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(Timeout.ofMinutes((long)30000L)).setConnectTimeout(Timeout.ofMinutes((long)5000L)).build()).build();
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(false).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(config).build();
    }

    public ZMSRDLGeneratedClient(String url) {
        this.initClient(url, this.createHttpClient(null));
    }

    public ZMSRDLGeneratedClient(String url, HostnameVerifier hostnameVerifier) {
        this.initClient(url, this.createHttpClient(hostnameVerifier));
    }

    public ZMSRDLGeneratedClient(String url, CloseableHttpClient httpClient) {
        this.initClient(url, httpClient);
    }

    private void initClient(String url, CloseableHttpClient httpClient) {
        this.baseUrl = url;
        this.client = httpClient;
        this.jsonMapper = new ObjectMapper();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addCredentials(String header, String token) {
        this.credsHeader = header;
        this.credsToken = token;
        if (header == null) {
            this.httpContext = null;
        } else if (header.startsWith("Cookie.")) {
            this.httpContext = new BasicHttpContext();
            BasicCookieStore cookieStore = new BasicCookieStore();
            BasicClientCookie cookie = new BasicClientCookie(header.substring(7), token);
            cookie.setPath(this.baseUrl);
            cookieStore.addCookie((Cookie)cookie);
            this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
            this.credsHeader = null;
        }
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.client = httpClient;
    }

    protected String getStringResponseEntity(HttpEntity httpResponseEntity) throws IOException {
        try {
            return EntityUtils.toString((HttpEntity)httpResponseEntity);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain getDomain(String domain) throws URISyntaxException, IOException {
        String errorData;
        Domain domain2;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}").resolveTemplate("domain", domain);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domain2 = (Domain)this.jsonMapper.readValue(httpResponseEntity.getContent(), Domain.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainList getDomainList(Integer limit, String skip, String prefix, Integer depth, String account, Integer productNumber, String roleMember, String roleName, String subscription, String project, String tagKey, String tagValue, String businessService, String productId, String modifiedSince) throws URISyntaxException, IOException {
        String errorData;
        DomainList domainList;
        int code;
        HttpEntity httpResponseEntity;
        block28: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (limit != null) {
                uriBuilder.setParameter("limit", String.valueOf(limit));
            }
            if (skip != null) {
                uriBuilder.setParameter("skip", skip);
            }
            if (prefix != null) {
                uriBuilder.setParameter("prefix", prefix);
            }
            if (depth != null) {
                uriBuilder.setParameter("depth", String.valueOf(depth));
            }
            if (account != null) {
                uriBuilder.setParameter("account", account);
            }
            if (productNumber != null) {
                uriBuilder.setParameter("ypmid", String.valueOf(productNumber));
            }
            if (roleMember != null) {
                uriBuilder.setParameter("member", roleMember);
            }
            if (roleName != null) {
                uriBuilder.setParameter("role", roleName);
            }
            if (subscription != null) {
                uriBuilder.setParameter("azure", subscription);
            }
            if (project != null) {
                uriBuilder.setParameter("gcp", project);
            }
            if (tagKey != null) {
                uriBuilder.setParameter("tagKey", tagKey);
            }
            if (tagValue != null) {
                uriBuilder.setParameter("tagValue", tagValue);
            }
            if (businessService != null) {
                uriBuilder.setParameter("businessService", businessService);
            }
            if (productId != null) {
                uriBuilder.setParameter("productId", productId);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (modifiedSince != null) {
                httpUriRequest.addHeader("If-Modified-Since", (Object)modifiedSince);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainList = (DomainList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainList.class);
                        if (httpResponse == null) break block28;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain postTopLevelDomain(String auditRef, String resourceOwner, TopLevelDomain detail) throws URISyntaxException, IOException {
        String errorData;
        Domain domain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.post().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domain = (Domain)this.jsonMapper.readValue(httpResponseEntity.getContent(), Domain.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain postSubDomain(String parent, String auditRef, String resourceOwner, SubDomain detail) throws URISyntaxException, IOException {
        String errorData;
        Domain domain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/subdomain/{parent}").resolveTemplate("parent", parent);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.post().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domain = (Domain)this.jsonMapper.readValue(httpResponseEntity.getContent(), Domain.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain postUserDomain(String name, String auditRef, String resourceOwner, UserDomain detail) throws URISyntaxException, IOException {
        String errorData;
        Domain domain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/userdomain/{name}").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.post().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domain = (Domain)this.jsonMapper.readValue(httpResponseEntity.getContent(), Domain.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopLevelDomain deleteTopLevelDomain(String name, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        TopLevelDomain topLevelDomain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        topLevelDomain = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return topLevelDomain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SubDomain deleteSubDomain(String parent, String name, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        SubDomain subDomain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/subdomain/{parent}/{name}").resolveTemplate("parent", parent).resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        subDomain = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return subDomain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserDomain deleteUserDomain(String name, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        UserDomain userDomain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/userdomain/{name}").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        userDomain = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return userDomain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain putDomainMeta(String name, String auditRef, String resourceOwner, DomainMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Domain domain;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/meta").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domain = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Domain putDomainSystemMeta(String name, String attribute, String auditRef, DomainMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Domain domain;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/meta/system/{attribute}").resolveTemplate("name", name).resolveTemplate("attribute", attribute);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domain = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domain;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplate putDomainTemplate(String name, String auditRef, DomainTemplate domainTemplate) throws URISyntaxException, IOException {
        String errorData;
        DomainTemplate domainTemplate2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/template").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)domainTemplate), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domainTemplate2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplate2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplate putDomainTemplateExt(String name, String template, String auditRef, DomainTemplate domainTemplate) throws URISyntaxException, IOException {
        String errorData;
        DomainTemplate domainTemplate2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/template/{template}").resolveTemplate("name", name).resolveTemplate("template", template);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)domainTemplate), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domainTemplate2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplate2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplateList getDomainTemplateList(String name) throws URISyntaxException, IOException {
        String errorData;
        DomainTemplateList domainTemplateList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/template").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainTemplateList = (DomainTemplateList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainTemplateList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplateList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplate deleteDomainTemplate(String name, String template, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        DomainTemplate domainTemplate;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/template/{template}").resolveTemplate("name", name).resolveTemplate("template", template);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domainTemplate = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplate;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainMetaStoreValidValuesList getDomainMetaStoreValidValuesList(String attributeName, String userName) throws URISyntaxException, IOException {
        String errorData;
        DomainMetaStoreValidValuesList domainMetaStoreValidValuesList;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/metastore");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (attributeName != null) {
                uriBuilder.setParameter("attribute", attributeName);
            }
            if (userName != null) {
                uriBuilder.setParameter("user", userName);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainMetaStoreValidValuesList = (DomainMetaStoreValidValuesList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainMetaStoreValidValuesList.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainMetaStoreValidValuesList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AuthHistoryDependencies getAuthHistoryDependencies(String domainName) throws URISyntaxException, IOException {
        String errorData;
        AuthHistoryDependencies authHistoryDependencies;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/history/auth").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        authHistoryDependencies = (AuthHistoryDependencies)this.jsonMapper.readValue(httpResponseEntity.getContent(), AuthHistoryDependencies.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return authHistoryDependencies;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExpiredMembers deleteExpiredMembers(Integer purgeResources, String auditRef, Boolean returnObj) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/expired-members");
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                if (purgeResources != null) {
                    uriBuilder.setParameter("purgeResources", String.valueOf(purgeResources));
                }
                httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var10_11 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var11_15) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var11_15;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var10_11;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 205->226)] { 
lbl40:
        // 1 sources

        return (ExpiredMembers)this.jsonMapper.readValue(httpResponseEntity.getContent(), ExpiredMembers.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var10_12;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceDomainOwnership putResourceDomainOwnership(String domainName, String auditRef, ResourceDomainOwnership resourceOwnership) throws URISyntaxException, IOException {
        String errorData;
        ResourceDomainOwnership resourceDomainOwnership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/ownership").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)resourceOwnership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        resourceDomainOwnership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourceDomainOwnership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainDataCheck getDomainDataCheck(String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainDataCheck domainDataCheck;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/check").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainDataCheck = (DomainDataCheck)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainDataCheck.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainDataCheck;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity putEntity(String domainName, String entityName, String auditRef, Entity entity) throws URISyntaxException, IOException {
        String errorData;
        Entity entity2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", domainName).resolveTemplate("entityName", entityName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)entity), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        entity2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return entity2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity getEntity(String domainName, String entityName) throws URISyntaxException, IOException {
        String errorData;
        Entity entity;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", domainName).resolveTemplate("entityName", entityName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        entity = (Entity)this.jsonMapper.readValue(httpResponseEntity.getContent(), Entity.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return entity;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity deleteEntity(String domainName, String entityName, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        Entity entity;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/entity/{entityName}").resolveTemplate("domainName", domainName).resolveTemplate("entityName", entityName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        entity = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return entity;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EntityList getEntityList(String domainName) throws URISyntaxException, IOException {
        String errorData;
        EntityList entityList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/entity").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        entityList = (EntityList)this.jsonMapper.readValue(httpResponseEntity.getContent(), EntityList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return entityList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RoleList getRoleList(String domainName, Integer limit, String skip) throws URISyntaxException, IOException {
        String errorData;
        RoleList roleList;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (limit != null) {
                uriBuilder.setParameter("limit", String.valueOf(limit));
            }
            if (skip != null) {
                uriBuilder.setParameter("skip", skip);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        roleList = (RoleList)this.jsonMapper.readValue(httpResponseEntity.getContent(), RoleList.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return roleList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Roles getRoles(String domainName, Boolean members, String tagKey, String tagValue) throws URISyntaxException, IOException {
        String errorData;
        Roles roles;
        int code;
        HttpEntity httpResponseEntity;
        block16: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/roles").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (members != null) {
                uriBuilder.setParameter("members", String.valueOf(members));
            }
            if (tagKey != null) {
                uriBuilder.setParameter("tagKey", tagKey);
            }
            if (tagValue != null) {
                uriBuilder.setParameter("tagValue", tagValue);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        roles = (Roles)this.jsonMapper.readValue(httpResponseEntity.getContent(), Roles.class);
                        if (httpResponse == null) break block16;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return roles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role getRole(String domainName, String roleName, Boolean auditLog, Boolean expand, Boolean pending) throws URISyntaxException, IOException {
        String errorData;
        Role role;
        int code;
        HttpEntity httpResponseEntity;
        block16: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (auditLog != null) {
                uriBuilder.setParameter("auditLog", String.valueOf(auditLog));
            }
            if (expand != null) {
                uriBuilder.setParameter("expand", String.valueOf(expand));
            }
            if (pending != null) {
                uriBuilder.setParameter("pending", String.valueOf(pending));
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        role = (Role)this.jsonMapper.readValue(httpResponseEntity.getContent(), Role.class);
                        if (httpResponse == null) break block16;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return role;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role putRole(String domainName, String roleName, String auditRef, Boolean returnObj, String resourceOwner, Role role) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)role), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Role)this.jsonMapper.readValue(httpResponseEntity.getContent(), Role.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role deleteRole(String domainName, String roleName, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Role role;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        role = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return role;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Membership getMembership(String domainName, String roleName, String memberName, String expiration) throws URISyntaxException, IOException {
        String errorData;
        Membership membership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (expiration != null) {
                uriBuilder.setParameter("expiration", expiration);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        membership = (Membership)this.jsonMapper.readValue(httpResponseEntity.getContent(), Membership.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return membership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRoleMembers getOverdueReview(String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainRoleMembers domainRoleMembers;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/overdue").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainRoleMembers = (DomainRoleMembers)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainRoleMembers.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainRoleMembers;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRoleMembers getDomainRoleMembers(String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainRoleMembers domainRoleMembers;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/member").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainRoleMembers = (DomainRoleMembers)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainRoleMembers.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainRoleMembers;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRoleMember getPrincipalRoles(String principal, String domainName, Boolean expand) throws URISyntaxException, IOException {
        String errorData;
        DomainRoleMember domainRoleMember;
        int code;
        HttpEntity httpResponseEntity;
        block16: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/role");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            if (domainName != null) {
                uriBuilder.setParameter("domain", domainName);
            }
            if (expand != null) {
                uriBuilder.setParameter("expand", String.valueOf(expand));
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainRoleMember = (DomainRoleMember)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainRoleMember.class);
                        if (httpResponse == null) break block16;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainRoleMember;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Membership putMembership(String domainName, String roleName, String memberName, String auditRef, Boolean returnObj, String resourceOwner, Membership membership) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("memberName", memberName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)membership), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var15_16 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var16_20) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var16_20;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var15_16;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 253->274)] { 
lbl40:
        // 1 sources

        return (Membership)this.jsonMapper.readValue(httpResponseEntity.getContent(), Membership.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var15_17;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Membership deleteMembership(String domainName, String roleName, String memberName, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Membership membership;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        membership = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return membership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Membership deletePendingMembership(String domainName, String roleName, String memberName, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        Membership membership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/pendingmember/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        membership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return membership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DefaultAdmins putDefaultAdmins(String domainName, String auditRef, DefaultAdmins defaultAdmins) throws URISyntaxException, IOException {
        String errorData;
        DefaultAdmins defaultAdmins2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/admins").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)defaultAdmins), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        defaultAdmins2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return defaultAdmins2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role putRoleSystemMeta(String domainName, String roleName, String attribute, String auditRef, RoleSystemMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Role role;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/meta/system/{attribute}").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("attribute", attribute);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        role = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return role;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role putRoleMeta(String domainName, String roleName, String auditRef, String resourceOwner, RoleMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Role role;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/meta").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        role = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return role;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Membership putMembershipDecision(String domainName, String roleName, String memberName, String auditRef, Membership membership) throws URISyntaxException, IOException {
        String errorData;
        Membership membership2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/member/{memberName}/decision").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)membership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        membership2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return membership2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Role putRoleReview(String domainName, String roleName, String auditRef, Boolean returnObj, String resourceOwner, Role role) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/review").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)role), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Role)this.jsonMapper.readValue(httpResponseEntity.getContent(), Role.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceRoleOwnership putResourceRoleOwnership(String domainName, String roleName, String auditRef, ResourceRoleOwnership resourceOwnership) throws URISyntaxException, IOException {
        String errorData;
        ResourceRoleOwnership resourceRoleOwnership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/role/{roleName}/ownership").resolveTemplate("domainName", domainName).resolveTemplate("roleName", roleName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)resourceOwnership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        resourceRoleOwnership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourceRoleOwnership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Groups getGroups(String domainName, Boolean members, String tagKey, String tagValue) throws URISyntaxException, IOException {
        String errorData;
        Groups groups;
        int code;
        HttpEntity httpResponseEntity;
        block16: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/groups").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (members != null) {
                uriBuilder.setParameter("members", String.valueOf(members));
            }
            if (tagKey != null) {
                uriBuilder.setParameter("tagKey", tagKey);
            }
            if (tagValue != null) {
                uriBuilder.setParameter("tagValue", tagValue);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        groups = (Groups)this.jsonMapper.readValue(httpResponseEntity.getContent(), Groups.class);
                        if (httpResponse == null) break block16;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return groups;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group getGroup(String domainName, String groupName, Boolean auditLog, Boolean pending) throws URISyntaxException, IOException {
        String errorData;
        Group group;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (auditLog != null) {
                uriBuilder.setParameter("auditLog", String.valueOf(auditLog));
            }
            if (pending != null) {
                uriBuilder.setParameter("pending", String.valueOf(pending));
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        group = (Group)this.jsonMapper.readValue(httpResponseEntity.getContent(), Group.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return group;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group putGroup(String domainName, String groupName, String auditRef, Boolean returnObj, String resourceOwner, Group group) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)group), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Group)this.jsonMapper.readValue(httpResponseEntity.getContent(), Group.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group deleteGroup(String domainName, String groupName, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Group group;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        group = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return group;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupMembership getGroupMembership(String domainName, String groupName, String memberName, String expiration) throws URISyntaxException, IOException {
        String errorData;
        GroupMembership groupMembership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (expiration != null) {
                uriBuilder.setParameter("expiration", expiration);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        groupMembership = (GroupMembership)this.jsonMapper.readValue(httpResponseEntity.getContent(), GroupMembership.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return groupMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainGroupMember getPrincipalGroups(String principal, String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainGroupMember domainGroupMember;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/group");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            if (domainName != null) {
                uriBuilder.setParameter("domain", domainName);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainGroupMember = (DomainGroupMember)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainGroupMember.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainGroupMember;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupMembership putGroupMembership(String domainName, String groupName, String memberName, String auditRef, Boolean returnObj, String resourceOwner, GroupMembership membership) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("memberName", memberName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)membership), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var15_16 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var16_20) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var16_20;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var15_16;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 253->274)] { 
lbl40:
        // 1 sources

        return (GroupMembership)this.jsonMapper.readValue(httpResponseEntity.getContent(), GroupMembership.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var15_17;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupMembership deleteGroupMembership(String domainName, String groupName, String memberName, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        GroupMembership groupMembership;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        groupMembership = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return groupMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupMembership deletePendingGroupMembership(String domainName, String groupName, String memberName, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        GroupMembership groupMembership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/pendingmember/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        groupMembership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return groupMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group putGroupSystemMeta(String domainName, String groupName, String attribute, String auditRef, GroupSystemMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Group group;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/meta/system/{attribute}").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("attribute", attribute);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        group = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return group;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group putGroupMeta(String domainName, String groupName, String auditRef, String resourceOwner, GroupMeta detail) throws URISyntaxException, IOException {
        String errorData;
        Group group;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/meta").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        group = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return group;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GroupMembership putGroupMembershipDecision(String domainName, String groupName, String memberName, String auditRef, GroupMembership membership) throws URISyntaxException, IOException {
        String errorData;
        GroupMembership groupMembership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/member/{memberName}/decision").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)membership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        groupMembership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return groupMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Group putGroupReview(String domainName, String groupName, String auditRef, Boolean returnObj, String resourceOwner, Group group) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/review").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)group), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Group)this.jsonMapper.readValue(httpResponseEntity.getContent(), Group.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainGroupMembership getPendingDomainGroupMembersList(String principal, String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainGroupMembership domainGroupMembership;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/pending_group_members");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            if (domainName != null) {
                uriBuilder.setParameter("domain", domainName);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainGroupMembership = (DomainGroupMembership)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainGroupMembership.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainGroupMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceGroupOwnership putResourceGroupOwnership(String domainName, String groupName, String auditRef, ResourceGroupOwnership resourceOwnership) throws URISyntaxException, IOException {
        String errorData;
        ResourceGroupOwnership resourceGroupOwnership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/{groupName}/ownership").resolveTemplate("domainName", domainName).resolveTemplate("groupName", groupName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)resourceOwnership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        resourceGroupOwnership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourceGroupOwnership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainGroupMembers getDomainGroupMembers(String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainGroupMembers domainGroupMembers;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/group/member").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainGroupMembers = (DomainGroupMembers)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainGroupMembers.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainGroupMembers;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyList getPolicyList(String domainName, Integer limit, String skip) throws URISyntaxException, IOException {
        String errorData;
        PolicyList policyList;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (limit != null) {
                uriBuilder.setParameter("limit", String.valueOf(limit));
            }
            if (skip != null) {
                uriBuilder.setParameter("skip", skip);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        policyList = (PolicyList)this.jsonMapper.readValue(httpResponseEntity.getContent(), PolicyList.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policyList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policies getPolicies(String domainName, Boolean assertions, Boolean includeNonActive, String tagKey, String tagValue) throws URISyntaxException, IOException {
        String errorData;
        Policies policies;
        int code;
        HttpEntity httpResponseEntity;
        block17: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policies").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (assertions != null) {
                uriBuilder.setParameter("assertions", String.valueOf(assertions));
            }
            if (includeNonActive != null) {
                uriBuilder.setParameter("includeNonActive", String.valueOf(includeNonActive));
            }
            if (tagKey != null) {
                uriBuilder.setParameter("tagKey", tagKey);
            }
            if (tagValue != null) {
                uriBuilder.setParameter("tagValue", tagValue);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        policies = (Policies)this.jsonMapper.readValue(httpResponseEntity.getContent(), Policies.class);
                        if (httpResponse == null) break block17;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policies;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy getPolicy(String domainName, String policyName) throws URISyntaxException, IOException {
        String errorData;
        Policy policy;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        policy = (Policy)this.jsonMapper.readValue(httpResponseEntity.getContent(), Policy.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy putPolicy(String domainName, String policyName, String auditRef, Boolean returnObj, String resourceOwner, Policy policy) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)policy), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Policy)this.jsonMapper.readValue(httpResponseEntity.getContent(), Policy.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy deletePolicy(String domainName, String policyName, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Policy policy;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        policy = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Assertion getAssertion(String domainName, String policyName, Long assertionId) throws URISyntaxException, IOException {
        String errorData;
        Assertion assertion;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        assertion = (Assertion)this.jsonMapper.readValue(httpResponseEntity.getContent(), Assertion.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertion;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Assertion putAssertion(String domainName, String policyName, String auditRef, String resourceOwner, Assertion assertion) throws URISyntaxException, IOException {
        String errorData;
        Assertion assertion2;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)assertion), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        assertion2 = (Assertion)this.jsonMapper.readValue(httpResponseEntity.getContent(), Assertion.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertion2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Assertion putAssertionPolicyVersion(String domainName, String policyName, String version, String auditRef, String resourceOwner, Assertion assertion) throws URISyntaxException, IOException {
        String errorData;
        Assertion assertion2;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/{version}/assertion").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("version", version);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)assertion), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        assertion2 = (Assertion)this.jsonMapper.readValue(httpResponseEntity.getContent(), Assertion.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertion2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Assertion deleteAssertion(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Assertion assertion;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        assertion = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertion;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Assertion deleteAssertionPolicyVersion(String domainName, String policyName, String version, Long assertionId, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Assertion assertion;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/{version}/assertion/{assertionId}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("version", version).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        assertion = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertion;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssertionConditions putAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner, AssertionConditions assertionConditions) throws URISyntaxException, IOException {
        String errorData;
        AssertionConditions assertionConditions2;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)assertionConditions), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        assertionConditions2 = (AssertionConditions)this.jsonMapper.readValue(httpResponseEntity.getContent(), AssertionConditions.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertionConditions2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssertionCondition putAssertionCondition(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner, AssertionCondition assertionCondition) throws URISyntaxException, IOException {
        String errorData;
        AssertionCondition assertionCondition2;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)assertionCondition), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        assertionCondition2 = (AssertionCondition)this.jsonMapper.readValue(httpResponseEntity.getContent(), AssertionCondition.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertionCondition2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssertionConditions deleteAssertionConditions(String domainName, String policyName, Long assertionId, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        AssertionConditions assertionConditions;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/conditions").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        assertionConditions = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertionConditions;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssertionCondition deleteAssertionCondition(String domainName, String policyName, Long assertionId, Integer conditionId, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        AssertionCondition assertionCondition;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/assertion/{assertionId}/condition/{conditionId}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("assertionId", assertionId).resolveTemplate("conditionId", conditionId);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        assertionCondition = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return assertionCondition;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyList getPolicyVersionList(String domainName, String policyName) throws URISyntaxException, IOException {
        String errorData;
        PolicyList policyList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        policyList = (PolicyList)this.jsonMapper.readValue(httpResponseEntity.getContent(), PolicyList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policyList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy getPolicyVersion(String domainName, String policyName, String version) throws URISyntaxException, IOException {
        String errorData;
        Policy policy;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/{version}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("version", version);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        policy = (Policy)this.jsonMapper.readValue(httpResponseEntity.getContent(), Policy.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy putPolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef, Boolean returnObj, String resourceOwner) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/create").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)policyOptions), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (Policy)this.jsonMapper.readValue(httpResponseEntity.getContent(), Policy.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy setActivePolicyVersion(String domainName, String policyName, PolicyOptions policyOptions, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Policy policy;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/active").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)policyOptions), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        policy = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Policy deletePolicyVersion(String domainName, String policyName, String version, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        Policy policy;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/version/{version}").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName).resolveTemplate("version", version);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        policy = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return policy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourcePolicyOwnership putResourcePolicyOwnership(String domainName, String policyName, String auditRef, ResourcePolicyOwnership resourceOwnership) throws URISyntaxException, IOException {
        String errorData;
        ResourcePolicyOwnership resourcePolicyOwnership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/policy/{policyName}/ownership").resolveTemplate("domainName", domainName).resolveTemplate("policyName", policyName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)resourceOwnership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        resourcePolicyOwnership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourcePolicyOwnership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentity putServiceIdentity(String domain, String service, String auditRef, Boolean returnObj, String resourceOwner, ServiceIdentity detail) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}").resolveTemplate("domain", domain).resolveTemplate("service", service);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
                httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (auditRef != null) {
                    httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
                }
                if (returnObj != null) {
                    httpUriRequest.addHeader("Athenz-Return-Object", (Object)String.valueOf(returnObj));
                }
                if (resourceOwner != null) {
                    httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 204: {
                            if (code != 204) break block20;
                            var14_15 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 245->266)] { 
lbl40:
        // 1 sources

        return (ServiceIdentity)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServiceIdentity.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl46:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentity getServiceIdentity(String domain, String service) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentity serviceIdentity;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}").resolveTemplate("domain", domain).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        serviceIdentity = (ServiceIdentity)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServiceIdentity.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentity;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentity deleteServiceIdentity(String domain, String service, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentity serviceIdentity;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}").resolveTemplate("domain", domain).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        serviceIdentity = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentity;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentities getServiceIdentities(String domainName, Boolean publickeys, Boolean hosts, String tagKey, String tagValue) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentities serviceIdentities;
        int code;
        HttpEntity httpResponseEntity;
        block17: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/services").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (publickeys != null) {
                uriBuilder.setParameter("publickeys", String.valueOf(publickeys));
            }
            if (hosts != null) {
                uriBuilder.setParameter("hosts", String.valueOf(hosts));
            }
            if (tagKey != null) {
                uriBuilder.setParameter("tagKey", tagKey);
            }
            if (tagValue != null) {
                uriBuilder.setParameter("tagValue", tagValue);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        serviceIdentities = (ServiceIdentities)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServiceIdentities.class);
                        if (httpResponse == null) break block17;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentities;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentityList getServiceIdentityList(String domainName, Integer limit, String skip) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentityList serviceIdentityList;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/service").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (limit != null) {
                uriBuilder.setParameter("limit", String.valueOf(limit));
            }
            if (skip != null) {
                uriBuilder.setParameter("skip", skip);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        serviceIdentityList = (ServiceIdentityList)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServiceIdentityList.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentityList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKeyEntry getPublicKeyEntry(String domain, String service, String id) throws URISyntaxException, IOException {
        String errorData;
        PublicKeyEntry publicKeyEntry;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("id", id);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        publicKeyEntry = (PublicKeyEntry)this.jsonMapper.readValue(httpResponseEntity.getContent(), PublicKeyEntry.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return publicKeyEntry;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKeyEntry putPublicKeyEntry(String domain, String service, String id, String auditRef, String resourceOwner, PublicKeyEntry publicKeyEntry) throws URISyntaxException, IOException {
        String errorData;
        PublicKeyEntry publicKeyEntry2;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("id", id);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)publicKeyEntry), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        publicKeyEntry2 = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return publicKeyEntry2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PublicKeyEntry deletePublicKeyEntry(String domain, String service, String id, String auditRef, String resourceOwner) throws URISyntaxException, IOException {
        String errorData;
        PublicKeyEntry publicKeyEntry;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/publickey/{id}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("id", id);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            if (resourceOwner != null) {
                httpUriRequest.addHeader("Athenz-Resource-Owner", (Object)resourceOwner);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        publicKeyEntry = null;
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return publicKeyEntry;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentity putServiceIdentitySystemMeta(String domain, String service, String attribute, String auditRef, ServiceIdentitySystemMeta detail) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentity serviceIdentity;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/meta/system/{attribute}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("attribute", attribute);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        serviceIdentity = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentity;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceServiceIdentityOwnership putResourceServiceIdentityOwnership(String domainName, String service, String auditRef, ResourceServiceIdentityOwnership resourceOwnership) throws URISyntaxException, IOException {
        String errorData;
        ResourceServiceIdentityOwnership resourceServiceIdentityOwnership;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/service/{service}/ownership").resolveTemplate("domainName", domainName).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)resourceOwnership), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        resourceServiceIdentityOwnership = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourceServiceIdentityOwnership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tenancy putTenancy(String domain, String service, String auditRef, Tenancy detail) throws URISyntaxException, IOException {
        String errorData;
        Tenancy tenancy;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/tenancy/{service}").resolveTemplate("domain", domain).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        tenancy = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenancy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tenancy deleteTenancy(String domain, String service, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        Tenancy tenancy;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/tenancy/{service}").resolveTemplate("domain", domain).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        tenancy = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenancy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tenancy putTenant(String domain, String service, String tenantDomain, String auditRef, Tenancy detail) throws URISyntaxException, IOException {
        String errorData;
        Tenancy tenancy;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/tenant/{tenantDomain}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("tenantDomain", tenantDomain);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        tenancy = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenancy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tenancy deleteTenant(String domain, String service, String tenantDomain, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        Tenancy tenancy;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/tenant/{tenantDomain}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("tenantDomain", tenantDomain);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        tenancy = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenancy;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TenantResourceGroupRoles putTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef, TenantResourceGroupRoles detail) throws URISyntaxException, IOException {
        String errorData;
        TenantResourceGroupRoles tenantResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        tenantResourceGroupRoles = (TenantResourceGroupRoles)this.jsonMapper.readValue(httpResponseEntity.getContent(), TenantResourceGroupRoles.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenantResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TenantResourceGroupRoles getTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup) throws URISyntaxException, IOException {
        String errorData;
        TenantResourceGroupRoles tenantResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        tenantResourceGroupRoles = (TenantResourceGroupRoles)this.jsonMapper.readValue(httpResponseEntity.getContent(), TenantResourceGroupRoles.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenantResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TenantResourceGroupRoles deleteTenantResourceGroupRoles(String domain, String service, String tenantDomain, String resourceGroup, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        TenantResourceGroupRoles tenantResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domain}/service/{service}/tenant/{tenantDomain}/resourceGroup/{resourceGroup}").resolveTemplate("domain", domain).resolveTemplate("service", service).resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        tenantResourceGroupRoles = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return tenantResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProviderResourceGroupRoles putProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef, ProviderResourceGroupRoles detail) throws URISyntaxException, IOException {
        String errorData;
        ProviderResourceGroupRoles providerResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("provDomain", provDomain).resolveTemplate("provService", provService).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)detail), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        providerResourceGroupRoles = (ProviderResourceGroupRoles)this.jsonMapper.readValue(httpResponseEntity.getContent(), ProviderResourceGroupRoles.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return providerResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProviderResourceGroupRoles getProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup) throws URISyntaxException, IOException {
        String errorData;
        ProviderResourceGroupRoles providerResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("provDomain", provDomain).resolveTemplate("provService", provService).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        providerResourceGroupRoles = (ProviderResourceGroupRoles)this.jsonMapper.readValue(httpResponseEntity.getContent(), ProviderResourceGroupRoles.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return providerResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProviderResourceGroupRoles deleteProviderResourceGroupRoles(String tenantDomain, String provDomain, String provService, String resourceGroup, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        ProviderResourceGroupRoles providerResourceGroupRoles;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{tenantDomain}/provDomain/{provDomain}/provService/{provService}/resourceGroup/{resourceGroup}").resolveTemplate("tenantDomain", tenantDomain).resolveTemplate("provDomain", provDomain).resolveTemplate("provService", provService).resolveTemplate("resourceGroup", resourceGroup);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        providerResourceGroupRoles = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return providerResourceGroupRoles;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Access getAccess(String action, String resource, String domain, String checkPrincipal) throws URISyntaxException, IOException {
        String errorData;
        Access access;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/access/{action}/{resource}").resolveTemplate("action", action).resolveTemplate("resource", resource);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (domain != null) {
                uriBuilder.setParameter("domain", domain);
            }
            if (checkPrincipal != null) {
                uriBuilder.setParameter("principal", checkPrincipal);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        access = (Access)this.jsonMapper.readValue(httpResponseEntity.getContent(), Access.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return access;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Access getAccessExt(String action, String resource, String domain, String checkPrincipal) throws URISyntaxException, IOException {
        String errorData;
        Access access;
        int code;
        HttpEntity httpResponseEntity;
        block16: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/access/{action}").resolveTemplate("action", action);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (resource != null) {
                uriBuilder.setParameter("resource", resource);
            }
            if (domain != null) {
                uriBuilder.setParameter("domain", domain);
            }
            if (checkPrincipal != null) {
                uriBuilder.setParameter("principal", checkPrincipal);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        access = (Access)this.jsonMapper.readValue(httpResponseEntity.getContent(), Access.class);
                        if (httpResponse == null) break block16;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return access;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResourceAccessList getResourceAccessList(String principal, String action) throws URISyntaxException, IOException {
        String errorData;
        ResourceAccessList resourceAccessList;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/resource");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            if (action != null) {
                uriBuilder.setParameter("action", action);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        resourceAccessList = (ResourceAccessList)this.jsonMapper.readValue(httpResponseEntity.getContent(), ResourceAccessList.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return resourceAccessList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignedDomains getSignedDomains(String domain, String metaOnly, String metaAttr, Boolean master, Boolean conditions, String matchingTag, Map<String, List<String>> headers) throws URISyntaxException, IOException {
        block24: {
            block25: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/sys/modified_domains");
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                if (domain != null) {
                    uriBuilder.setParameter("domain", domain);
                }
                if (metaOnly != null) {
                    uriBuilder.setParameter("metaonly", metaOnly);
                }
                if (metaAttr != null) {
                    uriBuilder.setParameter("metaattr", metaAttr);
                }
                if (master != null) {
                    uriBuilder.setParameter("master", String.valueOf(master));
                }
                if (conditions != null) {
                    uriBuilder.setParameter("conditions", String.valueOf(conditions));
                }
                httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (matchingTag != null) {
                    httpUriRequest.addHeader("If-None-Match", (Object)matchingTag);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 304: {
                            if (headers != null) {
                                headers.put("tag", List.of(httpResponse.getFirstHeader("ETag").getValue()));
                            }
                            if (code != 304) break block24;
                            var14_15 = null;
                            if (httpResponse == null) break block25;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var15_19) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var15_19;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var14_15;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 285->307)] { 
lbl53:
        // 1 sources

        return (SignedDomains)this.jsonMapper.readValue(httpResponseEntity.getContent(), SignedDomains.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl59:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var14_16;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JWSDomain getJWSDomain(String name, Boolean signatureP1363Format, String matchingTag, Map<String, List<String>> headers) throws URISyntaxException, IOException {
        block20: {
            block21: {
                uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/signed").resolveTemplate("name", name);
                uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
                if (signatureP1363Format != null) {
                    uriBuilder.setParameter("signaturep1363format", String.valueOf(signatureP1363Format));
                }
                httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
                if (this.credsHeader != null) {
                    httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
                }
                if (matchingTag != null) {
                    httpUriRequest.addHeader("If-None-Match", (Object)matchingTag);
                }
                httpResponseEntity = null;
                try {
                    httpResponse = this.client.execute(httpUriRequest, this.httpContext);
                    code = httpResponse.getCode();
                    httpResponseEntity = httpResponse.getEntity();
                    switch (code) {
                        case 200: 
                        case 304: {
                            if (headers != null) {
                                headers.put("tag", List.of(httpResponse.getFirstHeader("ETag").getValue()));
                            }
                            if (code != 304) break block20;
                            var11_12 = null;
                            if (httpResponse == null) break block21;
                            break;
                        }
                        default: {
                            v0 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                        }
                    }
                    httpResponse.close();
                }
                catch (Throwable var12_16) {
                    EntityUtils.consumeQuietly(httpResponseEntity);
                    throw var12_16;
                }
            }
            EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
            return var11_12;
        }
        ** try [egrp 3[TRYBLOCK] [1 : 229->251)] { 
lbl41:
        // 1 sources

        return (JWSDomain)this.jsonMapper.readValue(httpResponseEntity.getContent(), JWSDomain.class);
        {
            if (errorData != null && !errorData.isEmpty()) {
                v1 = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw v1;
            }
            v1 = new ClientResourceException(code);
            throw v1;
        }
lbl47:
        // 1 sources

        finally {
            if (httpResponse == null) {
                EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
                return var11_13;
            }
            httpResponse.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserToken getUserToken(String userName, String serviceNames, Boolean header) throws URISyntaxException, IOException {
        String errorData;
        UserToken userToken;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/user/{userName}/token").resolveTemplate("userName", userName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (serviceNames != null) {
                uriBuilder.setParameter("services", serviceNames);
            }
            if (header != null) {
                uriBuilder.setParameter("header", String.valueOf(header));
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        userToken = (UserToken)this.jsonMapper.readValue(httpResponseEntity.getContent(), UserToken.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return userToken;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserToken optionsUserToken(String userName, String serviceNames) throws URISyntaxException, IOException {
        String errorData;
        UserToken userToken;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/user/{userName}/token").resolveTemplate("userName", userName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (serviceNames != null) {
                uriBuilder.setParameter("services", serviceNames);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.options().setUri(uriBuilder.build()).build();
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        userToken = (UserToken)this.jsonMapper.readValue(httpResponseEntity.getContent(), UserToken.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return userToken;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServicePrincipal getServicePrincipal() throws URISyntaxException, IOException {
        String errorData;
        ServicePrincipal servicePrincipal;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/principal");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        servicePrincipal = (ServicePrincipal)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServicePrincipal.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return servicePrincipal;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServerTemplateList getServerTemplateList() throws URISyntaxException, IOException {
        String errorData;
        ServerTemplateList serverTemplateList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/template");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        serverTemplateList = (ServerTemplateList)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServerTemplateList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serverTemplateList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Template getTemplate(String template) throws URISyntaxException, IOException {
        String errorData;
        Template template2;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/template/{template}").resolveTemplate("template", template);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        template2 = (Template)this.jsonMapper.readValue(httpResponseEntity.getContent(), Template.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return template2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplateDetailsList getDomainTemplateDetailsList(String name) throws URISyntaxException, IOException {
        String errorData;
        DomainTemplateDetailsList domainTemplateDetailsList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/templatedetails").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainTemplateDetailsList = (DomainTemplateDetailsList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainTemplateDetailsList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplateDetailsList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainTemplateDetailsList getServerTemplateDetailsList() throws URISyntaxException, IOException {
        String errorData;
        DomainTemplateDetailsList domainTemplateDetailsList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/templatedetails");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainTemplateDetailsList = (DomainTemplateDetailsList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainTemplateDetailsList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainTemplateDetailsList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserList getUserList(String domainName) throws URISyntaxException, IOException {
        String errorData;
        UserList userList;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/user");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (domainName != null) {
                uriBuilder.setParameter("domain", domainName);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        userList = (UserList)this.jsonMapper.readValue(httpResponseEntity.getContent(), UserList.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return userList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User deleteUser(String name, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        User user;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/user/{name}").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        user = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return user;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRoleMember deleteDomainRoleMember(String domainName, String memberName, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        DomainRoleMember domainRoleMember;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{domainName}/member/{memberName}").resolveTemplate("domainName", domainName).resolveTemplate("memberName", memberName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        domainRoleMember = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainRoleMember;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Quota getQuota(String name) throws URISyntaxException, IOException {
        String errorData;
        Quota quota;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/quota").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        quota = (Quota)this.jsonMapper.readValue(httpResponseEntity.getContent(), Quota.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return quota;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Quota putQuota(String name, String auditRef, Quota quota) throws URISyntaxException, IOException {
        String errorData;
        Quota quota2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/quota").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)quota), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        quota2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return quota2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Quota deleteQuota(String name, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        Quota quota;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/quota").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        quota = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return quota;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status getStatus() throws URISyntaxException, IOException {
        String errorData;
        Status status;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/status");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        status = (Status)this.jsonMapper.readValue(httpResponseEntity.getContent(), Status.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return status;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainRoleMembership getPendingDomainRoleMembersList(String principal, String domainName) throws URISyntaxException, IOException {
        String errorData;
        DomainRoleMembership domainRoleMembership;
        int code;
        HttpEntity httpResponseEntity;
        block15: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/pending_members");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            if (domainName != null) {
                uriBuilder.setParameter("domain", domainName);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainRoleMembership = (DomainRoleMembership)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainRoleMembership.class);
                        if (httpResponse == null) break block15;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainRoleMembership;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserAuthorityAttributeMap getUserAuthorityAttributeMap() throws URISyntaxException, IOException {
        String errorData;
        UserAuthorityAttributeMap userAuthorityAttributeMap;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/authority/user/attribute");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        userAuthorityAttributeMap = (UserAuthorityAttributeMap)this.jsonMapper.readValue(httpResponseEntity.getContent(), UserAuthorityAttributeMap.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return userAuthorityAttributeMap;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stats getStats(String name) throws URISyntaxException, IOException {
        String errorData;
        Stats stats;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/domain/{name}/stats").resolveTemplate("name", name);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        stats = (Stats)this.jsonMapper.readValue(httpResponseEntity.getContent(), Stats.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return stats;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Stats getSystemStats() throws URISyntaxException, IOException {
        String errorData;
        Stats stats;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/sys/stats");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        stats = (Stats)this.jsonMapper.readValue(httpResponseEntity.getContent(), Stats.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return stats;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DependentService putDomainDependency(String domainName, String auditRef, DependentService service) throws URISyntaxException, IOException {
        String errorData;
        DependentService dependentService;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/dependency/domain/{domainName}").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)service), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        dependentService = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return dependentService;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String deleteDomainDependency(String domainName, String service, String auditRef) throws URISyntaxException, IOException {
        String errorData;
        String string;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/dependency/domain/{domainName}/service/{service}").resolveTemplate("domainName", domainName).resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.delete().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        string = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string2 = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return string;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceIdentityList getDependentServiceList(String domainName) throws URISyntaxException, IOException {
        String errorData;
        ServiceIdentityList serviceIdentityList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/dependency/domain/{domainName}").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        serviceIdentityList = (ServiceIdentityList)this.jsonMapper.readValue(httpResponseEntity.getContent(), ServiceIdentityList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return serviceIdentityList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DependentServiceResourceGroupList getDependentServiceResourceGroupList(String domainName) throws URISyntaxException, IOException {
        String errorData;
        DependentServiceResourceGroupList dependentServiceResourceGroupList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/dependency/domain/{domainName}/resourceGroup").resolveTemplate("domainName", domainName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        dependentServiceResourceGroupList = (DependentServiceResourceGroupList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DependentServiceResourceGroupList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return dependentServiceResourceGroupList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DomainList getDependentDomainList(String service) throws URISyntaxException, IOException {
        String errorData;
        DomainList domainList;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/dependency/service/{service}").resolveTemplate("service", service);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        domainList = (DomainList)this.jsonMapper.readValue(httpResponseEntity.getContent(), DomainList.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return domainList;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReviewObjects getRolesForReview(String principal) throws URISyntaxException, IOException {
        String errorData;
        ReviewObjects reviewObjects;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/review/role");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        reviewObjects = (ReviewObjects)this.jsonMapper.readValue(httpResponseEntity.getContent(), ReviewObjects.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return reviewObjects;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReviewObjects getGroupsForReview(String principal) throws URISyntaxException, IOException {
        String errorData;
        ReviewObjects reviewObjects;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/review/group");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            if (principal != null) {
                uriBuilder.setParameter("principal", principal);
            }
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        reviewObjects = (ReviewObjects)this.jsonMapper.readValue(httpResponseEntity.getContent(), ReviewObjects.class);
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return reviewObjects;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Info getInfo() throws URISyntaxException, IOException {
        String errorData;
        Info info;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/sys/info");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        info = (Info)this.jsonMapper.readValue(httpResponseEntity.getContent(), Info.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return info;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrincipalState putPrincipalState(String principalName, String auditRef, PrincipalState principalState) throws URISyntaxException, IOException {
        String errorData;
        PrincipalState principalState2;
        int code;
        HttpEntity httpResponseEntity;
        block14: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/principal/{principalName}/state").resolveTemplate("principalName", principalName);
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            StringEntity httpEntity = new StringEntity(this.jsonMapper.writeValueAsString((Object)principalState), ContentType.APPLICATION_JSON);
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.put().setUri(uriBuilder.build()).setEntity((HttpEntity)httpEntity).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            if (auditRef != null) {
                httpUriRequest.addHeader("Y-Audit-Ref", (Object)auditRef);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 204: {
                        principalState2 = null;
                        if (httpResponse == null) break block14;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return principalState2;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, ClientResourceError.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema getRdlSchema() throws URISyntaxException, IOException {
        String errorData;
        Schema schema;
        int code;
        HttpEntity httpResponseEntity;
        block13: {
            UriTemplateBuilder uriTemplateBuilder = new UriTemplateBuilder(this.baseUrl, "/schema");
            URIBuilder uriBuilder = new URIBuilder(uriTemplateBuilder.getUri());
            ClassicHttpRequest httpUriRequest = ClassicRequestBuilder.get().setUri(uriBuilder.build()).build();
            if (this.credsHeader != null) {
                httpUriRequest.addHeader(this.credsHeader, (Object)this.credsToken);
            }
            httpResponseEntity = null;
            try (CloseableHttpResponse httpResponse = this.client.execute(httpUriRequest, this.httpContext);){
                code = httpResponse.getCode();
                httpResponseEntity = httpResponse.getEntity();
                switch (code) {
                    case 200: {
                        schema = (Schema)this.jsonMapper.readValue(httpResponseEntity.getContent(), Schema.class);
                        if (httpResponse == null) break block13;
                        break;
                    }
                    default: {
                        String string = errorData = httpResponseEntity == null ? null : this.getStringResponseEntity(httpResponseEntity);
                    }
                }
            }
            catch (Throwable throwable) {
                EntityUtils.consumeQuietly(httpResponseEntity);
                throw throwable;
            }
        }
        EntityUtils.consumeQuietly((HttpEntity)httpResponseEntity);
        return schema;
        {
            ClientResourceException clientResourceException;
            if (errorData != null && !errorData.isEmpty()) {
                clientResourceException = new ClientResourceException(code, this.jsonMapper.readValue(errorData, Object.class));
                throw clientResourceException;
            }
            clientResourceException = new ClientResourceException(code);
            throw clientResourceException;
        }
    }

    private static class UriTemplateBuilder {
        private final String baseUrl;
        private String basePath;

        public UriTemplateBuilder(String url, String path) {
            this.baseUrl = url;
            this.basePath = path;
        }

        public UriTemplateBuilder resolveTemplate(String key, Object value) {
            this.basePath = this.basePath.replace("{" + key + "}", String.valueOf(value));
            return this;
        }

        public String getUri() {
            return this.baseUrl + this.basePath;
        }
    }
}

