/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe;

import com.yahoo.athenz.auth.token.AccessToken;
import com.yahoo.athenz.auth.token.RoleToken;
import com.yahoo.athenz.auth.token.jwts.JwtsSigningKeyResolver;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.auth.util.CryptoException;
import com.yahoo.athenz.zpe.ZpeClient;
import com.yahoo.athenz.zpe.match.ZpeMatch;
import com.yahoo.athenz.zpe.pkey.PublicKeyStore;
import com.yahoo.athenz.zpe.pkey.PublicKeyStoreFactory;
import com.yahoo.rdl.Struct;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLContext;
import javax.security.auth.x500.X500Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthZpeClient {
    private static final Logger LOG = LoggerFactory.getLogger(AuthZpeClient.class);
    public static final String ZPE_UPDATER_CLASS = "com.yahoo.athenz.zpe.ZpeUpdater";
    public static final String ZPE_PKEY_CLASS = "com.yahoo.athenz.zpe.pkey.file.FilePublicKeyStoreFactory";
    public static final String ZPE_TOKEN_HDR = System.getProperty("athenz.auth.role.header", "Athenz-Role-Auth");
    public static final String ZTS_PUBLIC_KEY = "zts_public_key";
    public static final String ZMS_PUBLIC_KEY = "zms_public_key";
    public static final String ZTS_PUBLIC_KEY_PREFIX = "zts.public_key.";
    public static final String ZMS_PUBLIC_KEY_PREFIX = "zms.public_key.";
    public static final String SYS_AUTH_DOMAIN = "sys.auth";
    public static final String ZTS_SERVICE_NAME = "zts";
    public static final String ZMS_SERVICE_NAME = "zms";
    public static final String DEFAULT_DOMAIN = "sys.auth";
    public static final String UNKNOWN_DOMAIN = "unknown";
    public static final String BEARER_TOKEN = "Bearer ";
    private static int allowedOffset = 300;
    private static JwtsSigningKeyResolver accessSignKeyResolver = null;
    private static ZpeClient zpeClt = null;
    private static PublicKeyStore publicKeyStore = null;
    private static final Set<String> X509_ISSUERS_NAMES = new HashSet<String>();
    private static final List<List<Rdn>> X509_ISSUERS_RDNS = new ArrayList<List<Rdn>>();

    public static void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Init: load the ZPE");
        }
    }

    public static void setTokenAllowedOffset(int offset) {
        allowedOffset = offset;
        if (allowedOffset < 0) {
            allowedOffset = 300;
        }
    }

    public static void setX509CAIssuers(String issuers) {
        String[] issuerArray;
        if (issuers == null || issuers.isEmpty()) {
            return;
        }
        for (String issuer : issuerArray = issuers.split("\\|")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("x509 issuer: {}", (Object)issuer);
            }
            X509_ISSUERS_NAMES.add(issuer.replaceAll("\\s+", ""));
            try {
                X509_ISSUERS_RDNS.add(new LdapName(issuer).getRdns());
            }
            catch (InvalidNameException ex) {
                LOG.error("Invalid issuer: {}, error: {}", (Object)issuer, (Object)ex.getMessage());
            }
        }
    }

    public static void setPublicKeyStoreFactoryClass(String className) {
        PublicKeyStoreFactory publicKeyStoreFactory;
        try {
            publicKeyStoreFactory = (PublicKeyStoreFactory)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error("Invalid PublicKeyStore class: {}, error: {}", (Object)className, (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
        publicKeyStore = publicKeyStoreFactory.create();
    }

    public static void setAccessTokenSignKeyResolver(String serverUrl, SSLContext sslContext) {
        accessSignKeyResolver = new JwtsSigningKeyResolver(serverUrl, sslContext);
    }

    public static void addAccessTokenSignKeyResolverKey(String keyId, PublicKey key) {
        accessSignKeyResolver.addPublicKey(keyId, key);
    }

    public static void setZPEClientClass(String className) {
        try {
            zpeClt = (ZpeClient)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            LOG.error("Unable to instantiate zpe class: {}, error: {}", (Object)className, (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
        zpeClt.init(null);
    }

    public static PublicKey getZtsPublicKey(String keyId) {
        PublicKey publicKey = publicKeyStore.getZtsKey(keyId);
        if (publicKey == null) {
            publicKey = accessSignKeyResolver.getPublicKey(keyId);
        }
        return publicKey;
    }

    protected static void setMillisBetweenZtsCalls(long millis) {
        JwtsSigningKeyResolver.setMillisBetweenZtsCalls((long)millis);
    }

    public static PublicKey getZmsPublicKey(String keyId) {
        return publicKeyStore.getZmsKey(keyId);
    }

    public static AccessCheckStatus allowAccess(X509Certificate cert, String resource, String action) {
        StringBuilder matchRoleName = new StringBuilder(256);
        return AuthZpeClient.allowAccess(cert, resource, action, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(X509Certificate cert, String resource, String action, StringBuilder matchRoleName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("allowAccess: action={} resource={}", (Object)action, (Object)resource);
        }
        if (!AuthZpeClient.certIssuerMatch(cert)) {
            return AccessCheckStatus.DENY_CERT_MISMATCH_ISSUER;
        }
        String subject = Crypto.extractX509CertCommonName((X509Certificate)cert);
        if (subject == null || subject.isEmpty()) {
            LOG.error("allowAccess: missing subject in x.509 certificate");
            return AccessCheckStatus.DENY_CERT_MISSING_SUBJECT;
        }
        int idx = subject.indexOf(":role.");
        if (idx == -1) {
            LOG.error("allowAccess: invalid role format in x.509 subject: {}", (Object)subject);
            return AccessCheckStatus.DENY_CERT_MISSING_ROLE_NAME;
        }
        String domainName = subject.substring(0, idx);
        if (domainName.isEmpty()) {
            LOG.error("allowAccess: missing domain in x.509 subject: {}", (Object)subject);
            return AccessCheckStatus.DENY_CERT_MISSING_DOMAIN;
        }
        String roleName = subject.substring(idx + ":role.".length());
        if (roleName.isEmpty()) {
            LOG.error("allowAccess: missing role in x.509 subject: {}", (Object)subject);
            return AccessCheckStatus.DENY_CERT_MISSING_ROLE_NAME;
        }
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(roleName);
        return AuthZpeClient.allowActionZPE(action, domainName, resource, roles, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(String token, String resource, String action) {
        StringBuilder matchRoleName = new StringBuilder(256);
        return AuthZpeClient.allowAccess(token, null, null, resource, action, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(String token, String resource, String action, StringBuilder matchRoleName) {
        return AuthZpeClient.allowAccess(token, null, null, resource, action, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(String token, X509Certificate cert, String certHash, String resource, String action, StringBuilder matchRoleName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("allowAccess: action={} resource={}", (Object)action, (Object)resource);
        }
        if (token.startsWith("v=Z1;")) {
            return AuthZpeClient.allowRoleTokenAccess(token, resource, action, matchRoleName);
        }
        return AuthZpeClient.allowAccessTokenAccess(token, cert, certHash, resource, action, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(String token, X509Certificate cert, String certHash, String resource, String action) {
        StringBuilder matchRoleName = new StringBuilder();
        return AuthZpeClient.allowAccess(token, cert, certHash, resource, action, matchRoleName);
    }

    static AccessCheckStatus allowRoleTokenAccess(String roleToken, String resource, String action, StringBuilder matchRoleName) {
        Map<String, RoleToken> tokenCache = zpeClt.getRoleTokenCacheMap();
        RoleToken rToken = tokenCache.get(roleToken);
        if (rToken == null) {
            rToken = new RoleToken(roleToken);
            if (!rToken.validate(AuthZpeClient.getZtsPublicKey(rToken.getKeyId()), allowedOffset, false, null)) {
                if (AuthZpeClient.isTokenExpired(rToken)) {
                    return AccessCheckStatus.DENY_ROLETOKEN_EXPIRED;
                }
                LOG.error("allowAccess: Authorization denied. Authentication failed for token={}", (Object)rToken.getUnsignedToken());
                return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
            }
            tokenCache.put(roleToken, rToken);
        }
        return AuthZpeClient.allowAccess(rToken, resource, action, matchRoleName);
    }

    static AccessCheckStatus allowAccessTokenAccess(String accessToken, X509Certificate cert, String certHash, String resource, String action, StringBuilder matchRoleName) {
        Map<String, AccessToken> tokenCache;
        AccessToken acsToken;
        if (accessToken.startsWith(BEARER_TOKEN)) {
            accessToken = accessToken.substring(BEARER_TOKEN.length());
        }
        if ((acsToken = (tokenCache = zpeClt.getAccessTokenCacheMap()).get(accessToken)) != null && cert != null && !acsToken.confirmMTLSBoundToken(cert, certHash)) {
            LOG.error("allowAccess: mTLS Client certificate confirmation failed");
            return AccessCheckStatus.DENY_CERT_HASH_MISMATCH;
        }
        if (acsToken == null) {
            try {
                acsToken = cert == null && certHash == null ? new AccessToken(accessToken, accessSignKeyResolver) : new AccessToken(accessToken, accessSignKeyResolver, cert, certHash);
            }
            catch (CryptoException ex) {
                LOG.error("allowAccess: Authorization denied. Authentication failed for token={}", (Object)ex.getMessage());
                return ex.getCode() == 2 ? AccessCheckStatus.DENY_CERT_HASH_MISMATCH : AccessCheckStatus.DENY_ROLETOKEN_INVALID;
            }
            catch (Exception ex) {
                LOG.error("allowAccess: Authorization denied. Authentication failed for token={}", (Object)ex.getMessage());
                return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
            }
            tokenCache.put(accessToken, acsToken);
        }
        return AuthZpeClient.allowAccess(acsToken, resource, action, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(RoleToken rToken, String resource, String action, StringBuilder matchRoleName) {
        if (rToken == null) {
            LOG.error("allowAccess: Authorization denied. Token is null");
            return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
        }
        if (AuthZpeClient.isTokenExpired(rToken)) {
            return AccessCheckStatus.DENY_ROLETOKEN_EXPIRED;
        }
        String tokenDomain = rToken.getDomain();
        List roles = rToken.getRoles();
        return AuthZpeClient.allowActionZPE(action, tokenDomain, resource, roles, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(AccessToken accessToken, String resource, String action, StringBuilder matchRoleName) {
        if (accessToken == null) {
            LOG.error("allowAccess: Authorization denied. Token is null");
            return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
        }
        if (AuthZpeClient.isTokenExpired(accessToken)) {
            return AccessCheckStatus.DENY_ROLETOKEN_EXPIRED;
        }
        String tokenDomain = accessToken.getAudience();
        List roles = accessToken.getScope();
        return AuthZpeClient.allowActionZPE(action, tokenDomain, resource, roles, matchRoleName);
    }

    public static AccessCheckStatus allowAccess(List<String> tokenList, String resource, String action, StringBuilder matchRoleName) {
        AccessCheckStatus retStatus = AccessCheckStatus.DENY_NO_MATCH;
        StringBuilder roleName = null;
        for (String roleToken : tokenList) {
            StringBuilder rName;
            AccessCheckStatus status = AuthZpeClient.allowAccess(roleToken, resource, action, rName = new StringBuilder(256));
            if (status == AccessCheckStatus.DENY) {
                matchRoleName.append((CharSequence)rName);
                return status;
            }
            if (retStatus == AccessCheckStatus.ALLOW) continue;
            retStatus = status;
            roleName = rName;
        }
        if (roleName != null) {
            matchRoleName.append((CharSequence)roleName);
        }
        return retStatus;
    }

    static boolean isTokenExpired(RoleToken roleToken) {
        long now = System.currentTimeMillis() / 1000L;
        long expiry = roleToken.getExpiryTime();
        if (expiry != 0L && expiry < now) {
            LOG.error("ExpiryCheck: Token expired. now={} expiry={} token={}", new Object[]{now, expiry, roleToken.getUnsignedToken()});
            return true;
        }
        return false;
    }

    static boolean isTokenExpired(AccessToken accessToken) {
        long now = System.currentTimeMillis() / 1000L;
        long expiry = accessToken.getExpiryTime();
        if (expiry != 0L && expiry < now) {
            LOG.error("ExpiryCheck: Token expired. now={} expiry={} token={}", new Object[]{now, expiry, accessToken.getClientId()});
            return true;
        }
        return false;
    }

    public static AccessToken validateAccessToken(String accessToken, X509Certificate cert, String certHash) {
        Map<String, AccessToken> tokenCache;
        AccessToken acsToken;
        if (accessToken.startsWith(BEARER_TOKEN)) {
            accessToken = accessToken.substring(BEARER_TOKEN.length());
        }
        if ((acsToken = (tokenCache = zpeClt.getAccessTokenCacheMap()).get(accessToken)) != null && cert != null && !acsToken.confirmMTLSBoundToken(cert, certHash)) {
            return null;
        }
        if (acsToken == null) {
            try {
                acsToken = cert == null && certHash == null ? new AccessToken(accessToken, accessSignKeyResolver) : new AccessToken(accessToken, accessSignKeyResolver, cert, certHash);
            }
            catch (Exception ex) {
                LOG.error("validateAccessToken: Access Token validation failed: {}", (Object)ex.getMessage());
                return null;
            }
            tokenCache.put(accessToken, acsToken);
        }
        return acsToken;
    }

    public static RoleToken validateRoleToken(String roleToken) {
        Map<String, RoleToken> tokenCache = zpeClt.getRoleTokenCacheMap();
        RoleToken rToken = tokenCache.get(roleToken);
        if (rToken != null && AuthZpeClient.isTokenExpired(rToken)) {
            tokenCache.remove(roleToken);
            rToken = null;
        }
        if (rToken == null) {
            rToken = new RoleToken(roleToken);
            if (!rToken.validate(AuthZpeClient.getZtsPublicKey(rToken.getKeyId()), allowedOffset, false, null)) {
                return null;
            }
            tokenCache.put(roleToken, rToken);
        }
        return rToken;
    }

    static String stripDomainPrefix(String assertString, String domain, String defaultValue) {
        int index = assertString.indexOf(58);
        if (index == -1) {
            return assertString;
        }
        if (!assertString.substring(0, index).equals(domain)) {
            return defaultValue;
        }
        return assertString.substring(index + 1);
    }

    public static AccessCheckStatus allowActionZPE(String action, String tokenDomain, String resource, List<String> roles, StringBuilder matchRoleName) {
        String msgPrefix = "allowActionZPE: domain(" + tokenDomain + ") action(" + action + ") resource(" + resource + ")";
        if (roles == null || roles.size() == 0) {
            LOG.error("{} ERROR: No roles so access denied", (Object)msgPrefix);
            return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} roles({}) starting...", (Object)msgPrefix, (Object)String.join((CharSequence)",", roles));
        }
        if (tokenDomain == null || tokenDomain.isEmpty()) {
            LOG.error("{} ERROR: No domain so access denied", (Object)msgPrefix);
            return AccessCheckStatus.DENY_ROLETOKEN_INVALID;
        }
        if (action == null || action.isEmpty()) {
            LOG.error("{} ERROR: No action so access denied", (Object)msgPrefix);
            return AccessCheckStatus.DENY_INVALID_PARAMETERS;
        }
        action = action.toLowerCase();
        if (resource == null || resource.isEmpty()) {
            LOG.error("{} ERROR: No resource so access denied", (Object)msgPrefix);
            return AccessCheckStatus.DENY_INVALID_PARAMETERS;
        }
        resource = resource.toLowerCase();
        if ((resource = AuthZpeClient.stripDomainPrefix(resource, tokenDomain, zpeClt.getDomainCount() == 1 ? resource : null)) == null) {
            LOG.error("{} ERROR: Domain mismatch in token({}) and resource so access denied", (Object)msgPrefix, (Object)tokenDomain);
            return AccessCheckStatus.DENY_DOMAIN_MISMATCH;
        }
        AccessCheckStatus status = AccessCheckStatus.DENY_DOMAIN_NOT_FOUND;
        Map<String, List<Struct>> roleMap = zpeClt.getRoleDenyAssertions(tokenDomain);
        if (roleMap != null && !roleMap.isEmpty()) {
            if (AuthZpeClient.actionByRole(action, tokenDomain, resource, roles, roleMap, matchRoleName)) {
                return AccessCheckStatus.DENY;
            }
            status = AccessCheckStatus.DENY_NO_MATCH;
        } else if (roleMap != null) {
            status = AccessCheckStatus.DENY_DOMAIN_EMPTY;
        }
        roleMap = zpeClt.getWildcardDenyAssertions(tokenDomain);
        if (roleMap != null && !roleMap.isEmpty()) {
            if (AuthZpeClient.actionByWildCardRole(action, tokenDomain, resource, roles, roleMap, matchRoleName)) {
                return AccessCheckStatus.DENY;
            }
            status = AccessCheckStatus.DENY_NO_MATCH;
        } else if (status != AccessCheckStatus.DENY_NO_MATCH && roleMap != null) {
            status = AccessCheckStatus.DENY_DOMAIN_EMPTY;
        }
        roleMap = zpeClt.getRoleAllowAssertions(tokenDomain);
        if (roleMap != null && !roleMap.isEmpty()) {
            if (AuthZpeClient.actionByRole(action, tokenDomain, resource, roles, roleMap, matchRoleName)) {
                return AccessCheckStatus.ALLOW;
            }
            status = AccessCheckStatus.DENY_NO_MATCH;
        } else if (status != AccessCheckStatus.DENY_NO_MATCH && roleMap != null) {
            status = AccessCheckStatus.DENY_DOMAIN_EMPTY;
        }
        roleMap = zpeClt.getWildcardAllowAssertions(tokenDomain);
        if (roleMap != null && !roleMap.isEmpty()) {
            if (AuthZpeClient.actionByWildCardRole(action, tokenDomain, resource, roles, roleMap, matchRoleName)) {
                return AccessCheckStatus.ALLOW;
            }
            status = AccessCheckStatus.DENY_NO_MATCH;
        } else if (status != AccessCheckStatus.DENY_NO_MATCH && roleMap != null) {
            status = AccessCheckStatus.DENY_DOMAIN_EMPTY;
        }
        if (status == AccessCheckStatus.DENY_DOMAIN_NOT_FOUND) {
            LOG.error("{}: No role map found for domain={} so access denied", (Object)msgPrefix, (Object)tokenDomain);
        } else if (status == AccessCheckStatus.DENY_DOMAIN_EMPTY) {
            LOG.error("{}: No policy assertions for domain={} so access denied", (Object)msgPrefix, (Object)tokenDomain);
        }
        return status;
    }

    static boolean matchAssertions(List<Struct> asserts, String role, String action, String resource, StringBuilder matchRoleName, String msgPrefix) {
        String passertAction = null;
        String passertResource = null;
        String polName = null;
        for (Struct strAssert : asserts) {
            ZpeMatch matchStruct;
            if (LOG.isDebugEnabled()) {
                passertAction = strAssert.getString("action");
                passertResource = strAssert.getString("resource");
                polName = strAssert.getString("polname");
                String passertRole = strAssert.getString("role");
                LOG.debug("{}: Process Assertion: policy({}) assert-action={} assert-resource={} assert-role={}", new Object[]{msgPrefix, polName, passertAction, passertResource, passertRole});
            }
            if (!(matchStruct = (ZpeMatch)strAssert.get("actionMatchStruct")).matches(action)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}: policy({}) regexpr-match: FAILed: assert-action({}) doesn't match action({})", new Object[]{msgPrefix, polName, passertAction, action});
                continue;
            }
            matchStruct = (ZpeMatch)strAssert.get("resourceMatchStruct");
            if (!matchStruct.matches(resource)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}: policy({}) regexpr-match: FAILed: assert-resource({}) doesn't match resource({})", new Object[]{msgPrefix, polName, passertResource, resource});
                continue;
            }
            matchRoleName.setLength(0);
            matchRoleName.append(role);
            return true;
        }
        return false;
    }

    static boolean actionByRole(String action, String domain, String resource, List<String> roles, Map<String, List<Struct>> roleMap, StringBuilder matchRoleName) {
        String msgPrefix = null;
        if (LOG.isDebugEnabled()) {
            msgPrefix = "allowActionByRole: domain(" + domain + ") action(" + action + ") resource(" + resource + ")";
        }
        for (String role : roles) {
            List<Struct> asserts;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Process role ({})", msgPrefix, (Object)role);
            }
            if ((asserts = roleMap.get(role)) == null || asserts.isEmpty()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{}: No policy assertions in domain={} for role={} so access denied", new Object[]{msgPrefix, domain, role});
                continue;
            }
            if (!AuthZpeClient.matchAssertions(asserts, role, action, resource, matchRoleName, msgPrefix)) continue;
            return true;
        }
        return false;
    }

    static boolean actionByWildCardRole(String action, String domain, String resource, List<String> roles, Map<String, List<Struct>> roleMap, StringBuilder matchRoleName) {
        String msgPrefix = null;
        if (LOG.isDebugEnabled()) {
            msgPrefix = "allowActionByWildCardRole: domain(" + domain + ") action(" + action + ") resource(" + resource + ")";
        }
        Set<String> keys = roleMap.keySet();
        for (String role : roles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}: Process role ({})", (Object)msgPrefix, (Object)role);
            }
            for (String roleName : keys) {
                List<Struct> asserts = roleMap.get(roleName);
                if (asserts == null || asserts.isEmpty()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("{}: No policy assertions in domain={} for role={} so access denied", new Object[]{msgPrefix, domain, role});
                    continue;
                }
                Struct structAssert = asserts.get(0);
                ZpeMatch matchStruct = (ZpeMatch)structAssert.get("roleMatchStruct");
                if (!matchStruct.matches(role)) {
                    if (!LOG.isDebugEnabled()) continue;
                    String polName = structAssert.getString("polname");
                    LOG.debug("{}: policy({}) regexpr-match: FAILed: assert-role({}) doesnt match role({})", new Object[]{msgPrefix, polName, roleName, role});
                    continue;
                }
                if (!AuthZpeClient.matchAssertions(asserts, roleName, action, resource, matchRoleName, msgPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean certIssuerMatch(X509Certificate cert) {
        if (X509_ISSUERS_NAMES.isEmpty()) {
            return true;
        }
        X500Principal issuerX500Principal = cert.getIssuerX500Principal();
        String issuer = issuerX500Principal.getName();
        if (!AuthZpeClient.issuerMatch(issuer)) {
            LOG.error("certIssuerMatch: missing or mismatch issuer {}", (Object)issuer);
            return false;
        }
        return true;
    }

    static boolean issuerMatch(String issuer) {
        if (issuer == null || issuer.isEmpty()) {
            return false;
        }
        if (X509_ISSUERS_NAMES.contains(issuer.replaceAll("\\s+", ""))) {
            return true;
        }
        try {
            X500Principal issuerCheck = new X500Principal(issuer);
            List<Rdn> issuerRdns = new LdapName(issuerCheck.getName()).getRdns();
            for (List<Rdn> rdns : X509_ISSUERS_RDNS) {
                if (rdns.size() != issuerRdns.size() || !rdns.containsAll(issuerRdns)) continue;
                return true;
            }
        }
        catch (InvalidNameException invalidNameException) {
            // empty catch block
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("usage: AuthZpeClient <authz-token> <action> <resource>");
            System.exit(1);
        }
        String authzToken = args[0];
        String action = args[1];
        String resource = args[2];
        StringBuilder matchRoleName = new StringBuilder();
        AuthZpeClient.init();
        AccessCheckStatus status = AuthZpeClient.allowAccess(authzToken, resource, action, matchRoleName);
        System.out.println(status.toString() + ":" + matchRoleName);
        System.exit(0);
    }

    static {
        AuthZpeClient.setPublicKeyStoreFactoryClass(System.getProperty("athenz.zpe.public_key_class", ZPE_PKEY_CLASS));
        AuthZpeClient.setZPEClientClass(System.getProperty("athenz.zpe.updater_class", ZPE_UPDATER_CLASS));
        AuthZpeClient.setTokenAllowedOffset(Integer.parseInt(System.getProperty("athenz.zpe.token_allowed_offset", "300")));
        AuthZpeClient.setX509CAIssuers(System.getProperty("athenz.zpe.x509.ca.issuers"));
        AuthZpeClient.setAccessTokenSignKeyResolver(null, null);
        AuthZpeClient.setMillisBetweenZtsCalls(Long.parseLong(System.getProperty("athenz.zpe.millis_between_zts_calls", Long.toString(1800000L))));
    }

    public static enum AccessCheckStatus {
        ALLOW{

            public String toString() {
                return "Access Check was explicitly allowed";
            }
        }
        ,
        DENY{

            public String toString() {
                return "Access Check was explicitly denied";
            }
        }
        ,
        DENY_NO_MATCH{

            public String toString() {
                return "Access denied due to no match to any of the assertions defined in domain policy file";
            }
        }
        ,
        DENY_ROLETOKEN_EXPIRED{

            public String toString() {
                return "Access denied due to expired Token";
            }
        }
        ,
        DENY_ROLETOKEN_INVALID{

            public String toString() {
                return "Access denied due to invalid Token";
            }
        }
        ,
        DENY_DOMAIN_MISMATCH{

            public String toString() {
                return "Access denied due to domain mismatch between Resource and Token";
            }
        }
        ,
        DENY_DOMAIN_NOT_FOUND{

            public String toString() {
                return "Access denied due to domain not found in library cache";
            }
        }
        ,
        DENY_DOMAIN_EXPIRED{

            public String toString() {
                return "Access denied due to expired domain policy file";
            }
        }
        ,
        DENY_DOMAIN_EMPTY{

            public String toString() {
                return "Access denied due to no policies in the domain file";
            }
        }
        ,
        DENY_INVALID_PARAMETERS{

            public String toString() {
                return "Access denied due to invalid/empty action/resource values";
            }
        }
        ,
        DENY_CERT_MISMATCH_ISSUER{

            public String toString() {
                return "Access denied due to certificate mismatch in issuer";
            }
        }
        ,
        DENY_CERT_MISSING_SUBJECT{

            public String toString() {
                return "Access denied due to missing subject in certificate";
            }
        }
        ,
        DENY_CERT_MISSING_DOMAIN{

            public String toString() {
                return "Access denied due to missing domain name in certificate";
            }
        }
        ,
        DENY_CERT_MISSING_ROLE_NAME{

            public String toString() {
                return "Access denied due to missing role name in certificate";
            }
        }
        ,
        DENY_CERT_HASH_MISMATCH{

            public String toString() {
                return "Access denied due to access token certificate hash mismatch";
            }
        };

    }
}

