/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe;

import com.yahoo.athenz.zpe.ZpeUpdPolLoader;
import java.io.File;
import java.io.FilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZpeUpdMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ZpeUpdMonitor.class);
    private String dirName;
    private boolean firstRun = true;
    private final ZpeUpdPolLoader updLoader;
    private volatile boolean shutdownThread = false;
    private FilenameFilter polFileNameFilter = (dir, name) -> name.endsWith(".pol");

    ZpeUpdMonitor(ZpeUpdPolLoader zpeUpdLoader) {
        this.updLoader = zpeUpdLoader;
        this.dirName = this.updLoader.getDirName();
    }

    public void cancel() {
        this.shutdownThread = true;
    }

    public File[] loadFileStatus() {
        if (this.dirName == null) {
            return null;
        }
        File pdir = new File(this.dirName);
        File[] files = pdir.listFiles(this.polFileNameFilter);
        if (files == null || files.length == 0) {
            LOG.error("directory {} - {}", (Object)this.dirName, (Object)(pdir.exists() ? "does not have any files" : "does not exist"));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block8: {
            if (this.updLoader == null) {
                LOG.error("run: No ZpeUpdPolLoader to monitor");
                return;
            }
            if (this.shutdownThread) {
                LOG.warn("run: monitor told to shutdown");
                return;
            }
            ZpeUpdPolLoader.cleanupRoleTokenCache();
            ZpeUpdPolLoader.cleanupAccessTokenCache();
            if (ZpeUpdPolLoader.skipPolicyDirCheck) {
                return;
            }
            try {
                this.updLoader.loadDb(this.loadFileStatus());
                if (!this.firstRun) break block8;
                this.firstRun = false;
                ZpeUpdPolLoader zpeUpdPolLoader = this.updLoader;
                synchronized (zpeUpdPolLoader) {
                    this.updLoader.notify();
                }
            }
            catch (Exception ex) {
                LOG.error("run: load failure, directory name: {}", (Object)this.dirName, (Object)ex);
                return;
            }
        }
        LOG.debug("run: reload directory: {}", (Object)this.dirName);
    }
}

