/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe.pkey.file;

import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.common.config.AthenzConfig;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zpe.pkey.PublicKeyStore;
import com.yahoo.rdl.JSON;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePublicKeyStore
implements PublicKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(FilePublicKeyStore.class);
    private static final String ZPE_ATHENZ_CONFIG = "/conf/athenz/athenz.conf";
    private Map<String, PublicKey> ztsPublicKeyMap = new ConcurrentHashMap<String, PublicKey>();
    private Map<String, PublicKey> zmsPublicKeyMap = new ConcurrentHashMap<String, PublicKey>();

    public void init() {
        String rootDir = System.getenv("ROOT");
        if (rootDir == null) {
            rootDir = "/home/athenz";
        }
        String confFileName = System.getProperty("athenz.athenz_conf", rootDir + ZPE_ATHENZ_CONFIG);
        try {
            Path path = Paths.get(confFileName, new String[0]);
            AthenzConfig conf = (AthenzConfig)JSON.fromBytes((byte[])Files.readAllBytes(path), AthenzConfig.class);
            this.loadPublicKeys(conf.getZtsPublicKeys(), this.ztsPublicKeyMap);
            this.loadPublicKeys(conf.getZmsPublicKeys(), this.zmsPublicKeyMap);
        }
        catch (Exception ex) {
            LOG.error("Unable to extract ZMS Url from {} exc: {}", (Object)confFileName, (Object)ex.getMessage());
        }
    }

    void loadPublicKeys(ArrayList<PublicKeyEntry> publicKeys, Map<String, PublicKey> keyMap) {
        if (publicKeys == null) {
            return;
        }
        for (PublicKeyEntry publicKey : publicKeys) {
            PublicKey pubKey;
            String id = publicKey.getId();
            String key = publicKey.getKey();
            if (key == null || id == null) continue;
            try {
                pubKey = Crypto.loadPublicKey((String)Crypto.ybase64DecodeString((String)key));
            }
            catch (Exception e) {
                LOG.error("Invalid ZTS public key for id: {} - {}", (Object)id, (Object)e.getMessage());
                continue;
            }
            keyMap.put(id, pubKey);
        }
    }

    @Override
    public PublicKey getZtsKey(String keyId) {
        if (keyId == null) {
            return null;
        }
        return this.ztsPublicKeyMap.get(keyId);
    }

    @Override
    public PublicKey getZmsKey(String keyId) {
        if (keyId == null) {
            return null;
        }
        return this.zmsPublicKeyMap.get(keyId);
    }
}

