/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.athenz.zpe.pkey.file;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.yahoo.athenz.auth.token.jwts.Key;
import com.yahoo.athenz.auth.util.Crypto;
import com.yahoo.athenz.common.config.AthenzConfig;
import com.yahoo.athenz.zms.PublicKeyEntry;
import com.yahoo.athenz.zpe.pkey.PublicKeyStore;
import com.yahoo.athenz.zts.AthenzJWKConfig;
import com.yahoo.athenz.zts.JWK;
import com.yahoo.rdl.JSON;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePublicKeyStore
implements PublicKeyStore {
    private static final Logger LOG = LoggerFactory.getLogger(FilePublicKeyStore.class);
    private static final String ZPE_ATHENZ_CONFIG = "/conf/athenz/athenz.conf";
    private static final String ZPE_JWK_ATHENZ_CONFIG = "/var/lib/sia/athenz.conf";
    private Map<String, PublicKey> ztsPublicKeyMap = new ConcurrentHashMap<String, PublicKey>();
    private Map<String, PublicKey> zmsPublicKeyMap = new ConcurrentHashMap<String, PublicKey>();
    protected long millisBetweenReloadAthenzConfig;
    private long lastReloadAthenzConfigTime;

    public void init() {
        this.initAthenzConfig();
        this.initAthenzJWKConfig();
        if (this.ztsPublicKeyMap.size() == 0 && this.zmsPublicKeyMap.size() == 0) {
            LOG.error("Could not find any available public key");
        }
        this.millisBetweenReloadAthenzConfig = Long.parseLong(System.getProperty("athenz.zpe.millis_between_reload_config", Long.toString(1800000L)));
    }

    private void initAthenzConfig() {
        String rootDir = System.getenv("ROOT");
        if (rootDir == null) {
            rootDir = "/home/athenz";
        }
        String confFileName = System.getProperty("athenz.athenz_conf", rootDir + ZPE_ATHENZ_CONFIG);
        try {
            Path path = Paths.get(confFileName, new String[0]);
            AthenzConfig conf = (AthenzConfig)JSON.fromBytes((byte[])Files.readAllBytes(path), AthenzConfig.class);
            this.loadPublicKeys(conf.getZtsPublicKeys(), this.ztsPublicKeyMap);
            this.loadPublicKeys(conf.getZmsPublicKeys(), this.zmsPublicKeyMap);
        }
        catch (Exception ex) {
            LOG.warn("Unable to extract ZMS Url from {} exc: {}", (Object)confFileName, (Object)ex.getMessage());
        }
    }

    private void initAthenzJWKConfig() {
        String jwkConfFileName = System.getProperty("athenz.jwk_athenz_conf", ZPE_JWK_ATHENZ_CONFIG);
        try {
            Path path = Paths.get(jwkConfFileName, new String[0]);
            AthenzJWKConfig jwkConf = (AthenzJWKConfig)JSON.fromBytes((byte[])Files.readAllBytes(path), AthenzJWKConfig.class);
            this.loadJwkList(jwkConf.getZts().getKeys(), this.ztsPublicKeyMap);
            this.loadJwkList(jwkConf.getZms().getKeys(), this.zmsPublicKeyMap);
            this.lastReloadAthenzConfigTime = System.currentTimeMillis();
        }
        catch (Exception ex) {
            LOG.warn("Unable to extract athenz jwk config {} exc: {}", new Object[]{jwkConfFileName, ex.getMessage(), ex});
        }
    }

    private void loadJwkList(List<JWK> jwkList, Map<String, PublicKey> keysMap) {
        for (JWK jwk : jwkList) {
            try {
                PublicKey publicKey = this.jwkToPubKey(jwk);
                keysMap.put(jwk.kid, publicKey);
            }
            catch (Exception e) {
                LOG.warn("failed to load jwk id : {}, ex: {}", new Object[]{jwk.kid, e.getMessage(), e});
            }
        }
    }

    protected PublicKey jwkToPubKey(JWK jwk) throws NoSuchAlgorithmException, JsonProcessingException, InvalidKeySpecException, InvalidParameterSpecException {
        String jwkStr = JSON.string((Object)jwk);
        Key key = Key.fromString((String)jwkStr);
        return key.getPublicKey();
    }

    void loadPublicKeys(ArrayList<PublicKeyEntry> publicKeys, Map<String, PublicKey> keyMap) {
        if (publicKeys == null) {
            return;
        }
        for (PublicKeyEntry publicKey : publicKeys) {
            PublicKey pubKey;
            String id = publicKey.getId();
            String key = publicKey.getKey();
            if (key == null || id == null) continue;
            try {
                pubKey = Crypto.loadPublicKey((String)Crypto.ybase64DecodeString((String)key));
            }
            catch (Exception e) {
                LOG.error("Invalid ZTS public key for id: {} - {}", (Object)id, (Object)e.getMessage());
                continue;
            }
            keyMap.put(id, pubKey);
        }
    }

    @Override
    public PublicKey getZtsKey(String keyId) {
        return this.getPublicKey(keyId, this.ztsPublicKeyMap);
    }

    @Override
    public PublicKey getZmsKey(String keyId) {
        return this.getPublicKey(keyId, this.zmsPublicKeyMap);
    }

    private PublicKey getPublicKey(String keyId, Map<String, PublicKey> ztsPublicKeyMap) {
        if (keyId == null) {
            return null;
        }
        PublicKey publicKey = ztsPublicKeyMap.get(keyId);
        if (publicKey == null && this.canReloadAthenzConfig()) {
            LOG.debug("key id: {} does not exist in public keys map, reload athenz jwks from disk", (Object)keyId);
            this.initAthenzJWKConfig();
            publicKey = ztsPublicKeyMap.get(keyId);
        }
        return publicKey;
    }

    protected boolean canReloadAthenzConfig() {
        long now = System.currentTimeMillis();
        long millisDiff = now - this.lastReloadAthenzConfigTime;
        return millisDiff > this.millisBetweenReloadAthenzConfig;
    }
}

