/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.RequestScope;
import java.security.Principal;
import java.util.concurrent.Callable;

public abstract class AsyncAPIHook<T extends AsyncAPI>
implements LifeCycleHook<T> {
    private final AsyncExecutorService asyncExecutorService;
    private final Integer maxAsyncAfterSeconds;

    public AsyncAPIHook(AsyncExecutorService asyncExecutorService, Integer maxAsyncAfterSeconds) {
        this.asyncExecutorService = asyncExecutorService;
        this.maxAsyncAfterSeconds = maxAsyncAfterSeconds;
    }

    protected void validateOptions(AsyncAPI query, RequestScope requestScope) {
        if (query.getAsyncAfterSeconds() > this.maxAsyncAfterSeconds) {
            throw new InvalidValueException((Object)"Invalid Async After Seconds");
        }
    }

    protected void executeHook(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, AsyncAPI query, RequestScope requestScope, Callable<AsyncAPIResult> queryWorker) {
        if (operation.equals((Object)LifeCycleHookBinding.Operation.CREATE)) {
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.PREFLUSH)) {
                this.validateOptions(query, requestScope);
                this.executeAsync(query, queryWorker);
                return;
            }
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.POSTCOMMIT)) {
                this.completeAsync(query, requestScope);
                return;
            }
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.PRESECURITY)) {
                this.updatePrincipalName(query, requestScope);
                return;
            }
        }
        throw new InvalidOperationException("Invalid LifeCycle Hook Invocation");
    }

    protected void completeAsync(AsyncAPI query, RequestScope requestScope) {
        this.asyncExecutorService.completeQuery(query, requestScope.getUser(), requestScope.getApiVersion());
    }

    protected void executeAsync(AsyncAPI query, Callable<AsyncAPIResult> callable) {
        if (query.getStatus() == QueryStatus.QUEUED && query.getResult() == null) {
            this.asyncExecutorService.executeQuery(query, callable);
        }
    }

    protected void updatePrincipalName(AsyncAPI query, RequestScope requestScope) {
        Principal principal = requestScope.getUser().getPrincipal();
        if (principal != null) {
            query.setPrincipalName(principal.getName());
        }
    }

    public abstract Callable<AsyncAPIResult> getOperation(AsyncAPI var1, RequestScope var2);

    public AsyncExecutorService getAsyncExecutorService() {
        return this.asyncExecutorService;
    }

    public Integer getMaxAsyncAfterSeconds() {
        return this.maxAsyncAfterSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncAPIHook)) {
            return false;
        }
        AsyncAPIHook other = (AsyncAPIHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxAsyncAfterSeconds = this.getMaxAsyncAfterSeconds();
        Integer other$maxAsyncAfterSeconds = other.getMaxAsyncAfterSeconds();
        if (this$maxAsyncAfterSeconds == null ? other$maxAsyncAfterSeconds != null : !((Object)this$maxAsyncAfterSeconds).equals(other$maxAsyncAfterSeconds)) {
            return false;
        }
        AsyncExecutorService this$asyncExecutorService = this.getAsyncExecutorService();
        AsyncExecutorService other$asyncExecutorService = other.getAsyncExecutorService();
        return !(this$asyncExecutorService == null ? other$asyncExecutorService != null : !this$asyncExecutorService.equals(other$asyncExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncAPIHook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxAsyncAfterSeconds = this.getMaxAsyncAfterSeconds();
        result = result * 59 + ($maxAsyncAfterSeconds == null ? 43 : ((Object)$maxAsyncAfterSeconds).hashCode());
        AsyncExecutorService $asyncExecutorService = this.getAsyncExecutorService();
        result = result * 59 + ($asyncExecutorService == null ? 43 : $asyncExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncAPIHook(asyncExecutorService=" + this.getAsyncExecutorService() + ", maxAsyncAfterSeconds=" + this.getMaxAsyncAfterSeconds() + ")";
    }
}

