/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.hooks.AsyncAPIHook;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.QueryType;
import com.yahoo.elide.async.models.ResultType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.operation.GraphQLTableExportOperation;
import com.yahoo.elide.async.operation.JSONAPITableExportOperation;
import com.yahoo.elide.async.operation.TableExportOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;

public class TableExportHook
extends AsyncAPIHook<TableExport> {
    Map<ResultType, TableExportFormatter> supportedFormatters;
    ResultStorageEngine engine;

    public TableExportHook(AsyncExecutorService asyncExecutorService, Integer maxAsyncAfterSeconds, Map<ResultType, TableExportFormatter> supportedFormatters, ResultStorageEngine engine) {
        super(asyncExecutorService, maxAsyncAfterSeconds);
        this.supportedFormatters = supportedFormatters;
        this.engine = engine;
    }

    public void execute(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, TableExport export, RequestScope requestScope, Optional<ChangeSpec> changes) {
        Callable<AsyncAPIResult> callable = this.getOperation(export, requestScope);
        this.executeHook(operation, phase, export, requestScope, callable);
    }

    @Override
    public void validateOptions(AsyncAPI export, RequestScope requestScope) {
        super.validateOptions(export, requestScope);
    }

    @Override
    public Callable<AsyncAPIResult> getOperation(AsyncAPI export, RequestScope requestScope) {
        TableExportOperation operation = null;
        TableExport exportObj = (TableExport)export;
        ResultType resultType = exportObj.getResultType();
        QueryType queryType = exportObj.getQueryType();
        com.yahoo.elide.core.RequestScope scope = (com.yahoo.elide.core.RequestScope)requestScope;
        TableExportFormatter formatter = this.supportedFormatters.get((Object)resultType);
        if (formatter == null) {
            throw new InvalidOperationException("Formatter unavailable for " + resultType);
        }
        if (queryType.equals((Object)QueryType.GRAPHQL_V1_0)) {
            operation = new GraphQLTableExportOperation(formatter, this.getAsyncExecutorService(), export, scope, this.engine);
        } else if (queryType.equals((Object)QueryType.JSONAPI_V1_0)) {
            operation = new JSONAPITableExportOperation(formatter, this.getAsyncExecutorService(), export, scope, this.engine);
        } else {
            throw new InvalidOperationException(queryType + "is not supported");
        }
        return operation;
    }
}

