/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPIUpdateOperation
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AsyncAPIUpdateOperation.class);
    private Elide elide;
    private Future<AsyncAPIResult> task;
    private AsyncAPI queryObj;
    private AsyncAPIDAO asyncAPIDao;

    @Override
    public void run() {
        try {
            AsyncAPIResult queryResultObj = this.task.get();
            this.asyncAPIDao.updateAsyncAPIResult(queryResultObj, this.queryObj.getId(), this.queryObj.getClass());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("InterruptedException: {}", (Object)e.toString());
            this.asyncAPIDao.updateStatus(this.queryObj.getId(), QueryStatus.FAILURE, this.queryObj.getClass());
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            this.asyncAPIDao.updateStatus(this.queryObj.getId(), QueryStatus.FAILURE, this.queryObj.getClass());
        }
    }

    public Elide getElide() {
        return this.elide;
    }

    public Future<AsyncAPIResult> getTask() {
        return this.task;
    }

    public AsyncAPI getQueryObj() {
        return this.queryObj;
    }

    public AsyncAPIDAO getAsyncAPIDao() {
        return this.asyncAPIDao;
    }

    public void setElide(Elide elide) {
        this.elide = elide;
    }

    public void setTask(Future<AsyncAPIResult> task) {
        this.task = task;
    }

    public void setQueryObj(AsyncAPI queryObj) {
        this.queryObj = queryObj;
    }

    public void setAsyncAPIDao(AsyncAPIDAO asyncAPIDao) {
        this.asyncAPIDao = asyncAPIDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncAPIUpdateOperation)) {
            return false;
        }
        AsyncAPIUpdateOperation other = (AsyncAPIUpdateOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Elide this$elide = this.getElide();
        Elide other$elide = other.getElide();
        if (this$elide == null ? other$elide != null : !this$elide.equals(other$elide)) {
            return false;
        }
        Future<AsyncAPIResult> this$task = this.getTask();
        Future<AsyncAPIResult> other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        AsyncAPI this$queryObj = this.getQueryObj();
        AsyncAPI other$queryObj = other.getQueryObj();
        if (this$queryObj == null ? other$queryObj != null : !((Object)this$queryObj).equals(other$queryObj)) {
            return false;
        }
        AsyncAPIDAO this$asyncAPIDao = this.getAsyncAPIDao();
        AsyncAPIDAO other$asyncAPIDao = other.getAsyncAPIDao();
        return !(this$asyncAPIDao == null ? other$asyncAPIDao != null : !this$asyncAPIDao.equals(other$asyncAPIDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncAPIUpdateOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Elide $elide = this.getElide();
        result = result * 59 + ($elide == null ? 43 : $elide.hashCode());
        Future<AsyncAPIResult> $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        AsyncAPI $queryObj = this.getQueryObj();
        result = result * 59 + ($queryObj == null ? 43 : ((Object)$queryObj).hashCode());
        AsyncAPIDAO $asyncAPIDao = this.getAsyncAPIDao();
        result = result * 59 + ($asyncAPIDao == null ? 43 : $asyncAPIDao.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncAPIUpdateOperation(elide=" + this.getElide() + ", task=" + this.getTask() + ", queryObj=" + this.getQueryObj() + ", asyncAPIDao=" + this.getAsyncAPIDao() + ")";
    }

    public AsyncAPIUpdateOperation(Elide elide, Future<AsyncAPIResult> task, AsyncAPI queryObj, AsyncAPIDAO asyncAPIDao) {
        this.elide = elide;
        this.task = task;
        this.queryObj = queryObj;
        this.asyncAPIDao = asyncAPIDao;
    }
}

