/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.AsyncQueryResult;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncQueryOperation
implements Callable<AsyncAPIResult> {
    private static final Logger log = LoggerFactory.getLogger(AsyncQueryOperation.class);
    private AsyncExecutorService service;
    private AsyncQuery queryObj;
    private RequestScope scope;

    public AsyncQueryOperation(AsyncExecutorService service, AsyncAPI queryObj, RequestScope scope) {
        this.service = service;
        this.queryObj = (AsyncQuery)queryObj;
        this.scope = scope;
    }

    @Override
    public AsyncAPIResult call() throws URISyntaxException {
        ElideResponse response = null;
        log.debug("AsyncQuery Object from request: {}", (Object)this.queryObj);
        response = this.execute(this.queryObj, this.scope);
        this.nullResponseCheck(response);
        AsyncQueryResult queryResult = new AsyncQueryResult();
        queryResult.setHttpStatus(response.getResponseCode());
        queryResult.setCompletedOn(new Date());
        queryResult.setResponseBody(response.getBody());
        queryResult.setContentLength(response.getBody().length());
        if (response.getResponseCode() == 200) {
            queryResult.setRecordCount(this.calculateRecordCount(this.queryObj, response));
        }
        return queryResult;
    }

    public abstract Integer calculateRecordCount(AsyncQuery var1, ElideResponse var2);

    public void nullResponseCheck(ElideResponse response) {
        if (response == null) {
            throw new IllegalStateException("No Response for request returned");
        }
    }

    public abstract ElideResponse execute(AsyncAPI var1, RequestScope var2) throws URISyntaxException;

    public static Integer safeJsonPathLength(String json, String path) {
        Object result = JsonPath.read((String)json, (String)path, (Predicate[])new Predicate[0]);
        if (Integer.class.isAssignableFrom(result.getClass())) {
            return (Integer)result;
        }
        if (List.class.isAssignableFrom(result.getClass())) {
            List resultList = (List)result;
            Object object = result = resultList.isEmpty() ? Integer.valueOf(0) : resultList.get(0);
            if (Integer.class.isAssignableFrom(result.getClass())) {
                return (Integer)result;
            }
        }
        throw new IllegalStateException("Incompatible version of JSONPath");
    }

    public AsyncExecutorService getService() {
        return this.service;
    }
}

