/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.export.validator.SingleRootProjectionValidator;
import com.yahoo.elide.async.export.validator.Validator;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.FileExtensionType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.EntityProjection;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableExportOperation
implements Callable<AsyncAPIResult> {
    private static final Logger log = LoggerFactory.getLogger(TableExportOperation.class);
    private TableExportFormatter formatter;
    private AsyncExecutorService service;
    private Integer recordNumber = 0;
    private TableExport exportObj;
    private RequestScope scope;
    private ResultStorageEngine engine;
    private List<Validator> validators = new ArrayList<SingleRootProjectionValidator>(Arrays.asList(new SingleRootProjectionValidator()));

    public TableExportOperation(TableExportFormatter formatter, AsyncExecutorService service, AsyncAPI exportObj, RequestScope scope, ResultStorageEngine engine, List<Validator> validators) {
        this.formatter = formatter;
        this.service = service;
        this.exportObj = (TableExport)exportObj;
        this.scope = scope;
        this.engine = engine;
        this.validators.addAll(validators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncAPIResult call() {
        log.debug("TableExport Object from request: {}", (Object)this.exportObj);
        Elide elide = this.service.getElide();
        TableExportResult exportResult = new TableExportResult();
        UUID requestId = UUID.fromString(this.exportObj.getRequestId());
        try (DataStoreTransaction tx = elide.getDataStore().beginTransaction();){
            Observable<String> interimResults;
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
            requestHeaders.put("bypasscache", new ArrayList<String>(Arrays.asList("true")));
            RequestScope requestScope = this.getRequestScope(this.exportObj, this.scope, tx, requestHeaders);
            Collection<EntityProjection> projections = this.getProjections(this.exportObj, requestScope);
            this.validateProjections(projections);
            EntityProjection projection = projections.iterator().next();
            Observable observableResults = Observable.empty();
            elide.getTransactionRegistry().addRunningTransaction(requestId, tx);
            requestScope.setEntityProjection(projection);
            if (projection != null) {
                projection.setPagination(null);
                observableResults = PersistentResource.loadRecords((EntityProjection)projection, Collections.emptyList(), (RequestScope)requestScope);
            }
            Observable results = Observable.empty();
            String preResult = this.formatter.preFormat(projection, this.exportObj);
            results = observableResults.map(resource -> {
                Integer n = this.recordNumber;
                Integer n2 = this.recordNumber = Integer.valueOf(this.recordNumber + 1);
                return this.formatter.format((PersistentResource)resource, this.recordNumber);
            });
            String postResult = this.formatter.postFormat(projection, this.exportObj);
            Observable<String> finalResults = this.concatStringWithObservable(postResult, interimResults = this.concatStringWithObservable(preResult, (Observable<String>)results, true), false);
            TableExportResult result = this.storeResults(this.exportObj, this.engine, finalResults);
            if (result != null && result.getMessage() != null) {
                throw new IllegalStateException(result.getMessage());
            }
            exportResult.setUrl(new URL(this.generateDownloadURL(this.exportObj, this.scope)));
            exportResult.setRecordCount(this.recordNumber);
            tx.flush(requestScope);
            elide.getAuditLogger().commit();
            tx.commit(requestScope);
        }
        catch (BadRequestException e) {
            exportResult.setMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            exportResult.setMessage("Download url generation failure.");
        }
        catch (IOException e) {
            log.error("IOException during TableExport", (Throwable)e);
            exportResult.setMessage(e.getMessage());
        }
        catch (Exception e) {
            exportResult.setMessage(e.getMessage());
        }
        finally {
            exportResult.setHttpStatus(200);
            exportResult.setCompletedOn(new Date());
            elide.getTransactionRegistry().removeRunningTransaction(requestId);
            elide.getAuditLogger().clear();
        }
        return exportResult;
    }

    private Observable<String> concatStringWithObservable(String toConcat, Observable<String> observable, boolean stringFirst) {
        if (toConcat == null) {
            return observable;
        }
        return stringFirst ? Observable.just((Object)toConcat).concatWith(observable) : observable.concatWith((ObservableSource)Observable.just((Object)toConcat));
    }

    public abstract RequestScope getRequestScope(TableExport var1, RequestScope var2, DataStoreTransaction var3, Map<String, List<String>> var4);

    public String generateDownloadURL(TableExport exportObj, RequestScope scope) {
        String downloadPath = scope.getElideSettings().getExportApiPath();
        String baseURL = scope.getBaseUrlEndPoint();
        String extension = this.engine.isExtensionEnabled() ? exportObj.getResultType().getFileExtensionType().getExtension() : FileExtensionType.NONE.getExtension();
        return baseURL + downloadPath + "/" + exportObj.getId() + extension;
    }

    protected TableExportResult storeResults(TableExport exportObj, ResultStorageEngine resultStorageEngine, Observable<String> result) {
        return resultStorageEngine.storeResults(exportObj, result);
    }

    private void validateProjections(Collection<EntityProjection> projections) {
        this.validators.forEach(validator -> validator.validateProjection(projections));
    }

    public abstract Collection<EntityProjection> getProjections(TableExport var1, RequestScope var2);

    public AsyncExecutorService getService() {
        return this.service;
    }
}

