/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.service.DateUtil;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.async.service.thread.AsyncAPICancelRunnable;
import com.yahoo.elide.async.service.thread.AsyncAPICleanerRunnable;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCleanerService {
    private static final Logger log = LoggerFactory.getLogger(AsyncCleanerService.class);
    private final int defaultCleanupDelayMinutes = 120;
    private final int maxInitialDelayMinutes = 100;
    private static AsyncCleanerService asyncCleanerService = null;

    @Inject
    private AsyncCleanerService(Elide elide, Integer maxRunTimeSeconds, Integer queryCleanupDays, Integer cancelDelaySeconds, AsyncAPIDAO asyncQueryDao) {
        int queryRunTimeThresholdMinutes = (int)TimeUnit.SECONDS.toMinutes((long)(maxRunTimeSeconds * 2) + 30L);
        ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor();
        AsyncAPICleanerRunnable cleanUpTask = new AsyncAPICleanerRunnable(queryRunTimeThresholdMinutes, elide, queryCleanupDays, asyncQueryDao, new DateUtil());
        Random random = new Random();
        int initialDelayMinutes = random.ints(0, 100).limit(1L).findFirst().getAsInt();
        log.debug("Initial Delay for cleaner service is {}", (Object)initialDelayMinutes);
        cleaner.scheduleWithFixedDelay(cleanUpTask, initialDelayMinutes, Math.max(120, queryRunTimeThresholdMinutes), TimeUnit.MINUTES);
        ScheduledExecutorService cancellation = Executors.newSingleThreadScheduledExecutor();
        AsyncAPICancelRunnable cancelTask = new AsyncAPICancelRunnable(maxRunTimeSeconds, elide, asyncQueryDao);
        cancellation.scheduleWithFixedDelay(cancelTask, 0L, cancelDelaySeconds.intValue(), TimeUnit.SECONDS);
    }

    public static void init(Elide elide, Integer maxRunTimeSeconds, Integer queryCleanupDays, Integer cancelDelaySeconds, AsyncAPIDAO asyncQueryDao) {
        if (asyncCleanerService == null) {
            asyncCleanerService = new AsyncCleanerService(elide, maxRunTimeSeconds, queryCleanupDays, cancelDelaySeconds, asyncQueryDao);
        } else {
            log.debug("asyncCleanerService is already initialized.");
        }
    }

    public static synchronized AsyncCleanerService getInstance() {
        return asyncCleanerService;
    }
}

