/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.operation.AsyncAPIUpdateOperation;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutorService {
    private static final Logger log = LoggerFactory.getLogger(AsyncExecutorService.class);
    public static final int DEFAULT_THREAD_POOL_SIZE = 6;
    private Elide elide;
    private Map<String, QueryRunner> runners;
    private ExecutorService executor;
    private ExecutorService updater;
    private AsyncAPIDAO asyncAPIDao;
    private ThreadLocal<AsyncAPIResultFuture> asyncResultFutureThreadLocal = new ThreadLocal();

    @Inject
    public AsyncExecutorService(Elide elide, ExecutorService executor, ExecutorService updater, AsyncAPIDAO asyncAPIDao) {
        this.elide = elide;
        this.runners = new HashMap<String, QueryRunner>();
        for (String apiVersion : elide.getElideSettings().getDictionary().getApiVersions()) {
            this.runners.put(apiVersion, new QueryRunner(elide, apiVersion));
        }
        this.executor = executor;
        this.updater = updater;
        this.asyncAPIDao = asyncAPIDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(AsyncAPI queryObj, Callable<AsyncAPIResult> callable) {
        AsyncAPIResultFuture resultFuture = new AsyncAPIResultFuture();
        try {
            Future<AsyncAPIResult> asyncExecuteFuture = this.executor.submit(callable);
            resultFuture.setAsyncFuture(asyncExecuteFuture);
            queryObj.setStatus(QueryStatus.PROCESSING);
            AsyncAPIResult queryResultObj = asyncExecuteFuture.get(queryObj.getAsyncAfterSeconds().intValue(), TimeUnit.SECONDS);
            queryObj.setResult(queryResultObj);
            queryObj.setStatus(QueryStatus.COMPLETE);
            queryObj.setUpdatedOn(new Date());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("InterruptedException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (ExecutionException e) {
            log.error("ExecutionException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (TimeoutException e) {
            log.error("TimeoutException: {}", (Object)e.toString());
            resultFuture.setSynchronousTimeout(true);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        finally {
            this.asyncResultFutureThreadLocal.set(resultFuture);
        }
    }

    public void completeQuery(AsyncAPI query, User user, String apiVersion) {
        AsyncAPIResultFuture asyncAPIResultFuture = this.asyncResultFutureThreadLocal.get();
        if (asyncAPIResultFuture.isSynchronousTimeout()) {
            log.debug("Task has not completed");
            this.updater.execute(new AsyncAPIUpdateOperation(this.elide, asyncAPIResultFuture.getAsyncFuture(), query, this.asyncAPIDao));
            this.asyncResultFutureThreadLocal.remove();
        } else {
            log.debug("Task has completed");
        }
    }

    public Elide getElide() {
        return this.elide;
    }

    public Map<String, QueryRunner> getRunners() {
        return this.runners;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getUpdater() {
        return this.updater;
    }

    public AsyncAPIDAO getAsyncAPIDao() {
        return this.asyncAPIDao;
    }

    public ThreadLocal<AsyncAPIResultFuture> getAsyncResultFutureThreadLocal() {
        return this.asyncResultFutureThreadLocal;
    }

    private static class AsyncAPIResultFuture {
        private Future<AsyncAPIResult> asyncFuture;
        private boolean synchronousTimeout = false;

        public Future<AsyncAPIResult> getAsyncFuture() {
            return this.asyncFuture;
        }

        public boolean isSynchronousTimeout() {
            return this.synchronousTimeout;
        }

        public void setAsyncFuture(Future<AsyncAPIResult> asyncFuture) {
            this.asyncFuture = asyncFuture;
        }

        public void setSynchronousTimeout(boolean synchronousTimeout) {
            this.synchronousTimeout = synchronousTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncAPIResultFuture)) {
                return false;
            }
            AsyncAPIResultFuture other = (AsyncAPIResultFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSynchronousTimeout() != other.isSynchronousTimeout()) {
                return false;
            }
            Future<AsyncAPIResult> this$asyncFuture = this.getAsyncFuture();
            Future<AsyncAPIResult> other$asyncFuture = other.getAsyncFuture();
            return !(this$asyncFuture == null ? other$asyncFuture != null : !this$asyncFuture.equals(other$asyncFuture));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsyncAPIResultFuture;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSynchronousTimeout() ? 79 : 97);
            Future<AsyncAPIResult> $asyncFuture = this.getAsyncFuture();
            result = result * 59 + ($asyncFuture == null ? 43 : $asyncFuture.hashCode());
            return result;
        }

        public String toString() {
            return "AsyncExecutorService.AsyncAPIResultFuture(asyncFuture=" + this.getAsyncFuture() + ", synchronousTimeout=" + this.isSynchronousTimeout() + ")";
        }
    }
}

