/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.dao;

import com.yahoo.elide.ElideSettings;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncAPIResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.async.service.dao.Transactional;
import com.yahoo.elide.async.service.dao.UpdateQuery;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStore;
import com.yahoo.elide.core.datastore.DataStoreIterable;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import javax.inject.Singleton;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAsyncAPIDAO
implements AsyncAPIDAO {
    private static final Logger log = LoggerFactory.getLogger(DefaultAsyncAPIDAO.class);
    private ElideSettings elideSettings;
    private DataStore dataStore;

    public DefaultAsyncAPIDAO() {
    }

    public DefaultAsyncAPIDAO(ElideSettings elideSettings, DataStore dataStore) {
        this.elideSettings = elideSettings;
        this.dataStore = dataStore;
    }

    @Override
    public <T extends AsyncAPI> T updateStatus(String asyncAPIId, QueryStatus status, Class<T> type) {
        AsyncAPI queryObj = (AsyncAPI)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncAPIIterable = EntityProjection.builder().type(type).build();
            AsyncAPI query = (AsyncAPI)tx.loadObject(asyncAPIIterable, (Serializable)((Object)asyncAPIId), scope);
            query.setStatus(status);
            tx.save((Object)query, scope);
            return query;
        });
        return (T)queryObj;
    }

    @Override
    public <T extends AsyncAPI> Iterable<T> updateStatusAsyncAPIByFilter(FilterExpression filterExpression, QueryStatus status, Class<T> type) {
        return this.updateAsyncAPIIterable(filterExpression, asyncAPI -> asyncAPI.setStatus(status), type);
    }

    private <T extends AsyncAPI> Iterable<T> updateAsyncAPIIterable(FilterExpression filterExpression, UpdateQuery updateFunction, Class<T> type) {
        log.debug("updateAsyncAPIIterable");
        Iterable asyncAPIList = null;
        asyncAPIList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncAPIIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
            DataStoreIterable loaded = tx.loadObjects(asyncAPIIterable, scope);
            for (AsyncAPI query : loaded) {
                updateFunction.update(query);
                tx.save((Object)query, scope);
            }
            return loaded;
        });
        return asyncAPIList;
    }

    @Override
    public <T extends AsyncAPI> Iterable<T> deleteAsyncAPIAndResultByFilter(FilterExpression filterExpression, Class<T> type) {
        log.debug("deleteAsyncAPIAndResultByFilter");
        Iterable asyncAPIList = null;
        asyncAPIList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncAPIIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
            DataStoreIterable loaded = tx.loadObjects(asyncAPIIterable, scope);
            for (AsyncAPI query : loaded) {
                if (query == null) continue;
                tx.delete((Object)query, scope);
            }
            return loaded;
        });
        return asyncAPIList;
    }

    @Override
    public <T extends AsyncAPI> T updateAsyncAPIResult(AsyncAPIResult asyncAPIResult, String asyncAPIId, Class<T> type) {
        log.debug("updateAsyncAPIResult");
        AsyncAPI queryObj = (AsyncAPI)this.executeInTransaction(this.dataStore, (tx, scope) -> {
            EntityProjection asyncAPIIterable = EntityProjection.builder().type(type).build();
            AsyncAPI query = (AsyncAPI)tx.loadObject(asyncAPIIterable, (Serializable)((Object)asyncAPIId), scope);
            query.setResult(asyncAPIResult);
            if (query.getStatus().equals((Object)QueryStatus.CANCELLED)) {
                query.setStatus(QueryStatus.CANCEL_COMPLETE);
            } else if (!query.getStatus().equals((Object)QueryStatus.CANCEL_COMPLETE)) {
                query.setStatus(QueryStatus.COMPLETE);
            }
            tx.save((Object)query, scope);
            return query;
        });
        return (T)queryObj;
    }

    protected Object executeInTransaction(DataStore dataStore, Transactional action) {
        log.debug("executeInTransaction");
        Object result = null;
        try (DataStoreTransaction tx = dataStore.beginTransaction();){
            JsonApiDocument jsonApiDoc = new JsonApiDocument();
            MultivaluedHashMap queryParams = new MultivaluedHashMap();
            RequestScope scope = new RequestScope("", "query", "", jsonApiDoc, tx, null, (MultivaluedMap)queryParams, Collections.emptyMap(), UUID.randomUUID(), this.elideSettings);
            result = action.execute(tx, scope);
            tx.flush(scope);
            tx.commit(scope);
        }
        catch (IOException e) {
            log.error("IOException: {}", (Object)e.toString());
            throw new IllegalStateException(e);
        }
        return result;
    }

    @Override
    public <T extends AsyncAPI> Iterable<T> loadAsyncAPIByFilter(FilterExpression filterExpression, Class<T> type) {
        Iterable asyncAPIList = null;
        log.debug("loadAsyncAPIByFilter");
        try {
            asyncAPIList = (Iterable)this.executeInTransaction(this.dataStore, (tx, scope) -> {
                EntityProjection asyncAPIIterable = EntityProjection.builder().type(type).filterExpression(filterExpression).build();
                return tx.loadObjects(asyncAPIIterable, scope);
            });
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            throw new IllegalStateException(e);
        }
        return asyncAPIList;
    }

    public ElideSettings getElideSettings() {
        return this.elideSettings;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public void setElideSettings(ElideSettings elideSettings) {
        this.elideSettings = elideSettings;
    }

    public void setDataStore(DataStore dataStore) {
        this.dataStore = dataStore;
    }
}

