/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.thread;

import com.google.common.collect.Sets;
import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.TransactionRegistry;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.jsonapi.models.JsonApiDocument;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPICancelRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AsyncAPICancelRunnable.class);
    private int maxRunTimeSeconds;
    private Elide elide;
    private AsyncAPIDAO asyncAPIDao;

    @Override
    public void run() {
        this.cancelAsyncAPI(AsyncQuery.class);
    }

    protected <T extends AsyncAPI> void cancelAsyncAPI(Class<T> type) {
        try {
            TransactionRegistry transactionRegistry = this.elide.getTransactionRegistry();
            Map runningTransactionMap = transactionRegistry.getRunningTransactions();
            Set runningTransactionUUIDs = runningTransactionMap.keySet();
            Path.PathElement statusPathElement = new Path.PathElement(type, QueryStatus.class, "status");
            InPredicate fltStatusExpression = new InPredicate(statusPathElement, (Object[])new QueryStatus[]{QueryStatus.CANCELLED, QueryStatus.PROCESSING, QueryStatus.QUEUED});
            Iterable asyncAPIIterable = this.asyncAPIDao.loadAsyncAPIByFilter((FilterExpression)fltStatusExpression, type);
            Set asyncTransactionUUIDs = StreamSupport.stream(asyncAPIIterable.spliterator(), false).filter(query -> query.getStatus() == QueryStatus.CANCELLED || TimeUnit.SECONDS.convert(Math.abs(new Date(System.currentTimeMillis()).getTime() - query.getCreatedOn().getTime()), TimeUnit.MILLISECONDS) > (long)this.maxRunTimeSeconds).map(query -> UUID.fromString(query.getRequestId())).collect(Collectors.toSet());
            Sets.SetView queryUUIDsToCancel = Sets.intersection(runningTransactionUUIDs, asyncTransactionUUIDs);
            Set queryIDsToCancel = queryUUIDsToCancel.stream().map(uuid -> StreamSupport.stream(asyncAPIIterable.spliterator(), false).filter(query -> query.getRequestId().equals(uuid.toString())).map(AsyncAPI::getId).findFirst().orElseThrow(IllegalStateException::new)).collect(Collectors.toSet());
            queryUUIDsToCancel.stream().forEach(uuid -> {
                DataStoreTransaction runningTransaction = transactionRegistry.getRunningTransaction(uuid);
                if (runningTransaction != null) {
                    JsonApiDocument jsonApiDoc = new JsonApiDocument();
                    MultivaluedHashMap queryParams = new MultivaluedHashMap();
                    RequestScope scope = new RequestScope("", "query", "", jsonApiDoc, runningTransaction, null, (MultivaluedMap)queryParams, Collections.emptyMap(), uuid, this.elide.getElideSettings());
                    runningTransaction.cancel(scope);
                }
            });
            if (!queryIDsToCancel.isEmpty()) {
                Path.PathElement idPathElement = new Path.PathElement(type, String.class, "id");
                InPredicate fltIdExpression = new InPredicate(idPathElement, (Object[])new Set[]{queryIDsToCancel});
                this.asyncAPIDao.updateStatusAsyncAPIByFilter((FilterExpression)fltIdExpression, QueryStatus.CANCEL_COMPLETE, type);
            }
        }
        catch (Exception e) {
            log.error("Exception in scheduled cancellation: {}", (Object)e.toString());
        }
    }

    public int getMaxRunTimeSeconds() {
        return this.maxRunTimeSeconds;
    }

    public Elide getElide() {
        return this.elide;
    }

    public AsyncAPIDAO getAsyncAPIDao() {
        return this.asyncAPIDao;
    }

    public void setMaxRunTimeSeconds(int maxRunTimeSeconds) {
        this.maxRunTimeSeconds = maxRunTimeSeconds;
    }

    public void setElide(Elide elide) {
        this.elide = elide;
    }

    public void setAsyncAPIDao(AsyncAPIDAO asyncAPIDao) {
        this.asyncAPIDao = asyncAPIDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncAPICancelRunnable)) {
            return false;
        }
        AsyncAPICancelRunnable other = (AsyncAPICancelRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRunTimeSeconds() != other.getMaxRunTimeSeconds()) {
            return false;
        }
        Elide this$elide = this.getElide();
        Elide other$elide = other.getElide();
        if (this$elide == null ? other$elide != null : !this$elide.equals(other$elide)) {
            return false;
        }
        AsyncAPIDAO this$asyncAPIDao = this.getAsyncAPIDao();
        AsyncAPIDAO other$asyncAPIDao = other.getAsyncAPIDao();
        return !(this$asyncAPIDao == null ? other$asyncAPIDao != null : !this$asyncAPIDao.equals(other$asyncAPIDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncAPICancelRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRunTimeSeconds();
        Elide $elide = this.getElide();
        result = result * 59 + ($elide == null ? 43 : $elide.hashCode());
        AsyncAPIDAO $asyncAPIDao = this.getAsyncAPIDao();
        result = result * 59 + ($asyncAPIDao == null ? 43 : $asyncAPIDao.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncAPICancelRunnable(maxRunTimeSeconds=" + this.getMaxRunTimeSeconds() + ", elide=" + this.getElide() + ", asyncAPIDao=" + this.getAsyncAPIDao() + ")";
    }

    public AsyncAPICancelRunnable(int maxRunTimeSeconds, Elide elide, AsyncAPIDAO asyncAPIDao) {
        this.maxRunTimeSeconds = maxRunTimeSeconds;
        this.elide = elide;
        this.asyncAPIDao = asyncAPIDao;
    }
}

