/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.thread;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncAPI;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.DateUtil;
import com.yahoo.elide.async.service.dao.AsyncAPIDAO;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.filter.predicates.LEPredicate;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPICleanerRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AsyncAPICleanerRunnable.class);
    private int maxRunTimeMinutes;
    private Elide elide;
    private int queryCleanupDays;
    private AsyncAPIDAO asyncAPIDao;
    private DateUtil dateUtil = new DateUtil();

    @Override
    public void run() {
        this.deleteAsyncAPI(AsyncQuery.class);
        this.timeoutAsyncAPI(AsyncQuery.class);
    }

    protected <T extends AsyncAPI> void deleteAsyncAPI(Class<T> type) {
        try {
            Date cleanupDate = this.dateUtil.calculateFilterDate(5, this.queryCleanupDays);
            Path.PathElement createdOnPathElement = new Path.PathElement(type, Long.class, "createdOn");
            LEPredicate fltDeleteExp = new LEPredicate(createdOnPathElement, (Object)cleanupDate);
            this.asyncAPIDao.deleteAsyncAPIAndResultByFilter((FilterExpression)fltDeleteExp, type);
        }
        catch (Exception e) {
            log.error("Exception in scheduled cleanup: {}", (Object)e.toString());
        }
    }

    protected <T extends AsyncAPI> void timeoutAsyncAPI(Class<T> type) {
        try {
            Date filterDate = this.dateUtil.calculateFilterDate(12, this.maxRunTimeMinutes);
            Path.PathElement createdOnPathElement = new Path.PathElement(type, Long.class, "createdOn");
            Path.PathElement statusPathElement = new Path.PathElement(type, String.class, "status");
            InPredicate inPredicate = new InPredicate(statusPathElement, (Object[])new QueryStatus[]{QueryStatus.PROCESSING, QueryStatus.QUEUED});
            LEPredicate lePredicate = new LEPredicate(createdOnPathElement, (Object)filterDate);
            AndFilterExpression fltTimeoutExp = new AndFilterExpression((FilterExpression)inPredicate, (FilterExpression)lePredicate);
            this.asyncAPIDao.updateStatusAsyncAPIByFilter((FilterExpression)fltTimeoutExp, QueryStatus.TIMEDOUT, type);
        }
        catch (Exception e) {
            log.error("Exception in scheduled cleanup: {}", (Object)e.toString());
        }
    }

    public int getMaxRunTimeMinutes() {
        return this.maxRunTimeMinutes;
    }

    public Elide getElide() {
        return this.elide;
    }

    public int getQueryCleanupDays() {
        return this.queryCleanupDays;
    }

    public AsyncAPIDAO getAsyncAPIDao() {
        return this.asyncAPIDao;
    }

    public DateUtil getDateUtil() {
        return this.dateUtil;
    }

    public void setMaxRunTimeMinutes(int maxRunTimeMinutes) {
        this.maxRunTimeMinutes = maxRunTimeMinutes;
    }

    public void setElide(Elide elide) {
        this.elide = elide;
    }

    public void setQueryCleanupDays(int queryCleanupDays) {
        this.queryCleanupDays = queryCleanupDays;
    }

    public void setAsyncAPIDao(AsyncAPIDAO asyncAPIDao) {
        this.asyncAPIDao = asyncAPIDao;
    }

    public void setDateUtil(DateUtil dateUtil) {
        this.dateUtil = dateUtil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncAPICleanerRunnable)) {
            return false;
        }
        AsyncAPICleanerRunnable other = (AsyncAPICleanerRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRunTimeMinutes() != other.getMaxRunTimeMinutes()) {
            return false;
        }
        if (this.getQueryCleanupDays() != other.getQueryCleanupDays()) {
            return false;
        }
        Elide this$elide = this.getElide();
        Elide other$elide = other.getElide();
        if (this$elide == null ? other$elide != null : !this$elide.equals(other$elide)) {
            return false;
        }
        AsyncAPIDAO this$asyncAPIDao = this.getAsyncAPIDao();
        AsyncAPIDAO other$asyncAPIDao = other.getAsyncAPIDao();
        if (this$asyncAPIDao == null ? other$asyncAPIDao != null : !this$asyncAPIDao.equals(other$asyncAPIDao)) {
            return false;
        }
        DateUtil this$dateUtil = this.getDateUtil();
        DateUtil other$dateUtil = other.getDateUtil();
        return !(this$dateUtil == null ? other$dateUtil != null : !this$dateUtil.equals(other$dateUtil));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncAPICleanerRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRunTimeMinutes();
        result = result * 59 + this.getQueryCleanupDays();
        Elide $elide = this.getElide();
        result = result * 59 + ($elide == null ? 43 : $elide.hashCode());
        AsyncAPIDAO $asyncAPIDao = this.getAsyncAPIDao();
        result = result * 59 + ($asyncAPIDao == null ? 43 : $asyncAPIDao.hashCode());
        DateUtil $dateUtil = this.getDateUtil();
        result = result * 59 + ($dateUtil == null ? 43 : $dateUtil.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncAPICleanerRunnable(maxRunTimeMinutes=" + this.getMaxRunTimeMinutes() + ", elide=" + this.getElide() + ", queryCleanupDays=" + this.getQueryCleanupDays() + ", asyncAPIDao=" + this.getAsyncAPIDao() + ", dateUtil=" + this.getDateUtil() + ")";
    }

    public AsyncAPICleanerRunnable(int maxRunTimeMinutes, Elide elide, int queryCleanupDays, AsyncAPIDAO asyncAPIDao, DateUtil dateUtil) {
        this.maxRunTimeMinutes = maxRunTimeMinutes;
        this.elide = elide;
        this.queryCleanupDays = queryCleanupDays;
        this.asyncAPIDao = asyncAPIDao;
        this.dateUtil = dateUtil;
    }
}

