/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.request.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Attributes {
    public static Map<String, Object> getProperties(ObjectMapper objectMapper, Collection<? extends Attribute> attributes) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (attributes != null) {
            for (Attribute attribute : attributes) {
                String name = attribute.getName();
                Map<String, Object> properties = null;
                Class attributeClass = attribute.getType().getUnderlyingClass().orElse(null);
                if (attributeClass != null) {
                    properties = Attributes.getProperties(objectMapper, attributeClass);
                }
                result.put(name, properties);
            }
        }
        return result;
    }

    public static Map<String, Object> getProperties(ObjectMapper objectMapper, Class<?> propertyClass) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        try {
            Iterator iterator = objectMapper.getSerializerProviderInstance().findValueSerializer(propertyClass).properties();
            while (iterator.hasNext()) {
                PropertyWriter property = (PropertyWriter)iterator.next();
                result.put(property.getName(), Attributes.getProperties(objectMapper, property.getType().getRawClass()));
            }
        }
        catch (JsonMappingException jsonMappingException) {
            // empty catch block
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static String getArguments(Attribute attribute) {
        if (attribute.getArguments() == null || attribute.getArguments().size() == 0) {
            return "";
        }
        StringBuilder arguments = new StringBuilder();
        arguments.append("(");
        arguments.append(attribute.getArguments().stream().map(arg -> arg.getName() + "=" + arg.getValue()).collect(Collectors.joining(" ")));
        arguments.append(")");
        return arguments.toString();
    }

    public static Map<String, Object> getAttributes(PersistentResource<?> resource, boolean useAlias) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        Set attrFields = resource.getRequestScope().getEntityProjection().getAttributes();
        for (Attribute field : attrFields) {
            String fieldName = field.getName();
            if (useAlias) {
                String alias = field.getAlias();
                fieldName = StringUtils.isNotEmpty((CharSequence)alias) ? alias : field.getName();
            }
            attributes.put(fieldName, resource.getAttribute(field));
        }
        return attributes;
    }

    public static Map<String, Object> getAttributes(PersistentResource<?> resource) {
        return Attributes.getAttributes(resource, false);
    }

    public static List<List<String>> getHeaders(ObjectMapper objectMapper, Collection<? extends Attribute> attributes) {
        Map<String, Object> properties = Attributes.getProperties(objectMapper, attributes);
        return Attributes.getHeaders(properties);
    }

    public static List<List<String>> getHeaders(Map<String, Object> properties) {
        ArrayList<List<String>> headers = new ArrayList<List<String>>();
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Attributes.getHeaders(headers, property, null);
        }
        return headers;
    }

    public static void getHeaders(List<List<String>> result, Map.Entry<String, Object> property, List<String> prefix) {
        String header = property.getKey();
        if (property.getValue() instanceof Map) {
            Map values = (Map)property.getValue();
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                ArrayList<String> value = prefix != null ? new ArrayList<String>(prefix) : new ArrayList();
                value.add(header);
                Attributes.getHeaders(result, entry, value);
            }
        } else {
            ArrayList<String> value = prefix != null ? new ArrayList<String>(prefix) : new ArrayList();
            value.add(header);
            result.add(value);
        }
    }
}

