/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.async.export.formatter.Attributes;
import com.yahoo.elide.async.export.formatter.ResourceWriterSupport;
import com.yahoo.elide.core.PersistentResource;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResourceWriter
extends ResourceWriterSupport {
    private static final Logger log = LoggerFactory.getLogger(JsonResourceWriter.class);
    protected static final String COMMA = ",";
    protected final ObjectMapper objectMapper;
    protected int recordCount = 0;

    public JsonResourceWriter(OutputStream outputStream, ObjectMapper objectMapper) {
        super(outputStream);
        this.objectMapper = objectMapper;
    }

    @Override
    public void write(PersistentResource<?> resource) throws IOException {
        if (this.recordCount == 0) {
            this.preFormat(this.outputStream);
        }
        ++this.recordCount;
        this.format(resource, this.outputStream);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.recordCount == 0) {
                this.preFormat(this.outputStream);
            }
            this.postFormat(this.outputStream);
            super.close();
            this.closed = true;
        }
    }

    public void format(PersistentResource<?> resource, OutputStream outputStream) throws IOException {
        if (resource == null) {
            return;
        }
        StringBuilder str = new StringBuilder();
        if (this.recordCount > 1) {
            str.append(COMMA);
        }
        str.append(this.convert(this.objectMapper, resource));
        str.append('\n');
        this.write(str.toString());
    }

    protected String convert(ObjectMapper mapper, PersistentResource<?> resource) {
        if (resource == null || resource.getObject() == null) {
            return null;
        }
        return this.convert(mapper, this.getAttributes(resource));
    }

    protected String convert(ObjectMapper mapper, Map<String, Object> attributes) {
        try {
            return mapper.writeValueAsString(attributes);
        }
        catch (JsonProcessingException e) {
            log.error("Exception when converting to JSON {}", (Object)e.getMessage());
            throw new IllegalStateException(e);
        }
    }

    protected Map<String, Object> getAttributes(PersistentResource<?> resource) {
        return Attributes.getAttributes(resource, true);
    }

    public void preFormat(OutputStream outputStream) throws IOException {
        outputStream.write("[\n".getBytes(StandardCharsets.UTF_8));
    }

    public void postFormat(OutputStream outputStream) throws IOException {
        outputStream.write("]\n".getBytes(StandardCharsets.UTF_8));
    }
}

