/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.async.export.formatter.Attributes;
import com.yahoo.elide.async.export.formatter.ResourceWriterSupport;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.utils.ObjectProperties;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class XlsxResourceWriter
extends ResourceWriterSupport {
    protected static final String DEFAULT_HEADER_SEPARATOR = "_";
    protected final boolean writeHeader;
    protected final EntityProjection entityProjection;
    protected final SXSSFWorkbook workbook;
    protected final List<List<String>> headers;
    protected final Map<String, Attribute> attributes;
    protected SXSSFSheet sheet;
    protected int recordCount = 0;
    protected int rowCount = 0;
    protected String localDateFormat = "d/m/yyyy";
    protected String localDateTimeFormat = "d/m/yyyy h:mm:ss";
    protected String dateFormat = "d/m/yyyy h:mm:ss";
    protected String headerSeparator = "_";

    public XlsxResourceWriter(OutputStream outputStream, ObjectMapper objectMapper, boolean writeHeader, EntityProjection entityProjection) {
        this(outputStream, objectMapper, writeHeader, entityProjection, 100);
    }

    public XlsxResourceWriter(OutputStream outputStream, ObjectMapper objectMapper, boolean writeHeader, EntityProjection entityProjection, int rowAccessWindowSize) {
        super(outputStream);
        this.writeHeader = writeHeader;
        this.entityProjection = entityProjection;
        this.workbook = new SXSSFWorkbook(rowAccessWindowSize);
        this.sheet = this.workbook.createSheet();
        this.headers = entityProjection != null ? Attributes.getHeaders(objectMapper, entityProjection.getAttributes()) : Collections.emptyList();
        this.attributes = entityProjection != null && entityProjection.getAttributes() != null ? entityProjection.getAttributes().stream().collect(Collectors.toMap(Attribute::getName, Function.identity())) : Collections.emptyMap();
    }

    @Override
    public void write(PersistentResource<?> resource) throws IOException {
        if (this.recordCount == 0) {
            this.preFormat();
        }
        ++this.recordCount;
        this.format(resource);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.recordCount == 0) {
                this.preFormat();
            }
            this.workbook.write(this.outputStream);
            this.workbook.close();
            super.close();
            this.closed = true;
        }
    }

    public void format(PersistentResource<?> resource) {
        if (resource == null) {
            ++this.rowCount;
            return;
        }
        SXSSFRow row = this.sheet.createRow(this.rowCount++);
        int column = 0;
        Map<String, Object> values = this.getAttributes(resource);
        List<Object> result = this.headers.stream().map(header -> this.getValue((List<String>)header, values)).toList();
        for (Object object : result) {
            SXSSFCell cell = row.createCell(column);
            this.setValue(cell, this.process(object));
            ++column;
        }
    }

    protected Map<String, Object> getAttributes(PersistentResource<?> resource) {
        return Attributes.getAttributes(resource);
    }

    protected Object process(Object object) {
        return object;
    }

    protected void setValue(SXSSFCell cell, Object object) {
        if (object == null) {
            cell.setBlank();
        } else if (object instanceof String) {
            String value = (String)object;
            cell.setCellValue(value);
        } else if (object instanceof Boolean) {
            Boolean value = (Boolean)object;
            cell.setCellValue(value.booleanValue());
        } else if (object instanceof LocalDate) {
            LocalDate value = (LocalDate)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.localDateFormat));
            cell.setCellValue(value);
            cell.setCellStyle(cellStyle);
        } else if (object instanceof LocalDateTime) {
            LocalDateTime value = (LocalDateTime)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.localDateTimeFormat));
            cell.setCellValue(value);
            cell.setCellStyle(cellStyle);
        } else if (object instanceof OffsetDateTime) {
            OffsetDateTime value = (OffsetDateTime)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.localDateTimeFormat));
            cell.setCellValue(value.toLocalDateTime());
            cell.setCellStyle(cellStyle);
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime value = (ZonedDateTime)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.localDateTimeFormat));
            cell.setCellValue(value.toLocalDateTime());
            cell.setCellStyle(cellStyle);
        } else if (object instanceof Instant) {
            Instant value = (Instant)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.dateFormat));
            cell.setCellValue(Date.from(value));
            cell.setCellStyle(cellStyle);
        } else if (object instanceof Date) {
            Date value = (Date)object;
            CreationHelper createHelper = this.workbook.getCreationHelper();
            CellStyle cellStyle = this.workbook.createCellStyle();
            cellStyle.setDataFormat(createHelper.createDataFormat().getFormat(this.dateFormat));
            cell.setCellValue(value);
            cell.setCellStyle(cellStyle);
        } else if (object instanceof Double) {
            Double value = (Double)object;
            cell.setCellValue(value.doubleValue());
        } else if (object instanceof Float) {
            Float value = (Float)object;
            cell.setCellValue((double)value.floatValue());
        } else if (object instanceof Number) {
            Number value = (Number)object;
            cell.setCellValue(value.doubleValue());
        } else if (object instanceof Enum) {
            Enum value = (Enum)object;
            cell.setCellValue(value.name());
        } else if (object instanceof Calendar) {
            Calendar value = (Calendar)object;
            cell.setCellValue(value);
        } else if (object instanceof RichTextString) {
            RichTextString value = (RichTextString)object;
            cell.setCellValue(value);
        } else if (object instanceof Collection) {
            Collection value = (Collection)object;
            cell.setCellValue(this.convertCollection(value));
        } else {
            cell.setCellValue(this.convert(object, String.class));
        }
    }

    protected String convertCollection(Collection<?> value) {
        return String.join((CharSequence)";", value.stream().map(v -> this.convert(v, String.class)).toList());
    }

    protected void generateHeader(EntityProjection projection) {
        if (projection.getAttributes() == null || projection.getAttributes().isEmpty()) {
            return;
        }
        CellStyle cellStyle = this.getHeaderCellStyle();
        SXSSFRow row = this.sheet.createRow(this.rowCount++);
        int column = 0;
        for (List<String> header : this.headers) {
            String headerValue = this.getHeader(header, this.attributes);
            SXSSFCell cell = row.createCell(column);
            cell.setCellStyle(cellStyle);
            cell.setCellValue(headerValue);
            ++column;
        }
    }

    protected String getHeader(List<String> header, Map<String, Attribute> attributes) {
        StringBuilder headerBuilder = new StringBuilder();
        Attribute attribute = attributes.get(header.get(0));
        for (int x = 0; x < header.size(); ++x) {
            String item = header.get(x);
            if (x == 0 && !StringUtils.isEmpty((CharSequence)attribute.getAlias())) {
                item = attribute.getAlias();
            }
            if (x != 0) {
                headerBuilder.append(this.headerSeparator);
            }
            headerBuilder.append(item);
        }
        String arguments = Attributes.getArguments(attribute);
        if (!"".equals(arguments)) {
            headerBuilder.append(arguments);
        }
        String headerValue = headerBuilder.toString();
        return headerValue;
    }

    protected <T> T convert(Object value, Class<T> clazz) {
        return (T)CoerceUtil.coerce((Object)value, clazz);
    }

    public void preFormat() throws IOException {
        if (this.entityProjection == null || !this.writeHeader) {
            return;
        }
        this.generateHeader(this.entityProjection);
    }

    protected CellStyle getHeaderCellStyle() {
        CellStyle cellStyle = this.workbook.createCellStyle();
        Font font = this.workbook.createFont();
        font.setFontHeightInPoints((short)12);
        font.setBold(true);
        cellStyle.setFont(font);
        cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return cellStyle;
    }

    protected Object getValue(List<String> header, Map<String, Object> values) {
        Object value = null;
        for (int x = 0; x < header.size(); ++x) {
            String item = header.get(x);
            value = x == 0 ? values.get(item) : ObjectProperties.getProperty(value, (String)item);
            if (value == null) break;
        }
        return value;
    }
}

