/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.lifecycle.LifeCycleHook;
import com.yahoo.elide.core.security.RequestScope;
import java.security.Principal;
import java.time.Duration;
import java.util.concurrent.Callable;

public abstract class AsyncApiHook<T extends AsyncApi>
implements LifeCycleHook<T> {
    private final AsyncExecutorService asyncExecutorService;
    private final long maxAsyncAfterSeconds;

    protected AsyncApiHook(AsyncExecutorService asyncExecutorService, Duration maxAsyncAfter) {
        this.asyncExecutorService = asyncExecutorService;
        this.maxAsyncAfterSeconds = maxAsyncAfter.toSeconds();
    }

    protected void validateOptions(AsyncApi query, RequestScope requestScope) {
        if ((long)query.getAsyncAfterSeconds().intValue() > this.maxAsyncAfterSeconds) {
            throw new InvalidValueException((Object)"Invalid Async After Seconds");
        }
    }

    protected void executeHook(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, AsyncApi query, RequestScope requestScope, Callable<AsyncApiResult> queryWorker) {
        if (operation.equals((Object)LifeCycleHookBinding.Operation.CREATE)) {
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.PREFLUSH)) {
                this.validateOptions(query, requestScope);
                this.executeAsync(query, queryWorker);
                return;
            }
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.POSTCOMMIT)) {
                this.completeAsync(query, requestScope);
                return;
            }
            if (phase.equals((Object)LifeCycleHookBinding.TransactionPhase.PRESECURITY)) {
                this.updatePrincipalName(query, requestScope);
                return;
            }
        }
        throw new InvalidOperationException("Invalid LifeCycle Hook Invocation");
    }

    protected void completeAsync(AsyncApi query, RequestScope requestScope) {
        this.asyncExecutorService.completeQuery(query, requestScope.getUser(), requestScope.getRoute().getApiVersion());
    }

    protected void executeAsync(AsyncApi query, Callable<AsyncApiResult> callable) {
        if (query.getStatus() == QueryStatus.QUEUED && query.getResult() == null) {
            this.asyncExecutorService.executeQuery(query, callable);
        }
    }

    protected void updatePrincipalName(AsyncApi query, RequestScope requestScope) {
        Principal principal = requestScope.getUser().getPrincipal();
        if (principal != null) {
            query.setPrincipalName(principal.getName());
        }
    }

    public abstract Callable<AsyncApiResult> getOperation(AsyncApi var1, RequestScope var2);

    public AsyncExecutorService getAsyncExecutorService() {
        return this.asyncExecutorService;
    }

    public long getMaxAsyncAfterSeconds() {
        return this.maxAsyncAfterSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncApiHook)) {
            return false;
        }
        AsyncApiHook other = (AsyncApiHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxAsyncAfterSeconds() != other.getMaxAsyncAfterSeconds()) {
            return false;
        }
        AsyncExecutorService this$asyncExecutorService = this.getAsyncExecutorService();
        AsyncExecutorService other$asyncExecutorService = other.getAsyncExecutorService();
        return !(this$asyncExecutorService == null ? other$asyncExecutorService != null : !this$asyncExecutorService.equals(other$asyncExecutorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncApiHook;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxAsyncAfterSeconds = this.getMaxAsyncAfterSeconds();
        result = result * 59 + (int)($maxAsyncAfterSeconds >>> 32 ^ $maxAsyncAfterSeconds);
        AsyncExecutorService $asyncExecutorService = this.getAsyncExecutorService();
        result = result * 59 + ($asyncExecutorService == null ? 43 : $asyncExecutorService.hashCode());
        return result;
    }

    public String toString() {
        return "AsyncApiHook(asyncExecutorService=" + this.getAsyncExecutorService() + ", maxAsyncAfterSeconds=" + this.getMaxAsyncAfterSeconds() + ")";
    }
}

