/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.models;

import com.yahoo.elide.annotation.ComputedAttribute;
import com.yahoo.elide.annotation.CreatePermission;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.UpdatePermission;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.PrincipalOwned;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.models.QueryType;
import jakarta.persistence.Column;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Transient;
import jakarta.validation.constraints.Pattern;
import java.util.Date;
import java.util.UUID;

@MappedSuperclass
public abstract class AsyncApi
implements PrincipalOwned {
    @Id
    @Column(columnDefinition="varchar(36)")
    @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$", message="id not of pattern UUID")
    private @Pattern(regexp="^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$", message="id not of pattern UUID") String id = UUID.randomUUID().toString();
    protected String query;
    protected QueryType queryType;
    @Exclude
    @Column(columnDefinition="varchar(36)")
    protected String requestId = UUID.randomUUID().toString();
    @CreatePermission(expression="Prefab.Role.None")
    private String principalName;
    @UpdatePermission(expression="(Principal is Admin OR Principal is Owner) AND value is Cancelled")
    @CreatePermission(expression="value is Queued")
    @Enumerated(value=EnumType.STRING)
    private QueryStatus status = QueryStatus.QUEUED;
    @CreatePermission(expression="Prefab.Role.None")
    @UpdatePermission(expression="Prefab.Role.None")
    private Date createdOn = new Date();
    @CreatePermission(expression="Prefab.Role.None")
    @UpdatePermission(expression="Prefab.Role.None")
    private Date updatedOn = new Date();
    @Transient
    @ComputedAttribute
    private Integer asyncAfterSeconds = 10;

    public abstract void setResult(AsyncApiResult var1);

    public abstract AsyncApiResult getResult();

    @PreUpdate
    public void preUpdate() {
        this.updatedOn = new Date();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof AsyncApi && this.getClass() == obj.getClass() && this.id.equals(((AsyncApi)obj).id);
    }

    public String getId() {
        return this.id;
    }

    public String getQuery() {
        return this.query;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getPrincipalName() {
        return this.principalName;
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Date getUpdatedOn() {
        return this.updatedOn;
    }

    public Integer getAsyncAfterSeconds() {
        return this.asyncAfterSeconds;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setPrincipalName(String principalName) {
        this.principalName = principalName;
    }

    public void setStatus(QueryStatus status) {
        this.status = status;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public void setUpdatedOn(Date updatedOn) {
        this.updatedOn = updatedOn;
    }

    public void setAsyncAfterSeconds(Integer asyncAfterSeconds) {
        this.asyncAfterSeconds = asyncAfterSeconds;
    }

    public String toString() {
        return "AsyncApi(id=" + this.getId() + ", query=" + this.getQuery() + ", queryType=" + this.getQueryType() + ", requestId=" + this.getRequestId() + ", principalName=" + this.getPrincipalName() + ", status=" + this.getStatus() + ", createdOn=" + this.getCreatedOn() + ", updatedOn=" + this.getUpdatedOn() + ", asyncAfterSeconds=" + this.getAsyncAfterSeconds() + ")";
    }
}

