/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.AsyncSettings;
import com.yahoo.elide.async.ResultTypeFileExtensionMapper;
import com.yahoo.elide.async.export.formatter.ResourceWriter;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.export.validator.SingleRootProjectionValidator;
import com.yahoo.elide.async.export.validator.Validator;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.models.TableExportResult;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.datastore.DataStoreTransaction;
import com.yahoo.elide.core.exceptions.BadRequestException;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.graphql.GraphQLSettings;
import com.yahoo.elide.jsonapi.JsonApiSettings;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public abstract class TableExportOperation
implements Callable<AsyncApiResult> {
    private static final Logger log = LoggerFactory.getLogger(TableExportOperation.class);
    private TableExportFormatter formatter;
    private AsyncExecutorService service;
    private Integer recordNumber = 0;
    private TableExport exportObj;
    private RequestScope scope;
    private ResultStorageEngine engine;
    private List<Validator> validators = new ArrayList<SingleRootProjectionValidator>(Arrays.asList(new SingleRootProjectionValidator()));
    private ResultTypeFileExtensionMapper resultTypeFileExtensionMapper;

    public TableExportOperation(TableExportFormatter formatter, AsyncExecutorService service, AsyncApi exportObj, RequestScope scope, ResultStorageEngine engine, List<Validator> validators, ResultTypeFileExtensionMapper resultTypeFileExtensionMapper) {
        this.formatter = formatter;
        this.service = service;
        this.exportObj = (TableExport)exportObj;
        this.scope = scope;
        this.engine = engine;
        this.validators.addAll(validators);
        this.resultTypeFileExtensionMapper = resultTypeFileExtensionMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncApiResult call() {
        log.debug("TableExport Object from request: {}", (Object)this.exportObj);
        Elide elide = this.service.getElide();
        TableExportResult exportResult = new TableExportResult();
        UUID requestId = UUID.fromString(this.exportObj.getRequestId());
        try (DataStoreTransaction tx = elide.getDataStore().beginTransaction();){
            Flux results;
            Consumer<OutputStream> data;
            TableExportResult result;
            HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
            requestHeaders.put("bypasscache", new ArrayList<String>(Arrays.asList("true")));
            RequestScope requestScope = this.getRequestScope(this.exportObj, this.scope, tx, requestHeaders);
            Collection<EntityProjection> projections = this.getProjections(this.exportObj, requestScope);
            this.validateProjections(projections);
            EntityProjection projection = projections.iterator().next();
            Flux observableResults = Flux.empty();
            elide.getTransactionRegistry().addRunningTransaction(requestId, tx);
            requestScope.setEntityProjection(projection);
            if (projection != null) {
                projection.setPagination(null);
                observableResults = PersistentResource.loadRecords((EntityProjection)projection, Collections.emptyList(), (RequestScope)requestScope);
            }
            if ((result = this.storeResults(this.exportObj, this.engine, data = arg_0 -> this.lambda$call$1(projection, results = observableResults, arg_0))) != null && result.getMessage() != null) {
                throw new IllegalStateException(result.getMessage());
            }
            exportResult.setUrl(new URL(this.generateDownloadURL(this.exportObj, this.scope)));
            exportResult.setRecordCount(this.recordNumber);
            tx.flush(requestScope);
            elide.getAuditLogger().commit();
            tx.commit(requestScope);
        }
        catch (BadRequestException e) {
            exportResult.setMessage(e.getMessage());
        }
        catch (MalformedURLException e) {
            exportResult.setMessage("Download url generation failure.");
        }
        catch (IOException e) {
            log.error("IOException during TableExport", (Throwable)e);
            exportResult.setMessage(e.getMessage());
        }
        catch (Exception e) {
            exportResult.setMessage(e.getMessage());
        }
        finally {
            exportResult.setHttpStatus(200);
            exportResult.setCompletedOn(new Date());
            elide.getTransactionRegistry().removeRunningTransaction(requestId);
            elide.getAuditLogger().clear();
        }
        return exportResult;
    }

    private Flux<String> concatStringWithFlux(String toConcat, Flux<String> observable, boolean stringFirst) {
        if (toConcat == null) {
            return observable;
        }
        return stringFirst ? Flux.just((Object)toConcat).concatWith(observable) : observable.concatWith((Publisher)Flux.just((Object)toConcat));
    }

    public abstract RequestScope getRequestScope(TableExport var1, RequestScope var2, DataStoreTransaction var3, Map<String, List<String>> var4);

    public String generateDownloadURL(TableExport exportObj, RequestScope scope) {
        String graphqlApiPath;
        String jsonApiPath;
        AsyncSettings asyncSettings = (AsyncSettings)scope.getElideSettings().getSettings(AsyncSettings.class);
        JsonApiSettings jsonApiSettings = (JsonApiSettings)scope.getElideSettings().getSettings(JsonApiSettings.class);
        GraphQLSettings graphqlSettings = (GraphQLSettings)scope.getElideSettings().getSettings(GraphQLSettings.class);
        String downloadPath = asyncSettings.getExport().getPath();
        String baseURL = scope.getRoute().getBaseUrl();
        if (jsonApiSettings != null && (jsonApiPath = jsonApiSettings.getPath()) != null && baseURL.endsWith(jsonApiPath)) {
            baseURL = baseURL.substring(0, baseURL.length() - jsonApiPath.length());
        }
        if (graphqlSettings != null && (graphqlApiPath = graphqlSettings.getPath()) != null && baseURL.endsWith(graphqlApiPath)) {
            baseURL = baseURL.substring(0, baseURL.length() - graphqlApiPath.length());
        }
        String tableExportID = this.getTableExportID(exportObj);
        return baseURL + downloadPath + "/" + tableExportID;
    }

    protected TableExportResult storeResults(TableExport exportObj, ResultStorageEngine resultStorageEngine, Consumer<OutputStream> result) {
        return resultStorageEngine.storeResults(this.getTableExportID(exportObj), result);
    }

    protected String getTableExportID(TableExport exportObj) {
        String extension = this.resultTypeFileExtensionMapper != null ? this.resultTypeFileExtensionMapper.getFileExtension(exportObj.getResultType()) : "";
        return exportObj.getId() + extension;
    }

    private void validateProjections(Collection<EntityProjection> projections) {
        this.validators.forEach(validator -> validator.validateProjection(projections));
    }

    public abstract Collection<EntityProjection> getProjections(TableExport var1, RequestScope var2);

    public AsyncExecutorService getService() {
        return this.service;
    }

    private /* synthetic */ void lambda$call$1(EntityProjection projection, Flux results, OutputStream outputStream) {
        try (ResourceWriter writer = this.formatter.newResourceWriter(outputStream, projection, this.exportObj);){
            results.subscribe(resource -> {
                Integer n = this.recordNumber;
                this.recordNumber = this.recordNumber + 1;
                try {
                    writer.write((PersistentResource<?>)resource);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

