/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.async.service.thread.AsyncApiCancelRunnable;
import com.yahoo.elide.async.service.thread.AsyncApiCleanerRunnable;
import jakarta.inject.Inject;
import java.time.Clock;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncCleanerService {
    private static final Logger log = LoggerFactory.getLogger(AsyncCleanerService.class);
    private static final int DEFAULT_CLEANUP_DELAY_MINUTES = 120;
    private static final int MAX_INITIAL_DELAY_MINUTES = 100;
    private static AsyncCleanerService asyncCleanerService = null;

    @Inject
    private AsyncCleanerService(Elide elide, Duration queryMaxRunTime, Duration queryRetentionDuration, Duration queryCancellationCheckInterval, AsyncApiDao asyncQueryDao) {
        Duration queryRunTimeThreshold = Duration.ofSeconds(queryMaxRunTime.getSeconds() * 2L + 30L);
        ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor();
        AsyncApiCleanerRunnable cleanUpTask = new AsyncApiCleanerRunnable(queryRunTimeThreshold, elide, queryRetentionDuration, asyncQueryDao, Clock.systemUTC());
        Random random = new Random();
        int initialDelayMinutes = random.ints(0, 100).limit(1L).findFirst().getAsInt();
        log.debug("Initial Delay for cleaner service is {}", (Object)initialDelayMinutes);
        cleaner.scheduleWithFixedDelay(cleanUpTask, initialDelayMinutes, Math.max(120L, queryRunTimeThreshold.toMinutes()), TimeUnit.MINUTES);
        ScheduledExecutorService cancellation = Executors.newSingleThreadScheduledExecutor();
        AsyncApiCancelRunnable cancelTask = new AsyncApiCancelRunnable(queryMaxRunTime, elide, asyncQueryDao);
        cancellation.scheduleWithFixedDelay(cancelTask, 0L, queryCancellationCheckInterval.toSeconds(), TimeUnit.SECONDS);
    }

    public static void init(Elide elide, Duration queryMaxRunTime, Duration queryRetentionDuration, Duration queryCancellationCheckInterval, AsyncApiDao asyncQueryDao) {
        if (asyncCleanerService == null) {
            asyncCleanerService = new AsyncCleanerService(elide, queryMaxRunTime, queryRetentionDuration, queryCancellationCheckInterval, asyncQueryDao);
        } else {
            log.debug("asyncCleanerService is already initialized.");
        }
    }

    public static synchronized AsyncCleanerService getInstance() {
        return asyncCleanerService;
    }
}

