/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.operation.AsyncApiUpdateOperation;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.jsonapi.JsonApi;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.SimpleDataFetcherExceptionHandler;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutorService {
    private static final Logger log = LoggerFactory.getLogger(AsyncExecutorService.class);
    public static final int DEFAULT_THREAD_POOL_SIZE = 6;
    private Elide elide;
    private JsonApi jsonApi;
    private Map<String, QueryRunner> runners;
    private ExecutorService executor;
    private ExecutorService updater;
    private AsyncApiDao asyncApiDao;
    private ThreadLocal<AsyncApiResultFuture> asyncResultFutureThreadLocal = new ThreadLocal();

    @Inject
    public AsyncExecutorService(Elide elide, ExecutorService executor, ExecutorService updater, AsyncApiDao asyncApiDao, Optional<DataFetcherExceptionHandler> optionalDataFetcherExceptionHandler) {
        this.elide = elide;
        this.runners = new HashMap<String, QueryRunner>();
        for (String apiVersion : elide.getElideSettings().getEntityDictionary().getApiVersions()) {
            this.runners.put(apiVersion, new QueryRunner(elide, apiVersion, optionalDataFetcherExceptionHandler.orElseGet(SimpleDataFetcherExceptionHandler::new)));
        }
        this.jsonApi = new JsonApi(this.elide);
        this.executor = executor;
        this.updater = updater;
        this.asyncApiDao = asyncApiDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(AsyncApi queryObj, Callable<AsyncApiResult> callable) {
        AsyncApiResultFuture resultFuture = new AsyncApiResultFuture();
        try {
            Future<AsyncApiResult> asyncExecuteFuture = this.executor.submit(callable);
            resultFuture.setAsyncFuture(asyncExecuteFuture);
            queryObj.setStatus(QueryStatus.PROCESSING);
            AsyncApiResult queryResultObj = asyncExecuteFuture.get(queryObj.getAsyncAfterSeconds().intValue(), TimeUnit.SECONDS);
            queryObj.setResult(queryResultObj);
            queryObj.setStatus(QueryStatus.COMPLETE);
            queryObj.setUpdatedOn(new Date());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("InterruptedException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (ExecutionException e) {
            log.error("ExecutionException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (TimeoutException e) {
            log.error("TimeoutException: {}", (Object)e.toString());
            resultFuture.setSynchronousTimeout(true);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        finally {
            this.asyncResultFutureThreadLocal.set(resultFuture);
        }
    }

    public void completeQuery(AsyncApi query, User user, String apiVersion) {
        AsyncApiResultFuture asyncApiResultFuture = this.asyncResultFutureThreadLocal.get();
        if (asyncApiResultFuture.isSynchronousTimeout()) {
            log.debug("Task has not completed");
            this.updater.execute(new AsyncApiUpdateOperation(this.elide, asyncApiResultFuture.getAsyncFuture(), query, this.asyncApiDao));
            this.asyncResultFutureThreadLocal.remove();
        } else {
            log.debug("Task has completed");
        }
    }

    public Elide getElide() {
        return this.elide;
    }

    public JsonApi getJsonApi() {
        return this.jsonApi;
    }

    public Map<String, QueryRunner> getRunners() {
        return this.runners;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ExecutorService getUpdater() {
        return this.updater;
    }

    public AsyncApiDao getAsyncApiDao() {
        return this.asyncApiDao;
    }

    public ThreadLocal<AsyncApiResultFuture> getAsyncResultFutureThreadLocal() {
        return this.asyncResultFutureThreadLocal;
    }

    private static class AsyncApiResultFuture {
        private Future<AsyncApiResult> asyncFuture;
        private boolean synchronousTimeout = false;

        public Future<AsyncApiResult> getAsyncFuture() {
            return this.asyncFuture;
        }

        public boolean isSynchronousTimeout() {
            return this.synchronousTimeout;
        }

        public void setAsyncFuture(Future<AsyncApiResult> asyncFuture) {
            this.asyncFuture = asyncFuture;
        }

        public void setSynchronousTimeout(boolean synchronousTimeout) {
            this.synchronousTimeout = synchronousTimeout;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncApiResultFuture)) {
                return false;
            }
            AsyncApiResultFuture other = (AsyncApiResultFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSynchronousTimeout() != other.isSynchronousTimeout()) {
                return false;
            }
            Future<AsyncApiResult> this$asyncFuture = this.getAsyncFuture();
            Future<AsyncApiResult> other$asyncFuture = other.getAsyncFuture();
            return !(this$asyncFuture == null ? other$asyncFuture != null : !this$asyncFuture.equals(other$asyncFuture));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AsyncApiResultFuture;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSynchronousTimeout() ? 79 : 97);
            Future<AsyncApiResult> $asyncFuture = this.getAsyncFuture();
            result = result * 59 + ($asyncFuture == null ? 43 : $asyncFuture.hashCode());
            return result;
        }

        public String toString() {
            return "AsyncExecutorService.AsyncApiResultFuture(asyncFuture=" + this.getAsyncFuture() + ", synchronousTimeout=" + this.isSynchronousTimeout() + ")";
        }
    }
}

