/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service.thread;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.filter.expression.AndFilterExpression;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.core.filter.predicates.InPredicate;
import com.yahoo.elide.core.filter.predicates.LEPredicate;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncApiCleanerRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AsyncApiCleanerRunnable.class);
    private Duration queryMaxRunTime;
    private Elide elide;
    private Duration queryRetentionDuration;
    private AsyncApiDao asyncApiDao;
    private Clock clock;

    @Override
    public void run() {
        this.deleteAsyncApi(AsyncQuery.class);
        this.timeoutAsyncApi(AsyncQuery.class);
    }

    protected <T extends AsyncApi> void deleteAsyncApi(Class<T> type) {
        try {
            Date cleanupDate = Date.from(Instant.now(this.clock).plus(this.queryRetentionDuration));
            Path.PathElement createdOnPathElement = new Path.PathElement(type, Long.class, "createdOn");
            LEPredicate fltDeleteExp = new LEPredicate(createdOnPathElement, (Object)cleanupDate);
            this.asyncApiDao.deleteAsyncApiAndResultByFilter((FilterExpression)fltDeleteExp, type);
        }
        catch (Exception e) {
            log.error("Exception in scheduled cleanup: {}", (Object)e.toString());
        }
    }

    protected <T extends AsyncApi> void timeoutAsyncApi(Class<T> type) {
        try {
            Date filterDate = Date.from(Instant.now(this.clock).plus(this.queryMaxRunTime));
            Path.PathElement createdOnPathElement = new Path.PathElement(type, Long.class, "createdOn");
            Path.PathElement statusPathElement = new Path.PathElement(type, String.class, "status");
            InPredicate inPredicate = new InPredicate(statusPathElement, (Object[])new QueryStatus[]{QueryStatus.PROCESSING, QueryStatus.QUEUED});
            LEPredicate lePredicate = new LEPredicate(createdOnPathElement, (Object)filterDate);
            AndFilterExpression fltTimeoutExp = new AndFilterExpression((FilterExpression)inPredicate, (FilterExpression)lePredicate);
            this.asyncApiDao.updateStatusAsyncApiByFilter((FilterExpression)fltTimeoutExp, QueryStatus.TIMEDOUT, type);
        }
        catch (Exception e) {
            log.error("Exception in scheduled cleanup: {}", (Object)e.toString());
        }
    }

    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    public Elide getElide() {
        return this.elide;
    }

    public Duration getQueryRetentionDuration() {
        return this.queryRetentionDuration;
    }

    public AsyncApiDao getAsyncApiDao() {
        return this.asyncApiDao;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
    }

    public void setElide(Elide elide) {
        this.elide = elide;
    }

    public void setQueryRetentionDuration(Duration queryRetentionDuration) {
        this.queryRetentionDuration = queryRetentionDuration;
    }

    public void setAsyncApiDao(AsyncApiDao asyncApiDao) {
        this.asyncApiDao = asyncApiDao;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncApiCleanerRunnable)) {
            return false;
        }
        AsyncApiCleanerRunnable other = (AsyncApiCleanerRunnable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Duration this$queryMaxRunTime = this.getQueryMaxRunTime();
        Duration other$queryMaxRunTime = other.getQueryMaxRunTime();
        if (this$queryMaxRunTime == null ? other$queryMaxRunTime != null : !((Object)this$queryMaxRunTime).equals(other$queryMaxRunTime)) {
            return false;
        }
        Elide this$elide = this.getElide();
        Elide other$elide = other.getElide();
        if (this$elide == null ? other$elide != null : !this$elide.equals(other$elide)) {
            return false;
        }
        Duration this$queryRetentionDuration = this.getQueryRetentionDuration();
        Duration other$queryRetentionDuration = other.getQueryRetentionDuration();
        if (this$queryRetentionDuration == null ? other$queryRetentionDuration != null : !((Object)this$queryRetentionDuration).equals(other$queryRetentionDuration)) {
            return false;
        }
        AsyncApiDao this$asyncApiDao = this.getAsyncApiDao();
        AsyncApiDao other$asyncApiDao = other.getAsyncApiDao();
        if (this$asyncApiDao == null ? other$asyncApiDao != null : !this$asyncApiDao.equals(other$asyncApiDao)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AsyncApiCleanerRunnable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Duration $queryMaxRunTime = this.getQueryMaxRunTime();
        result = result * 59 + ($queryMaxRunTime == null ? 43 : ((Object)$queryMaxRunTime).hashCode());
        Elide $elide = this.getElide();
        result = result * 59 + ($elide == null ? 43 : $elide.hashCode());
        Duration $queryRetentionDuration = this.getQueryRetentionDuration();
        result = result * 59 + ($queryRetentionDuration == null ? 43 : ((Object)$queryRetentionDuration).hashCode());
        AsyncApiDao $asyncApiDao = this.getAsyncApiDao();
        result = result * 59 + ($asyncApiDao == null ? 43 : $asyncApiDao.hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncApiCleanerRunnable(queryMaxRunTime=" + this.getQueryMaxRunTime() + ", elide=" + this.getElide() + ", queryRetentionDuration=" + this.getQueryRetentionDuration() + ", asyncApiDao=" + this.getAsyncApiDao() + ", clock=" + this.getClock() + ")";
    }

    public AsyncApiCleanerRunnable(Duration queryMaxRunTime, Elide elide, Duration queryRetentionDuration, AsyncApiDao asyncApiDao, Clock clock) {
        this.queryMaxRunTime = queryMaxRunTime;
        this.elide = elide;
        this.queryRetentionDuration = queryRetentionDuration;
        this.asyncApiDao = asyncApiDao;
        this.clock = clock;
    }
}

