/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.export.formatter;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.elide.async.export.formatter.Attributes;
import com.yahoo.elide.async.export.formatter.ResourceWriterSupport;
import com.yahoo.elide.core.PersistentResource;
import com.yahoo.elide.core.request.Attribute;
import com.yahoo.elide.core.request.EntityProjection;
import com.yahoo.elide.core.utils.coerce.CoerceUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CsvResourceWriter
extends ResourceWriterSupport {
    private static final String DEFAULT_LIST_SEPARATOR = ";";
    private static final String DEFAULT_HEADER_SEPARATOR = "_";
    private static final String DEFAULT_ITEM_SEPARATOR = ",";
    private static final String DEFAULT_LINE_SEPARATOR = "\r\n";
    protected final boolean writeHeader;
    protected final ObjectMapper objectMapper;
    protected final EntityProjection entityProjection;
    protected List<List<String>> headers;
    protected String listSeparator = ";";
    protected String headerSeparator = "_";
    protected String itemSeparator = ",";
    protected String lineSeparator = "\r\n";
    protected int recordCount = 0;

    public CsvResourceWriter(OutputStream outputStream, ObjectMapper objectMapper, boolean writeHeader, EntityProjection entityProjection) {
        super(outputStream);
        this.writeHeader = writeHeader;
        this.objectMapper = objectMapper;
        this.entityProjection = entityProjection;
        this.headers = entityProjection != null ? Attributes.getHeaders(objectMapper, entityProjection.getAttributes()) : Collections.emptyList();
    }

    @Override
    public void write(PersistentResource<?> resource) throws IOException {
        if (this.recordCount == 0) {
            this.preFormat(this.outputStream);
        }
        ++this.recordCount;
        this.format(resource);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            if (this.recordCount == 0) {
                this.preFormat(this.outputStream);
            }
            super.close();
            this.closed = true;
        }
    }

    public void format(PersistentResource<?> resource) throws IOException {
        if (resource == null) {
            return;
        }
        Map<String, Object> values = this.getAttributes(resource);
        List<Object> result = this.headers.stream().map(header -> this.getValue((List<String>)header, values)).toList();
        String line = result.stream().map(this::toString).map(this::quote).collect(Collectors.joining(this.itemSeparator));
        this.write(line + this.lineSeparator);
    }

    protected Map<String, Object> getAttributes(PersistentResource<?> resource) {
        return (Map)this.objectMapper.convertValue(Attributes.getAttributes(resource), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public void preFormat(OutputStream outputStream) throws IOException {
        if (this.entityProjection == null || !this.writeHeader) {
            return;
        }
        this.write(this.generateHeader(this.entityProjection));
    }

    protected String generateHeader(EntityProjection projection) {
        if (projection.getAttributes() == null) {
            return "";
        }
        Map attributes = projection.getAttributes().stream().collect(Collectors.toMap(Attribute::getName, Function.identity()));
        String result = this.headers.stream().map(header -> {
            String headerValue = this.getHeader((List<String>)header, attributes);
            return this.quote(headerValue);
        }).collect(Collectors.joining(this.itemSeparator));
        if (!"".equals(result)) {
            return result + this.lineSeparator;
        }
        return result;
    }

    protected String getHeader(List<String> header, Map<String, Attribute> attributes) {
        StringBuilder headerBuilder = new StringBuilder();
        Attribute attribute = attributes.get(header.get(0));
        for (int x = 0; x < header.size(); ++x) {
            String item = header.get(x);
            if (x == 0 && !StringUtils.isEmpty((CharSequence)attribute.getAlias())) {
                item = attribute.getAlias();
            }
            if (x != 0) {
                headerBuilder.append(this.headerSeparator);
            }
            headerBuilder.append(item);
        }
        String arguments = Attributes.getArguments(attribute);
        if (!"".equals(arguments)) {
            headerBuilder.append(arguments);
        }
        return headerBuilder.toString();
    }

    protected String toString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return this.convertCollection(collection);
        }
        return this.convert(object, String.class);
    }

    protected <T> T convert(Object value, Class<T> clazz) {
        return (T)CoerceUtil.coerce((Object)value, clazz);
    }

    protected String convertCollection(Collection<?> collection) {
        return collection.stream().map(this::toString).collect(Collectors.joining(this.listSeparator));
    }

    protected Object getValue(List<String> header, Map<String, Object> values) {
        Object value = null;
        for (int x = 0; x < header.size(); ++x) {
            String item = header.get(x);
            if (x == 0) {
                value = values.get(item);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map map = (Map)value;
            value = map.get(item);
        }
        return value;
    }

    protected String quote(String toQuote) {
        String escaped = toQuote.replace("\"", "\"\"");
        return "\"" + escaped + "\"";
    }
}

