/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.hooks.AsyncApiHook;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.models.QueryType;
import com.yahoo.elide.async.operation.AsyncQueryOperation;
import com.yahoo.elide.async.operation.GraphQLAsyncQueryOperation;
import com.yahoo.elide.async.operation.JsonApiAsyncQueryOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.QueryRunners;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;

public class AsyncQueryHook
extends AsyncApiHook<AsyncQuery> {
    public AsyncQueryHook(AsyncExecutorService asyncExecutorService, Duration maxAsyncAfter) {
        super(asyncExecutorService, maxAsyncAfter);
    }

    public void execute(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, AsyncQuery query, RequestScope requestScope, Optional<ChangeSpec> changes) {
        Callable<AsyncApiResult> callable = this.getOperation(query, requestScope);
        this.executeHook(operation, phase, query, requestScope, callable);
    }

    @Override
    public void validateOptions(AsyncApi query, RequestScope requestScope) {
        QueryRunner runner;
        super.validateOptions(query, requestScope);
        if (query.getQueryType().equals((Object)QueryType.GRAPHQL_V1_0) && (runner = this.getAsyncExecutorService().getProviders().getProvider(QueryRunners.class).getRunner(requestScope.getRoute().getApiVersion())) == null) {
            throw new InvalidOperationException("Invalid API Version");
        }
    }

    @Override
    public Callable<AsyncApiResult> getOperation(AsyncApi query, RequestScope requestScope) {
        AsyncQueryOperation operation = null;
        operation = query.getQueryType().equals((Object)QueryType.JSONAPI_V1_0) ? new JsonApiAsyncQueryOperation(this.getAsyncExecutorService(), query, (com.yahoo.elide.core.RequestScope)requestScope) : new GraphQLAsyncQueryOperation(this.getAsyncExecutorService(), query, (com.yahoo.elide.core.RequestScope)requestScope);
        return operation;
    }
}

