/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.hooks;

import com.yahoo.elide.annotation.LifeCycleHookBinding;
import com.yahoo.elide.async.AsyncSettings;
import com.yahoo.elide.async.ResultTypeFileExtensionMapper;
import com.yahoo.elide.async.export.formatter.TableExportFormatter;
import com.yahoo.elide.async.hooks.AsyncApiHook;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.QueryType;
import com.yahoo.elide.async.models.TableExport;
import com.yahoo.elide.async.operation.GraphQLTableExportOperation;
import com.yahoo.elide.async.operation.JsonApiTableExportOperation;
import com.yahoo.elide.async.operation.TableExportOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.ChangeSpec;
import com.yahoo.elide.core.security.RequestScope;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;

public class TableExportHook
extends AsyncApiHook<TableExport> {
    private final Map<String, TableExportFormatter> supportedFormatters;
    private final ResultStorageEngine engine;
    private final ResultTypeFileExtensionMapper resultTypeFileExtensionMapper;

    public TableExportHook(AsyncExecutorService asyncExecutorService, Duration maxAsyncAfter, Map<String, TableExportFormatter> supportedFormatters, ResultStorageEngine engine, ResultTypeFileExtensionMapper resultTypeFileExtensionMapper) {
        super(asyncExecutorService, maxAsyncAfter);
        this.supportedFormatters = supportedFormatters;
        this.engine = engine;
        this.resultTypeFileExtensionMapper = resultTypeFileExtensionMapper;
    }

    public void execute(LifeCycleHookBinding.Operation operation, LifeCycleHookBinding.TransactionPhase phase, TableExport export, RequestScope requestScope, Optional<ChangeSpec> changes) {
        Callable<AsyncApiResult> callable = this.getOperation(export, requestScope);
        this.executeHook(operation, phase, export, requestScope, callable);
    }

    @Override
    public void validateOptions(AsyncApi export, RequestScope requestScope) {
        AsyncSettings asyncSettings = (AsyncSettings)requestScope.getElideSettings().getSettings(AsyncSettings.class);
        if (!asyncSettings.getExport().isEnabled()) {
            throw new InvalidOperationException("TableExport is not supported.");
        }
        super.validateOptions(export, requestScope);
    }

    @Override
    public Callable<AsyncApiResult> getOperation(AsyncApi export, RequestScope requestScope) {
        TableExportOperation operation = null;
        TableExport exportObj = (TableExport)export;
        String resultType = exportObj.getResultType();
        QueryType queryType = exportObj.getQueryType();
        com.yahoo.elide.core.RequestScope scope = (com.yahoo.elide.core.RequestScope)requestScope;
        TableExportFormatter formatter = this.supportedFormatters.get(resultType);
        if (formatter == null) {
            throw new InvalidOperationException("Formatter unavailable for " + resultType);
        }
        if (queryType.equals((Object)QueryType.GRAPHQL_V1_0)) {
            operation = new GraphQLTableExportOperation(formatter, this.getAsyncExecutorService(), export, scope, this.engine, this.resultTypeFileExtensionMapper);
        } else if (queryType.equals((Object)QueryType.JSONAPI_V1_0)) {
            operation = new JsonApiTableExportOperation(formatter, this.getAsyncExecutorService(), export, scope, this.engine, this.resultTypeFileExtensionMapper);
        } else {
            throw new InvalidOperationException(queryType + "is not supported");
        }
        return operation;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableExportHook)) {
            return false;
        }
        TableExportHook other = (TableExportHook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, TableExportFormatter> this$supportedFormatters = this.supportedFormatters;
        Map<String, TableExportFormatter> other$supportedFormatters = other.supportedFormatters;
        if (this$supportedFormatters == null ? other$supportedFormatters != null : !((Object)this$supportedFormatters).equals(other$supportedFormatters)) {
            return false;
        }
        ResultStorageEngine this$engine = this.engine;
        ResultStorageEngine other$engine = other.engine;
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        ResultTypeFileExtensionMapper this$resultTypeFileExtensionMapper = this.resultTypeFileExtensionMapper;
        ResultTypeFileExtensionMapper other$resultTypeFileExtensionMapper = other.resultTypeFileExtensionMapper;
        return !(this$resultTypeFileExtensionMapper == null ? other$resultTypeFileExtensionMapper != null : !this$resultTypeFileExtensionMapper.equals(other$resultTypeFileExtensionMapper));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableExportHook;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, TableExportFormatter> $supportedFormatters = this.supportedFormatters;
        result = result * 59 + ($supportedFormatters == null ? 43 : ((Object)$supportedFormatters).hashCode());
        ResultStorageEngine $engine = this.engine;
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        ResultTypeFileExtensionMapper $resultTypeFileExtensionMapper = this.resultTypeFileExtensionMapper;
        result = result * 59 + ($resultTypeFileExtensionMapper == null ? 43 : $resultTypeFileExtensionMapper.hashCode());
        return result;
    }
}

