/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.function.Consumer;

public class ByteSinkOutputStream
extends OutputStream {
    private final Consumer<byte[]> byteSink;

    public ByteSinkOutputStream(Consumer<byte[]> byteSink) {
        this.byteSink = Objects.requireNonNull(byteSink, "byteSink should not be null");
    }

    @Override
    public void write(int b) throws IOException {
        this.byteSink.accept(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.byteSink.accept(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] dest = new byte[len];
        System.arraycopy(b, off, dest, 0, len);
        this.byteSink.accept(dest);
    }
}

