/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.operation.AsyncQueryOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.exceptions.InvalidOperationException;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.graphql.QueryRunner;
import com.yahoo.elide.graphql.QueryRunners;
import java.net.URISyntaxException;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLAsyncQueryOperation
extends AsyncQueryOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLAsyncQueryOperation.class);

    public GraphQLAsyncQueryOperation(AsyncExecutorService service, AsyncApi queryObj, RequestScope scope) {
        super(service, queryObj, scope);
    }

    @Override
    public ElideResponse<String> execute(AsyncApi queryObj, RequestScope scope) throws URISyntaxException {
        User user = scope.getUser();
        String apiVersion = scope.getRoute().getApiVersion();
        QueryRunner runner = this.getService().getProviders().getProvider(QueryRunners.class).getRunner(apiVersion);
        if (runner == null) {
            throw new InvalidOperationException("Invalid API Version");
        }
        UUID requestUUID = UUID.fromString(queryObj.getRequestId());
        ElideResponse response = runner.run(scope.getRoute().getBaseUrl(), queryObj.getQuery(), user, requestUUID, scope.getRoute().getHeaders());
        log.debug("GRAPHQL_V1_0 getResponseCode: {}, GRAPHQL_V1_0 getBody: {}", (Object)response.getStatus(), response.getBody());
        return response;
    }

    @Override
    public Integer calculateRecordCount(AsyncQuery queryObj, ElideResponse<String> response) {
        Integer count = 0;
        if (response.getStatus() == 200) {
            count = GraphQLAsyncQueryOperation.safeJsonPathLength((String)response.getBody(), "$..edges.length()");
        }
        return count;
    }
}

