/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.operation;

import com.yahoo.elide.ElideResponse;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncQuery;
import com.yahoo.elide.async.operation.AsyncQueryOperation;
import com.yahoo.elide.async.service.AsyncExecutorService;
import com.yahoo.elide.core.RequestScope;
import com.yahoo.elide.core.request.route.Route;
import com.yahoo.elide.core.security.User;
import com.yahoo.elide.jsonapi.JsonApi;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiAsyncQueryOperation
extends AsyncQueryOperation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonApiAsyncQueryOperation.class);

    public JsonApiAsyncQueryOperation(AsyncExecutorService service, AsyncApi queryObj, RequestScope scope) {
        super(service, queryObj, scope);
    }

    @Override
    public ElideResponse<String> execute(AsyncApi queryObj, RequestScope scope) throws URISyntaxException {
        JsonApi jsonApi = this.getService().getProviders().getProvider(JsonApi.class);
        User user = scope.getUser();
        String apiVersion = scope.getRoute().getApiVersion();
        UUID requestUUID = UUID.fromString(queryObj.getRequestId());
        URIBuilder uri = new URIBuilder(queryObj.getQuery());
        Map<String, List<String>> queryParams = JsonApiAsyncQueryOperation.getQueryParams(uri);
        log.debug("Extracted QueryParams from AsyncQuery Object: {}", queryParams);
        Route route = Route.builder().baseUrl(scope.getRoute().getBaseUrl()).path(JsonApiAsyncQueryOperation.getPath(uri)).parameters(queryParams).headers(scope.getRoute().getHeaders()).apiVersion(apiVersion).build();
        ElideResponse response = jsonApi.get(route, user, requestUUID);
        log.debug("JSONAPI_V1_0 getResponseCode: {}, JSONAPI_V1_0 getBody: {}", (Object)response.getStatus(), response.getBody());
        return response;
    }

    public static Map<String, List<String>> getQueryParams(URIBuilder uri) {
        LinkedHashMap<String, List<String>> queryParams = new LinkedHashMap<String, List<String>>();
        for (NameValuePair queryParam : uri.getQueryParams()) {
            queryParams.computeIfAbsent(queryParam.getName(), key -> new ArrayList()).add(queryParam.getValue());
        }
        return queryParams;
    }

    public static String getPath(URIBuilder uri) {
        return uri.getPath();
    }

    @Override
    public Integer calculateRecordCount(AsyncQuery queryObj, ElideResponse<String> response) {
        Integer count = null;
        if (response.getStatus() == 200) {
            count = JsonApiAsyncQueryOperation.safeJsonPathLength((String)response.getBody(), "$.data.length()");
        }
        return count;
    }
}

