/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.resources;

import com.yahoo.elide.async.service.storageengine.ResultStorageEngine;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/")
public class ExportApiEndpoint {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExportApiEndpoint.class);
    protected final ExportApiProperties exportApiProperties;
    protected final ResultStorageEngine resultStorageEngine;

    @Inject
    public ExportApiEndpoint(@Named(value="resultStorageEngine") ResultStorageEngine resultStorageEngine, @Named(value="exportApiProperties") ExportApiProperties exportApiProperties) {
        this.resultStorageEngine = resultStorageEngine;
        this.exportApiProperties = exportApiProperties;
    }

    @GET
    @Path(value="/{asyncQueryId}")
    public void get(@PathParam(value="asyncQueryId") String asyncQueryId, @Context HttpServletResponse httpServletResponse, @Suspended AsyncResponse asyncResponse) {
        asyncResponse.setTimeout(this.exportApiProperties.getMaxDownloadTime().toSeconds(), TimeUnit.SECONDS);
        asyncResponse.setTimeoutHandler(async -> {
            Response.ResponseBuilder resp = Response.status((Response.Status)Response.Status.REQUEST_TIMEOUT).entity((Object)"Timed out.");
            async.resume((Object)resp.build());
        });
        this.exportApiProperties.getExecutor().submit(() -> {
            Consumer<OutputStream> observableResults = this.resultStorageEngine.getResultsByID(asyncQueryId);
            StreamingOutput streamingOutput = outputStream -> {
                block8: {
                    try {
                        observableResults.accept(outputStream);
                    }
                    catch (RuntimeException e) {
                        String message = e.getMessage();
                        try {
                            log.debug(message);
                            if (message != null && message.equals("Unable to retrieve results.")) {
                                httpServletResponse.sendError(404, asyncQueryId + " Not Found");
                                break block8;
                            }
                            httpServletResponse.sendError(500);
                        }
                        catch (IllegalStateException ise) {
                            outputStream.write("Error Occured....".concat(System.lineSeparator()).getBytes());
                            log.debug(ise.getMessage());
                        }
                    }
                    finally {
                        outputStream.flush();
                        outputStream.close();
                    }
                }
            };
            asyncResponse.resume((Object)Response.ok((Object)streamingOutput, (String)"application/octet-stream").header("Content-Disposition", (Object)("attachment; filename=" + asyncQueryId)).build());
        });
    }

    public static class ExportApiProperties {
        private ExecutorService executor;
        private Duration maxDownloadTime;

        @Generated
        public ExecutorService getExecutor() {
            return this.executor;
        }

        @Generated
        public Duration getMaxDownloadTime() {
            return this.maxDownloadTime;
        }

        @Generated
        public void setExecutor(ExecutorService executor) {
            this.executor = executor;
        }

        @Generated
        public void setMaxDownloadTime(Duration maxDownloadTime) {
            this.maxDownloadTime = maxDownloadTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExportApiProperties)) {
                return false;
            }
            ExportApiProperties other = (ExportApiProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ExecutorService this$executor = this.getExecutor();
            ExecutorService other$executor = other.getExecutor();
            if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
                return false;
            }
            Duration this$maxDownloadTime = this.getMaxDownloadTime();
            Duration other$maxDownloadTime = other.getMaxDownloadTime();
            return !(this$maxDownloadTime == null ? other$maxDownloadTime != null : !((Object)this$maxDownloadTime).equals(other$maxDownloadTime));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExportApiProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            Duration $maxDownloadTime = this.getMaxDownloadTime();
            result = result * 59 + ($maxDownloadTime == null ? 43 : ((Object)$maxDownloadTime).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExportApiEndpoint.ExportApiProperties(executor=" + this.getExecutor() + ", maxDownloadTime=" + this.getMaxDownloadTime() + ")";
        }

        @Generated
        public ExportApiProperties(ExecutorService executor, Duration maxDownloadTime) {
            this.executor = executor;
            this.maxDownloadTime = maxDownloadTime;
        }
    }
}

