/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import com.yahoo.elide.Elide;
import com.yahoo.elide.async.models.AsyncApi;
import com.yahoo.elide.async.models.AsyncApiResult;
import com.yahoo.elide.async.models.QueryStatus;
import com.yahoo.elide.async.operation.AsyncApiUpdateOperation;
import com.yahoo.elide.async.service.AsyncProviderService;
import com.yahoo.elide.async.service.dao.AsyncApiDao;
import com.yahoo.elide.core.security.User;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncExecutorService.class);
    public static final int DEFAULT_THREAD_POOL_SIZE = 6;
    private final Elide elide;
    private final ExecutorService executor;
    private final ExecutorService updater;
    private final AsyncApiDao asyncApiDao;
    private final ThreadLocal<AsyncApiResultFuture> asyncResultFutureThreadLocal = new ThreadLocal();
    private final AsyncProviderService providers;

    @Inject
    public AsyncExecutorService(Elide elide, ExecutorService executor, ExecutorService updater, AsyncApiDao asyncApiDao, AsyncProviderService asyncProviderService) {
        this.elide = elide;
        this.executor = executor;
        this.updater = updater;
        this.asyncApiDao = asyncApiDao;
        this.providers = asyncProviderService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(AsyncApi queryObj, Callable<AsyncApiResult> callable) {
        AsyncApiResultFuture resultFuture = new AsyncApiResultFuture();
        try {
            Future<AsyncApiResult> asyncExecuteFuture = this.executor.submit(callable);
            resultFuture.setAsyncFuture(asyncExecuteFuture);
            queryObj.setStatus(QueryStatus.PROCESSING);
            AsyncApiResult queryResultObj = asyncExecuteFuture.get(queryObj.getAsyncAfterSeconds().intValue(), TimeUnit.SECONDS);
            queryObj.setResult(queryResultObj);
            queryObj.setStatus(QueryStatus.COMPLETE);
            queryObj.setUpdatedOn(new Date());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("InterruptedException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (ExecutionException e) {
            log.error("ExecutionException: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        catch (TimeoutException e) {
            log.error("TimeoutException: {}", (Object)e.toString());
            resultFuture.setSynchronousTimeout(true);
        }
        catch (Exception e) {
            log.error("Exception: {}", (Object)e.toString());
            queryObj.setStatus(QueryStatus.FAILURE);
        }
        finally {
            this.asyncResultFutureThreadLocal.set(resultFuture);
        }
    }

    public void completeQuery(AsyncApi query, User user, String apiVersion) {
        AsyncApiResultFuture asyncApiResultFuture = this.asyncResultFutureThreadLocal.get();
        if (asyncApiResultFuture.isSynchronousTimeout()) {
            log.debug("Task has not completed");
            this.updater.execute(new AsyncApiUpdateOperation(this.elide, asyncApiResultFuture.getAsyncFuture(), query, this.asyncApiDao));
            this.asyncResultFutureThreadLocal.remove();
        } else {
            log.debug("Task has completed");
        }
    }

    @Generated
    public Elide getElide() {
        return this.elide;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public ExecutorService getUpdater() {
        return this.updater;
    }

    @Generated
    public AsyncApiDao getAsyncApiDao() {
        return this.asyncApiDao;
    }

    @Generated
    public ThreadLocal<AsyncApiResultFuture> getAsyncResultFutureThreadLocal() {
        return this.asyncResultFutureThreadLocal;
    }

    @Generated
    public AsyncProviderService getProviders() {
        return this.providers;
    }

    private static class AsyncApiResultFuture {
        private Future<AsyncApiResult> asyncFuture;
        private boolean synchronousTimeout = false;

        @Generated
        public AsyncApiResultFuture() {
        }

        @Generated
        public Future<AsyncApiResult> getAsyncFuture() {
            return this.asyncFuture;
        }

        @Generated
        public boolean isSynchronousTimeout() {
            return this.synchronousTimeout;
        }

        @Generated
        public void setAsyncFuture(Future<AsyncApiResult> asyncFuture) {
            this.asyncFuture = asyncFuture;
        }

        @Generated
        public void setSynchronousTimeout(boolean synchronousTimeout) {
            this.synchronousTimeout = synchronousTimeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AsyncApiResultFuture)) {
                return false;
            }
            AsyncApiResultFuture other = (AsyncApiResultFuture)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSynchronousTimeout() != other.isSynchronousTimeout()) {
                return false;
            }
            Future<AsyncApiResult> this$asyncFuture = this.getAsyncFuture();
            Future<AsyncApiResult> other$asyncFuture = other.getAsyncFuture();
            return !(this$asyncFuture == null ? other$asyncFuture != null : !this$asyncFuture.equals(other$asyncFuture));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AsyncApiResultFuture;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSynchronousTimeout() ? 79 : 97);
            Future<AsyncApiResult> $asyncFuture = this.getAsyncFuture();
            result = result * 59 + ($asyncFuture == null ? 43 : $asyncFuture.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncExecutorService.AsyncApiResultFuture(asyncFuture=" + this.getAsyncFuture() + ", synchronousTimeout=" + this.isSynchronousTimeout() + ")";
        }
    }
}

