/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.async.service;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AsyncProviderService {
    private final Map<String, Object> providers;

    public AsyncProviderService(Map<String, Object> providers) {
        this.providers = providers;
    }

    public <T> T getProvider(Class<T> clazz) {
        return clazz.cast(this.providers.get(clazz.getName()));
    }

    public static AsyncProviderServiceBuilder builder() {
        return new AsyncProviderServiceBuilder();
    }

    public static class AsyncProviderServiceBuilder
    extends AsyncProviderServiceBuilderSupport<AsyncProviderServiceBuilder> {
        public AsyncProviderService build() {
            return new AsyncProviderService(this.providers);
        }

        @Override
        public AsyncProviderServiceBuilder self() {
            return this;
        }
    }

    public static abstract class AsyncProviderServiceBuilderSupport<S> {
        protected Map<String, Object> providers = new HashMap<String, Object>();

        public abstract S self();

        public S providers(Map<String, Object> providers) {
            this.providers = providers;
            return this.self();
        }

        public S providers(Consumer<Map<String, Object>> customizer) {
            customizer.accept(this.providers);
            return this.self();
        }

        public <T> S provider(Class<T> clazz, T provider) {
            this.providers.put(clazz.getName(), provider);
            return this.self();
        }
    }
}

